/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.OwnedIdentityToBindCell;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class OwnedIdentityToBindSelectionController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("select_an_identity_to_bind_title_label", null, "selected_identity_details_warning_label", null, null);
    public final StackPane rootContainer = new StackPane();
    public final VBox mainVbox = new VBox();
    public final Button validateButton = new Button();
    public final VBox ownedIdentitiesListViewContainer = new VBox();
    private final StandardPanelListController<OwnedIdentityInfo> ownedIdentityListViewController;
    private final BooleanProperty clicked = new SimpleBooleanProperty(false);

    public OwnedIdentityToBindSelectionController(FlowStackContext<IdentityManagementFlow> identityCreationFlowContext, IdentityManagementFlowModel identityManagementFlowModel) {
        this.ownedIdentityListViewController = StandardPanelListController.builder().withLiveData(identityManagementFlowModel.getOwnedIdentities()).withDataClass(OwnedIdentityInfo.class).withCellFactory((Callback<ListView<OwnedIdentityInfo>, AbstractListCell<OwnedIdentityInfo>>)((Callback)param -> new OwnedIdentityToBindCell(this.clicked))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(true).withoutButton().build();
        this.ownedIdentitiesListViewContainer.getChildren().add((Object)this.ownedIdentityListViewController.getLayout());
        ViewControllerHelper.smartUIUpdate(() -> this.ownedIdentityListViewController.getListView().setFixedCellSize(70.0));
        this.validateButton.getStyleClass().addAll((Object[])new String[]{"primary-button"});
        this.validateButton.minWidthProperty().bind((ObservableValue)this.rootContainer.minWidthProperty());
        this.validateButton.setAlignment(Pos.CENTER);
        this.validateButton.setOnMouseClicked(this::bindButtonHandler);
        this.validateButton.setText(ViewControllerHelper.getString("on_boarding_flow_keycloak_binding_existing"));
        this.validateButton.disableProperty().bind((ObservableValue)this.ownedIdentityListViewController.getSelectionModel().hasSelectedItemsProperty().not());
        this.mainVbox.getChildren().addAll((Object[])new Node[]{this.ownedIdentitiesListViewContainer, this.validateButton});
        this.mainVbox.setAlignment(Pos.CENTER);
        this.mainVbox.setSpacing(24.0);
        this.rootContainer.getChildren().add((Object)this.mainVbox);
        this.rootContainer.setMinWidth(450.0);
        this.rootContainer.maxWidthProperty().bind((ObservableValue)this.rootContainer.minWidthProperty());
        this.bindLifecycle();
    }

    private void bindButtonHandler(MouseEvent mouseEvent) {
        Optional identityToBind = this.ownedIdentityListViewController.getSelectionModel().getSelectedItems().stream().findFirst();
        if (identityToBind.isEmpty()) {
            return;
        }
        this.clicked.set(true);
        AsyncTaskExecutor.submitTask(() -> KeycloakManager.getInstance().shareIdentityToBind(Optional.of(BytesKey.of(((OwnedIdentityInfo)identityToBind.get()).bytesOwnedIdentity()))));
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.clicked.setValue(Boolean.valueOf(false));
        this.ownedIdentityListViewController.getSelectionModel().clearSelection();
    }
}

