/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.KeycloakModel;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class OnBoardingKeycloakAuthenticationInProgressController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds(null, null, "", null, null);
    public final VBox root = new VBox();
    public final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    public final Text subtitle = new Text(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_in_progress_subtitle"));
    public final Label protocolStateLabel;
    public final Label errorLabel;
    public final HBox inputRedirectContainer = new HBox();
    public final Hyperlink enableManualRedirectHyperlink = new Hyperlink(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_in_paste_redirect_url_label"));
    public final TextField input = new TextField();
    public final Button nextButton = new Button();
    protected final Button retryButton = new Button();

    public OnBoardingKeycloakAuthenticationInProgressController(KeycloakModel keycloakModel) {
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(14);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringProgressIndicator.visibleProperty().bind((ObservableValue)keycloakModel.authenticationInProgress);
        StackPane ringContainer = new StackPane(new Node[]{this.ringProgressIndicator});
        ringContainer.setPadding(new Insets(0.0, 0.0, 8.0, 0.0));
        this.subtitle.setTextAlignment(TextAlignment.CENTER);
        this.subtitle.getStyleClass().add((Object)"h2");
        this.inputRedirectContainer.setSpacing(12.0);
        this.inputRedirectContainer.setAlignment(Pos.CENTER);
        this.input.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.input.setPromptText(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_link_example"));
        this.input.textProperty().bindBidirectional((Property)keycloakModel.redirectUserInput);
        SvgSizeable buttonIcon = new SvgSizeable();
        buttonIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-chevron", "icon-white"});
        this.nextButton.disableProperty().bind((ObservableValue)this.input.textProperty().isEmpty());
        this.nextButton.setOnMouseClicked(event -> keycloakModel.sendRedirectInput());
        this.enableManualRedirectHyperlink.setOnAction(event -> keycloakModel.manualRedirectInputEnabled.set(true));
        this.enableManualRedirectHyperlink.setTextAlignment(TextAlignment.CENTER);
        this.enableManualRedirectHyperlink.getStyleClass().addAll((Object[])new String[]{"body-1-size"});
        this.nextButton.getStyleClass().add((Object)"gradient-primary-icon-button");
        this.nextButton.setMnemonicParsing(false);
        this.nextButton.setGraphic((Node)buttonIcon);
        HBox inputAndButton = new HBox(new Node[]{this.input, this.nextButton});
        inputAndButton.setAlignment(Pos.CENTER);
        inputAndButton.setSpacing(12.0);
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        StackPane explanationOrInput = new StackPane(new Node[]{inputAndButton, this.enableManualRedirectHyperlink});
        explanationOrInput.setAlignment(Pos.CENTER);
        this.protocolStateLabel = new Label();
        this.protocolStateLabel.getStyleClass().add((Object)"body-1");
        this.errorLabel = new Label();
        this.errorLabel.getStyleClass().add((Object)"error-text");
        this.errorLabel.setWrapText(true);
        this.errorLabel.setTextAlignment(TextAlignment.CENTER);
        SvgSizeable svgSizeable = new SvgSizeable();
        svgSizeable.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-chevron", "icon-white"});
        this.retryButton.setGraphic((Node)svgSizeable);
        this.retryButton.visibleProperty().bind((ObservableValue)keycloakModel.failed.and((ObservableBooleanValue)keycloakModel.authenticationInProgress.not()));
        this.retryButton.getStyleClass().add((Object)"gradient-primary-icon-button");
        this.retryButton.setMnemonicParsing(false);
        this.retryButton.setOnMouseClicked(event -> keycloakModel.startEnrollementProtocol());
        HBox retryButtonHbox = new HBox();
        retryButtonHbox.setAlignment(Pos.CENTER);
        Region sep = new Region();
        retryButtonHbox.getChildren().addAll((Object[])new Node[]{sep, this.retryButton});
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        this.root.setAlignment(Pos.TOP_CENTER);
        this.root.setSpacing(12.0);
        this.root.getChildren().addAll((Object[])new Node[]{ringContainer, this.subtitle, explanationOrInput, this.protocolStateLabel, this.errorLabel, retryButtonHbox});
        this.protocolStateLabel.visibleProperty().bind((ObservableValue)keycloakModel.failed);
        this.errorLabel.textProperty().bind((ObservableValue)keycloakModel.errorCodeLabel);
        this.errorLabel.visibleProperty().bind((ObservableValue)keycloakModel.failed);
        inputAndButton.visibleProperty().bind((ObservableValue)keycloakModel.manualRedirectInputEnabled.and((ObservableBooleanValue)keycloakModel.failed.not()));
        this.enableManualRedirectHyperlink.visibleProperty().bind((ObservableValue)keycloakModel.manualRedirectInputEnabled.not().and((ObservableBooleanValue)keycloakModel.failed.not()));
        this.subtitle.textProperty().bind((ObservableValue)keycloakModel.keycloakProtocolStateLabel);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

