/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class KeycloakConfigurationSummaryViewController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds(null, null, "on_boarding_flow_keycloak_configuration_title", null, null);
    public final VBox root;
    public final Label idProviderLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_identity_provider"));
    public final Label idProviderValue;
    public final Label clientIdLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_server_client_id"));
    public final Label clientIdValue;
    public final Label clientSecretLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_server_client_secret"));
    public final Label clientSecretValue;
    public final Label protocolStateLabel;
    public final Label errorLabel;
    Button authenticateButton;
    final IdentityManagementFlowModel flowModel;

    public KeycloakConfigurationSummaryViewController(IdentityManagementFlowModel flowModel) {
        this.logger.debug("KeycloakConfigurationPreAuthController::KeycloakConfigurationPreAuthController");
        this.flowModel = flowModel;
        this.root = new VBox();
        this.root.alignmentProperty().set((Object)Pos.CENTER);
        this.idProviderValue = new Label();
        HBox idProviderLabelValueContainer = this.buildLabelValueItems(this.idProviderLabel, this.idProviderValue);
        this.clientIdValue = new Label();
        HBox clientIdLabelValueContainer = this.buildLabelValueItems(this.clientIdLabel, this.clientIdValue);
        this.clientSecretValue = new Label();
        HBox clientSecretLabelValueContainer = this.buildLabelValueItems(this.clientSecretLabel, this.clientSecretValue);
        Region summaryBottomGreySep = new Region();
        summaryBottomGreySep.getStyleClass().add((Object)"sep-light-grey");
        this.protocolStateLabel = new Label();
        this.protocolStateLabel.getStyleClass().add((Object)"body-1");
        this.errorLabel = new Label();
        this.errorLabel.getStyleClass().add((Object)"error-text");
        this.errorLabel.setWrapText(true);
        SvgSizeable authenticateButtonIcon = new SvgSizeable();
        authenticateButtonIcon.getStyleClass().addAll((Object[])new String[]{"icon-large", "svg-chevron", "icon-white"});
        this.authenticateButton = new Button();
        this.authenticateButton.getStyleClass().add((Object)"gradient-primary-icon-button");
        this.authenticateButton.setMnemonicParsing(false);
        this.authenticateButton.setDefaultButton(true);
        this.authenticateButton.setGraphic((Node)authenticateButtonIcon);
        HBox authenticateButtonContainer = new HBox();
        authenticateButtonContainer.setAlignment(Pos.CENTER_RIGHT);
        authenticateButtonContainer.getChildren().addAll((Object[])new Node[]{this.authenticateButton});
        this.root.getChildren().addAll((Object[])new Node[]{idProviderLabelValueContainer, clientIdLabelValueContainer, clientSecretLabelValueContainer, summaryBottomGreySep, this.protocolStateLabel, this.errorLabel, authenticateButtonContainer});
        VBox.setMargin((Node)summaryBottomGreySep, (Insets)new Insets(0.0, 0.0, 40.0, 0.0));
        this.bind();
        this.authenticateButton.setOnAction(this::authenticateButtonHandler);
    }

    private HBox buildLabelValueItems(Label labelNode, Label valueNode) {
        HBox labelValueContainer = new HBox();
        labelValueContainer.setPrefHeight(60.0);
        labelNode.getStyleClass().addAll((Object[])new String[]{"body-1", "black-text"});
        valueNode.getStyleClass().add((Object)"body-2");
        Region hSep = new Region();
        hSep.setMinWidth(20.0);
        labelValueContainer.getChildren().addAll((Object[])new Node[]{labelNode, hSep, valueNode});
        HBox.setHgrow((Node)hSep, (Priority)Priority.ALWAYS);
        return labelValueContainer;
    }

    @Override
    public Region getLayout() {
        this.logger.debug("KeycloakConfigurationPreAuthController::getLayout");
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.logger.debug("KeycloakConfigurationPreAuthController::getLayout");
        this.bind();
    }

    @Override
    public void onLayoutDetached() {
        this.logger.debug("KeycloakConfigurationPreAuthController::getLayout");
        this.unbind();
    }

    private void bind() {
        this.idProviderValue.textProperty().bind((ObservableValue)this.flowModel.getKeycloakModel().getIdentityProviderUrlProperty());
        this.clientIdValue.textProperty().bind((ObservableValue)this.flowModel.getKeycloakModel().getServerClientIdProperty());
        this.clientSecretValue.textProperty().bind((ObservableValue)this.flowModel.getKeycloakModel().getServerClientSecretProperty());
        this.protocolStateLabel.textProperty().bind((ObservableValue)this.flowModel.getKeycloakModel().keycloakProtocolStateLabel);
        this.errorLabel.textProperty().bind((ObservableValue)this.flowModel.getKeycloakModel().errorCodeLabel);
    }

    private void unbind() {
        this.idProviderValue.textProperty().unbind();
        this.clientIdValue.textProperty().unbind();
        this.clientSecretValue.textProperty().unbind();
    }

    private void authenticateButtonHandler(ActionEvent event) {
        this.logger.debug("KeycloakConfigurationPreAuthController::authenticateButtonHandler");
        this.flowModel.getKeycloakModel().startEnrollementProtocol();
    }
}

