/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.creation;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/main_stack/identity_management_layer/creation/identity_creation.fxml")
public class IdentityCreationViewController
extends BaseModalController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_identity_creation_title", null, null, null, null);
    @FXML
    VBox identity_creation_vbox;
    @FXML
    private TextField identity_first_name;
    @FXML
    private TextField identity_last_name;
    @FXML
    private TextField identity_company;
    @FXML
    private TextField identity_position;
    @FXML
    private Button identity_create_button;
    @FXML
    private Hyperlink keycloak_hyperlink;
    IdentityManagementFlowModel identityManagementFlowModel;
    private final FlowStackContext<IdentityManagementFlow> flowContext;

    public IdentityCreationViewController(FlowStackContext<IdentityManagementFlow> flowContext, IdentityManagementFlowModel identityManagementFlowModel) {
        this.flowContext = flowContext;
        this.identityManagementFlowModel = identityManagementFlowModel;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        AppLogger.d("IdentityCreationViewController::initialize() Identity creation initialized");
        super.initialize(location, resources);
        this.identity_create_button.setOnAction(e -> this.handleIdentityCreationButton());
        this.identity_creation_vbox.getStyleClass().add(0, (Object)"modal-contextual-background");
        this.keycloak_hyperlink.setOnAction(this::handleImportKeycloakConfigurationButton);
        this.bind();
    }

    @Override
    public Region getLayout() {
        return this.identity_creation_vbox;
    }

    public void bind() {
        this.identity_first_name.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityFirstNameProperty());
        this.identity_last_name.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityLastNameProperty());
        this.identity_company.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityCompanyProperty());
        this.identity_position.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityPositionProperty());
        this.identity_create_button.disableProperty().bind((ObservableValue)this.identityManagementFlowModel.identityFirstNameProperty().isEmpty());
    }

    private void handleIdentityCreationButton() {
        AsyncTaskExecutor.submitTask(() -> {
            OwnedIdentity createdOwnedIdentity = OwnedIdentityApi.createIdentitySync(null, null, this.identity_first_name.getText(), this.identity_last_name.getText(), this.identity_company.getText(), this.identity_position.getText(), null);
            if (createdOwnedIdentity == null) {
                MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
                this.flowContext.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.IDENTITY_CREATION);
                return;
            }
            MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN));
            SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity(createdOwnedIdentity);
            this.resetFields();
            this.flowContext.clearContext();
            this.flowContext.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
        });
    }

    private void resetFields() {
        this.identity_company.setText("");
        this.identity_position.setText("");
        this.identity_first_name.setText("");
        this.identity_last_name.setText("");
    }

    private void handleImportKeycloakConfigurationButton(ActionEvent event) {
        AppLogger.d("OnBoardingController::handleImportKeycloakConfigurationButton()");
        this.flowContext.pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION_MANUAL);
    }
}

