/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy;

import io.olvid.engine.Logger;
import io.olvid.engine.engine.types.ObvBackupKeyVerificationOutput;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.owned_device.OwnedDevicesSynchronisationWithEngineTask;
import io.olvid.windows.messenger.fx.custom_components.loader.LoadingScreenController;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy.BackupRestorationListener;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DeviceUtils;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.function.UnaryOperator;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

@FXMLView(path="fx/main_stack/identity_management_layer/backup/backup_key.fxml")
public class BackupKeyController
extends BaseViewController {
    private final BackupRestorationViewModel model;
    private final Pane parent;
    private final Runnable closeFlow;
    @FXML
    private Region root;
    @FXML
    private TextField input_key;
    @FXML
    private Label error_label;
    @FXML
    private Button validate_button;
    private boolean isLegacy = false;
    public static final String NO_ALPHA_NUM = "[^A-Za-z0-9]";
    FlowStackContext<IdentityManagementFlow> flowContext;
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_backup_flow_title_validate_key", "on_boarding_flow_backup_flow_how_get_key", null, "on_boarding_flow_backup_flow_know_more", "on_boarding_flow_backup_flow_know_more_url");
    private BackupRestorationListener backupRestorationListener;

    public BackupKeyController(BackupRestorationViewModel model, FlowStackContext<IdentityManagementFlow> context, Pane parent, Runnable closeFlow, boolean isLegacy) {
        this.isLegacy = isLegacy;
        this.model = model;
        this.parent = parent;
        this.closeFlow = closeFlow;
        this.flowContext = context;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.validate_button.setOnAction(this::validateBackupSeed);
        this.error_label.managedProperty().bind((ObservableValue)this.error_label.visibleProperty());
        this.initErrorLabel();
        this.initTextField();
    }

    private void initErrorLabel() {
        this.error_label.visibleProperty().bind((ObservableValue)this.error_label.textProperty().isNotEmpty());
        this.model.checkStatusProperty().addListener((observable, oldValue, newValue) -> {
            if (this.model.getCheckStatus() == null) {
                return;
            }
            switch (this.model.getCheckStatus()) {
                case 1: {
                    this.error_label.setText(ViewControllerHelper.getString("on_boarding_flow_backup_flow_error_key_too_short"));
                    break;
                }
                case 2: {
                    this.error_label.setText(ViewControllerHelper.getString("on_boarding_flow_backup_flow_error_key_too_long"));
                    break;
                }
                case 3: {
                    this.error_label.setText(ViewControllerHelper.getString("on_boarding_flow_backup_flow_error_key_bad_key"));
                    break;
                }
                default: {
                    this.error_label.setText("");
                }
            }
        });
        this.input_key.textProperty().addListener((observable, oldValue, newValue) -> this.error_label.setText(""));
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        try {
            if (this.isLegacy) {
                this.selectBackupFile();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLayoutDetached() {
    }

    private void validateBackupSeed(ActionEvent event) {
        if (this.isLegacy) {
            if (this.validateBackupSeed() == 0) {
                AppLogger.d("BackupRestorationController::selectBackupFileButtonCLicked : 0");
                LoadingScreenController.runAsyncTaskWithLoader(this::restoreBackup, this.parent);
            }
        } else {
            this.model.seedProperty.setValue(this.input_key.getText());
            this.model.fetchDeviceBackupList();
            this.flowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.DEVICE_BACKUP_SELECTION);
        }
    }

    public int validateBackupSeed() {
        String backupSeed = this.input_key.getText();
        byte[] backupContent = (byte[])this.model.backupContentProperty().getValue();
        if (backupSeed == null || backupContent == null) {
            return -1;
        }
        this.model.setCheckStatus(-1);
        Optional<ObvBackupKeyVerificationOutput> verificationOutput = Api.getBackupApi().validateBackupSeed(backupSeed, backupContent);
        if (verificationOutput.isPresent()) {
            this.model.setCheckStatus(verificationOutput.get().verificationStatus);
            return verificationOutput.get().verificationStatus;
        }
        return -1;
    }

    void selectBackupFile() throws Exception {
        try (FileInputStream is = new FileInputStream(this.model.getSelectedFile().getAbsolutePath());
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int c;
            byte[] buffer = new byte[4096];
            while ((c = ((InputStream)is).read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            this.model.setBackupContent(baos.toByteArray());
        }
    }

    public void restoreBackup() {
        String backupSeed = this.input_key.getText();
        byte[] backupContent = (byte[])this.model.backupContentProperty().getValue();
        AppLogger.d("BackupRestorationViewModel::restoreBackup...");
        Optional<ObvIdentity[]> ownedIdentitiesOpt = Api.getBackupApi().restoreOwnedIdentitiesFromBackup(backupSeed, backupContent, DeviceUtils.getSystemDeviceName());
        CountDownLatch latch = new CountDownLatch(1);
        if (ownedIdentitiesOpt.isEmpty()) {
            AppLogger.e("BackupKeyController::restoreBackup owned identities restoration return null");
            return;
        }
        ObvIdentity[] ownedIdentities = ownedIdentitiesOpt.get();
        if (ownedIdentities.length > 0) {
            Runnable onFinish = () -> {
                latch.countDown();
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.input_key.setText("");
                    this.closeFlow.run();
                });
            };
            this.backupRestorationListener = new BackupRestorationListener(ownedIdentities, onFinish);
            EngineWrapper.getInstance().addNotificationListener("engine_notification_engine_backup_restoration_finished", this.backupRestorationListener);
            Arrays.stream(ownedIdentities).forEach(this::createOwnIdentity);
            AppLogger.d("Initiating contact and groups restore");
            Api.getBackupApi().restoreContactsAndGroupsFromBackup(backupSeed, backupContent, ownedIdentities);
            AppLogger.d("Contacts and groups restored on Engine side");
            this.model.setSuccess(true);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            AppLogger.e("The loading thread that wait for restauration as been interrupt", e);
        }
    }

    private void createOwnIdentity(ObvIdentity ownedIdentity) {
        OwnedIdentity dbOwnedIdentity;
        Capabilities capabilities = new Capabilities(false, true, true);
        capabilities = DbManager.getInstance().getCapabilitiesDao().createIfNotExists(capabilities);
        if (capabilities == null) {
            this.model.setSuccess(false);
            AppLogger.w("BackupKeyController::createOwnIdentity capabilities is null");
            return;
        }
        IdentityDetails identityDetails = new IdentityDetails(ownedIdentity.getIdentityDetails());
        identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
        if (identityDetails == null) {
            this.model.setSuccess(false);
            AppLogger.w("BackupKeyController::createOwnIdentity create identity details failed");
            return;
        }
        try {
            dbOwnedIdentity = new OwnedIdentity(ownedIdentity, OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN, identityDetails, capabilities);
        }
        catch (Exception e) {
            this.model.setSuccess(false);
            AppLogger.w("BackupKeyController::createOwnIdentity create own identity failed");
            return;
        }
        try {
            if (EngineWrapper.getInstance().getOwnedIdentityPublishedAndLatestDetails(ownedIdentity.getBytesIdentity()).length == 2) {
                dbOwnedIdentity.setUnpublishedDetails(OwnedIdentityGenerated.UnpublishedDetails.EXIST);
            }
        }
        catch (Exception e) {
            Logger.e((String)"BackUpKeyController::createIdentity couldn't retrieve OwnedIdentityPublishedAndLatestDetails", (Exception)e);
        }
        DbManager.getInstance().getOwnedIdentityDao().insert(dbOwnedIdentity);
        Logger.d((String)"Identity is keycloak managed --> registering with the KeycloakManager");
        try {
            ObvKeycloakState keycloakState = EngineWrapper.getInstance().getOwnedIdentityKeycloakState(ownedIdentity.getBytesIdentity());
            if (keycloakState != null) {
                KeycloakManager.getInstance().registerKeycloakManagedIdentity(ownedIdentity.getBytesIdentity(), keycloakState.keycloakServer, keycloakState.clientId, keycloakState.clientSecret, keycloakState.jwks, keycloakState.signatureKey, keycloakState.serializedAuthState, keycloakState.ownApiKey, keycloakState.latestRevocationListTimestamp, true, keycloakState.transferRestricted);
            }
            Logger.w((String)"Restored own identity");
        }
        catch (Exception e) {
            Logger.w((String)"Unable to register with the KeycloakManager");
        }
        try {
            EngineWrapper.getInstance().registerToPushNotification(ownedIdentity.getBytesIdentity(), false, null);
        }
        catch (Exception e) {
            AppLogger.e("Error registering newly generated Identity to push notification.", e);
        }
        new OwnedDevicesSynchronisationWithEngineTask(dbOwnedIdentity).run();
    }

    private void initTextField() {
        UnaryOperator separatorFormatter = change -> {
            if (!change.isContentChange()) {
                return change;
            }
            if (change.getControlText().substring(change.getRangeStart(), change.getRangeEnd()).equals(" ")) {
                change.setRange(change.getRangeStart() - 1, change.getRangeEnd());
            }
            String newTextBeforeSpace = change.getText().replaceAll(NO_ALPHA_NUM, "").toUpperCase(Locale.ROOT);
            int start = change.getRangeStart();
            String rangeText = BackupKeyController.createStringWithSpace(newTextBeforeSpace, start);
            int newCaretPosition = start + rangeText.length();
            if (change.getRangeEnd() == change.getControlText().length() - 1) {
                change.setText(rangeText);
                change.setCaretPosition(newCaretPosition);
                change.setAnchor(newCaretPosition);
                return change;
            }
            String newTextAfter = change.getControlText().substring(change.getRangeEnd()).replaceAll(NO_ALPHA_NUM, "");
            String afterText = BackupKeyController.createStringWithSpace(newTextAfter, newCaretPosition);
            change.setText(rangeText + afterText);
            change.setRange(start, change.getControlText().length());
            change.setCaretPosition(newCaretPosition);
            change.setAnchor(newCaretPosition);
            return change;
        };
        this.input_key.setTextFormatter(new TextFormatter(separatorFormatter));
    }

    private static String createStringWithSpace(String newTextBeforeSpace, int start) {
        StringBuilder textWithSpaceBuilder = new StringBuilder();
        for (int i = 0; i < newTextBeforeSpace.length(); ++i) {
            if (0 == (textWithSpaceBuilder.length() + 1 + start) % 5) {
                textWithSpaceBuilder.append(" ");
            }
            textWithSpaceBuilder.append(newTextBeforeSpace.charAt(i));
        }
        return textWithSpaceBuilder.toString();
    }
}

