/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller;

import io.olvid.windows.messenger.engine.sync.ProfilePictureKey;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class ProfileRestoredController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_backup_restoration_profile_restored_label", null, null, null, null);
    final VBox rootContainer = new VBox();
    final IdentityBubble identityBubble = new IdentityBubble();
    final Label identityFirstLastName = new Label();
    final Button openProfileButton = new Button(ViewControllerHelper.getString("on_boarding_flow_backup_restoration_open_profile_button_label"));
    final Button restoreAnotherProfileButton = new Button(ViewControllerHelper.getString("on_boarding_flow_backup_restoration_restore_another_profile_button_label"));
    private final BackupRestorationViewModel model;
    private final FlowStackContext<IdentityManagementFlow> context;

    public ProfileRestoredController(BackupRestorationViewModel model, FlowStackContext<IdentityManagementFlow> identityCreationFlowContext) {
        this.model = model;
        this.context = identityCreationFlowContext;
        this.openProfileButton.getStyleClass().add((Object)"primary-button");
        this.openProfileButton.setPrefSize(250.0, 50.0);
        this.openProfileButton.setOnMouseClicked(mouseEvent -> {
            this.context.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
            MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN));
        });
        this.restoreAnotherProfileButton.setPrefSize(250.0, 50.0);
        this.restoreAnotherProfileButton.getStyleClass().add((Object)"secondary-button");
        this.restoreAnotherProfileButton.setOnMouseClicked(mouseEvent -> {
            model.fetchDeviceBackupList();
            this.context.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.DEVICE_BACKUP_SELECTION);
        });
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "rounded-background-pane"});
        this.rootContainer.setSpacing(12.0);
        this.rootContainer.setAlignment(Pos.CENTER);
        this.rootContainer.setMaxSize(475.0, 375.0);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.identityBubble, this.identityFirstLastName, this.openProfileButton, this.restoreAnotherProfileButton});
        VBox.setMargin((Node)this.identityBubble, (Insets)new Insets(32.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.restoreAnotherProfileButton, (Insets)new Insets(0.0, 0.0, 32.0, 0.0));
        this.bindLifecycle();
    }

    private void refresh() {
        IdentityDetailsInfo identityDetailsInfo = new IdentityDetailsInfo(((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).identityDetails());
        if (identityDetailsInfo.firstName().isPresent()) {
            this.identityBubble.setInitial(StringUtils.firstChar(identityDetailsInfo.firstName().get()));
        }
        this.identityBubble.setKeycloakManaged(((ProfileBackupsInfo)this.model.selectedProfileSnapshot.get()).keycloakInfoOpt().isPresent());
        this.identityBubble.setColorByteSource(((ProfileBackupFetchResult)this.model.selectedProfileBAckupFetchResult.get()).ownedIdentityBytes().byteArray());
        if (((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).profilePicInfo().isPresent()) {
            if (((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).profilePicInfo().isPresent()) {
                Either<String, ProfilePictureKey> either = ((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).profilePicInfo().get();
                if (either.isRight()) {
                    this.identityBubble.setProfilePictureKey(Optional.ofNullable(either.getRight()));
                } else {
                    this.identityBubble.setPhotoUrlRelPath(Optional.ofNullable(either.getLeft()));
                }
            }
        } else {
            this.identityBubble.setPhotoUrlRelPath(Optional.empty());
            this.identityBubble.setProfilePictureKey(Optional.empty());
        }
        this.identityBubble.setGroup(false);
        this.identityBubble.setInactive(false);
        this.identityBubble.setKeycloakManaged(((ProfileBackupsInfo)this.model.selectedProfileSnapshot.get()).keycloakInfoOpt().isPresent());
        this.identityBubble.setInitial(StringUtils.firstChar(identityDetailsInfo.firstName().get()));
        this.identityBubble.setColorByteSource(((ProfileBackupFetchResult)this.model.selectedProfileBAckupFetchResult.get()).ownedIdentityBytes().byteArray());
        this.identityFirstLastName.setText(identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
        this.refresh();
    }

    @Override
    public void onLayoutDetached() {
    }
}

