/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller;

import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.settings.backups.management.ProfileBackupSnapshotCell;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.misc.DeviceUtils;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class ProfileBackupSelectionViewController
extends BaseViewController {
    public static DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_backup_select_backup_label", null, null, null, null);
    public final StandardPanelListController<ProfileBackupsInfo> profileBackupListViewController;
    public final VBox rootContainer = new VBox();
    public final Button restoreButton = new Button(ViewControllerHelper.getString("backup_restaure_label"));
    public final BackupRestorationViewModel model;
    FlowStackContext<IdentityManagementFlow> identityManagementFlowContext;
    final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    final StackPane ringContainer = new StackPane(new Node[]{this.ringProgressIndicator});
    final StackPane ringOrLoadedList = new StackPane();
    public final Text errorText = new Text();
    public final Label descriptionLabel = new Label();

    public ProfileBackupSelectionViewController(FlowStackContext<IdentityManagementFlow> context, BackupRestorationViewModel model) {
        this.model = model;
        this.descriptionLabel.textProperty().bind((ObservableValue)ViewControllerHelper.getString("on_boarding_flow_backup_number_of_backup_found_label", (ObservableIntegerValue)model.profileBackupCntz));
        this.descriptionLabel.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.descriptionLabel.setTextAlignment(TextAlignment.CENTER);
        this.descriptionLabel.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADED));
        this.errorText.textProperty().bind((ObservableValue)model.errorText);
        this.errorText.setTextAlignment(TextAlignment.CENTER);
        this.errorText.setWrappingWidth(525.0);
        this.errorText.getStyleClass().addAll((Object[])new String[]{"body-1", "error-text"});
        VBox.setMargin((Node)this.errorText, (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        this.identityManagementFlowContext = context;
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(8);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringContainer.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADING));
        this.ringContainer.managedProperty().bind((ObservableValue)this.ringContainer.visibleProperty());
        this.ringContainer.setPadding(new Insets(12.0, 0.0, 24.0, 0.0));
        this.profileBackupListViewController = StandardPanelListController.builder().withLiveData(model.profileBackupsLiveData).withDataClass(ProfileBackupsInfo.class).withCellFactory((Callback<ListView<ProfileBackupsInfo>, AbstractListCell<ProfileBackupsInfo>>)((Callback)param -> new ProfileBackupSnapshotCell(false, Optional.empty()))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(false).withoutButton((profileSnapshot, node) -> model.selectedProfileSnapshot.setValue(profileSnapshot)).build();
        this.profileBackupListViewController.getListView().prefHeightProperty().bind((ObservableValue)Bindings.size(this.profileBackupListViewController.getListModel().getList()).multiply(110));
        this.profileBackupListViewController.getListView().setMaxHeight(500.0);
        this.profileBackupListViewController.getLayout().visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADED));
        this.profileBackupListViewController.getLayout().managedProperty().bind((ObservableValue)this.profileBackupListViewController.getLayout().visibleProperty());
        this.profileBackupListViewController.getLayout().setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        this.profileBackupListViewController.getLayout().getStyleClass().add((Object)"rounded-background-pane");
        this.ringOrLoadedList.getChildren().addAll((Object[])new Node[]{this.ringContainer, this.profileBackupListViewController.getLayout()});
        this.ringOrLoadedList.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.ringOrLoadedList, (Priority)Priority.ALWAYS);
        Region hSep = new Region();
        VBox.setVgrow((Node)hSep, (Priority)Priority.ALWAYS);
        Region hSep1 = new Region();
        VBox.setVgrow((Node)hSep1, (Priority)Priority.ALWAYS);
        this.rootContainer.setAlignment(Pos.CENTER);
        this.restoreButton.setOnMouseClicked(this::restoreHandler);
        this.restoreButton.getStyleClass().addAll((Object[])new String[]{"primary-button"});
        this.restoreButton.disableProperty().bind((ObservableValue)this.profileBackupListViewController.getSelectionModel().hasSelectedItemsProperty().not());
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.descriptionLabel, this.ringOrLoadedList, hSep, this.errorText, hSep1, this.restoreButton});
        this.bindLifecycle();
    }

    private void restoreHandler(MouseEvent event) {
        ProfileBackupsInfo.KeycloakInfo keycloakInfo;
        this.logger.debug("ProfileBackupSelectionViewController::restoreHandler clicked on restore");
        if (((ProfileBackupsInfo)this.model.selectedProfileSnapshot.get()).keycloakInfoOpt().isPresent() && (keycloakInfo = ((ProfileBackupsInfo)this.model.selectedProfileSnapshot.get()).keycloakInfoOpt().get()).keycloakStatus().equals((Object)ProfileBackupsInfo.KeycloakInfo.KeycloakStatus.TRANSFER_RESTRICTED)) {
            this.identityManagementFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.KEYCLOAK_AUTHENTICATION);
            return;
        }
        if (((ProfileBackupFetchResult)this.model.selectedProfileBAckupFetchResult.get()).multiDevice()) {
            boolean restoreResult = Api.getBackupApi().restoreProfile(((ProfileBackupsInfo)this.model.selectedProfileSnapshot.get()).snapshot(), DeviceUtils.getSystemDeviceName(), KeycloakManager.getInstance().getSerializedAuthState(((ProfileBackupFetchResult)this.model.selectedProfileBAckupFetchResult.get()).ownedIdentityBytes().byteArray()));
            if (restoreResult) {
                this.identityManagementFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.RESTORE_OTHER_PROFILE_CHOICE);
            }
        } else {
            this.identityManagementFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.WARNING_MULTIDEVICE_LICENSE);
        }
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        if (this.profileBackupListViewController != null) {
            this.profileBackupListViewController.getSelectionModel().clearSelection();
        }
    }
}

