/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller;

import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfoCell;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.misc.DeviceUtils;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class BackupRestorationMultiDeviceWarningController
extends BaseViewController {
    public static DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("backup_reset_title_label", null, null, null, null);
    public final VBox rootContainer = new VBox();
    public final Text deviceListDescription = new Text(ViewControllerHelper.getString("on_boarding_flow_backup_restoration_tour_devices_label"));
    public final StandardPanelListController<DeviceInfo> deviceInfoListController;
    public final Label bottomLabel = new Label();
    public final Button restoreProfileButton = new Button(ViewControllerHelper.getString("on_boarding_flow_backup_restoration_restore_my_profile_button_label"));
    public final Button cancelButton = new Button(ViewControllerHelper.getString("button_label_discard"));
    private final FlowStackContext<IdentityManagementFlow> context;
    final BackupRestorationViewModel model;

    public BackupRestorationMultiDeviceWarningController(BackupRestorationViewModel model, FlowStackContext<IdentityManagementFlow> identityCreationFlowContext) {
        this.context = identityCreationFlowContext;
        this.model = model;
        this.deviceListDescription.textProperty().bind((ObservableValue)ViewControllerHelper.getString("on_boarding_flow_backup_restoration_no_license_explanation_text", (ObservableStringValue)model.selectedProfileToBackupFirstLastName));
        this.deviceListDescription.setWrappingWidth(500.0);
        this.deviceListDescription.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.deviceListDescription.setTextAlignment(TextAlignment.CENTER);
        this.deviceListDescription.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADED));
        this.deviceInfoListController = StandardPanelListController.builder().withLiveData(model.selectedProfileSnapshotDeviceList).withDataClass(DeviceInfo.class).withCellFactory((Callback<ListView<DeviceInfo>, AbstractListCell<DeviceInfo>>)((Callback)param -> new DeviceInfoCell(false))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(true).withoutButton((deviceBackupInfo, node) -> {}).build();
        this.deviceInfoListController.getListView().prefHeightProperty().bind((ObservableValue)Bindings.size(this.deviceInfoListController.getListModel().getList()).multiply(80));
        this.deviceInfoListController.getListView().setMaxHeight(450.0);
        this.deviceInfoListController.getLayout().setMaxWidth(300.0);
        this.deviceInfoListController.getLayout().getStyleClass().addAll((Object[])new String[]{"light-grey-bordered-rounded-container"});
        VBox.setMargin(this.deviceInfoListController.getListView(), (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        this.bottomLabel.getStyleClass().add((Object)"body-1");
        this.bottomLabel.setWrapText(true);
        this.bottomLabel.setTextAlignment(TextAlignment.CENTER);
        this.bottomLabel.setMinHeight(50.0);
        this.bottomLabel.setText(ViewControllerHelper.getString("on_boarding_flow_backup_restoration_no_license_device_selection"));
        this.restoreProfileButton.getStyleClass().addAll((Object[])new String[]{"primary-button"});
        this.restoreProfileButton.setPrefSize(200.0, 50.0);
        this.restoreProfileButton.setOnMouseClicked(mouseEvent -> {
            boolean restoreResult = Api.getBackupApi().restoreProfile(((ProfileBackupsInfo)model.selectedProfileSnapshot.get()).snapshot(), DeviceUtils.getSystemDeviceName(), model.serializedAuthState);
            if (restoreResult) {
                this.context.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.RESTORE_OTHER_PROFILE_CHOICE);
            }
        });
        this.cancelButton.getStyleClass().addAll((Object[])new String[]{"secondary-button"});
        this.cancelButton.setPrefSize(200.0, 50.0);
        this.cancelButton.setOnMouseClicked(event -> this.context.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING));
        Region vSep = new Region();
        VBox.setVgrow((Node)vSep, (Priority)Priority.ALWAYS);
        this.rootContainer.setMaxWidth(550.0);
        this.rootContainer.setMaxHeight(700.0);
        this.rootContainer.setSpacing(8.0);
        this.rootContainer.setAlignment(Pos.CENTER);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.deviceListDescription, this.deviceInfoListController.getLayout(), this.bottomLabel, vSep, this.restoreProfileButton, this.cancelButton});
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

