/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer;

import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/main_stack/identity_management_layer/restaure_profile.fxml")
public class RestaureProfileController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_restaure_profile_existe_title", null, null, null, null);
    @FXML
    private VBox on_boarding_vbox;
    @FXML
    private Button activate_on_my_device;
    @FXML
    private Button restaure_backup;
    @FXML
    private Hyperlink keycloak_hyperlink;
    private final FlowStackContext<IdentityManagementFlow> flowContext;

    public RestaureProfileController(FlowStackContext<IdentityManagementFlow> context) {
        this.flowContext = context;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        AppLogger.d("OnBoardingController::initialize()");
        AppLogger.d(Thread.currentThread().getName());
        this.restaure_backup.setOnAction(this::restoreLocalBackUp);
        this.activate_on_my_device.setOnAction(this::activateOnMyDevice);
        this.keycloak_hyperlink.setOnAction(this::handleImportKeycloakConfigurationButton);
    }

    @Override
    public Region getLayout() {
        return this.on_boarding_vbox;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void activateOnMyDevice(ActionEvent event) {
        this.flowContext.pushState(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.CHOOSE_NAME);
    }

    private void restoreLocalBackUp(ActionEvent event) {
        this.flowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY);
    }

    private void handleImportKeycloakConfigurationButton(ActionEvent event) {
        this.flowContext.pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION_MANUAL);
    }
}

