/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack;

import io.olvid.windows.messenger.fx.custom_components.layers.LayerAnchorPane;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentitiesManagementFlowController;
import io.olvid.windows.messenger.fx.main_stack.main_layer.MainLayerController;
import io.olvid.windows.messenger.fx.modal.ModalLayerController;
import io.olvid.windows.messenger.fx.notifications.NotificationLayerController;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class MainStackManager
extends BaseViewController {
    private final StackPane views_stack_pane;
    private Optional<TheLayerCake> lastLayerBeforeModal = Optional.empty();
    private final Node mainLayer;
    private final Node identityCreationLayer;
    private final Node modalLayer;
    public static final SimpleContext<DisplayedLayerWrapper> displayedLayerState = new SimpleContext();
    private int currentStackIndex = -1;
    private final LiveDataListener<DisplayedLayerWrapper> stateListener = this::layerDisplayListener;
    private final MainLayerController mainLayerController;
    private final IdentitiesManagementFlowController identitiesManagementFlowController;
    private final NotificationLayerController notificationLayerController;
    private final ModalLayerController modalLayerController;

    public MainStackManager() {
        AppLogger.t("MainStackManager::MainStackManager()");
        this.views_stack_pane = new StackPane();
        this.mainLayerController = new MainLayerController();
        this.identitiesManagementFlowController = new IdentitiesManagementFlowController();
        this.notificationLayerController = new NotificationLayerController();
        this.modalLayerController = new ModalLayerController();
        this.views_stack_pane.getChildren().add((Object)this.mainLayerController.getLayout());
        this.views_stack_pane.getChildren().add((Object)this.identitiesManagementFlowController.getLayout());
        this.views_stack_pane.getChildren().add((Object)this.notificationLayerController.getLayout());
        this.views_stack_pane.getChildren().add((Object)this.modalLayerController.getLayout());
        this.mainLayer = (Node)this.views_stack_pane.getChildren().get(TheLayerCake.MAIN_LAYER.value);
        this.identityCreationLayer = (Node)this.views_stack_pane.getChildren().get(TheLayerCake.IDENTITY_CREATION_FLOW_LAYER.value);
        this.modalLayer = (Node)this.views_stack_pane.getChildren().get(TheLayerCake.MODAL_LAYER.value);
        this.setVisibleLayer(TheLayerCake.NONE);
        this.bindLifecycle();
        NCRegistry.getUtilityNC().startCenter();
        NCRegistry.getUIActionNC().startCenter();
    }

    @Override
    public Region getLayout() {
        return this.views_stack_pane;
    }

    @Override
    public void onLayoutAttached() {
        displayedLayerState.getCurrentStateLiveData().addListener(this.stateListener);
    }

    @Override
    public void onLayoutDetached() {
        displayedLayerState.getCurrentStateLiveData().removeListener(this.stateListener);
    }

    public Pane getContainer() {
        return this.views_stack_pane;
    }

    private void layerDisplayListener(DisplayedLayerWrapper newValue, DisplayedLayerWrapper oldValue) {
        AppLogger.t("MainStackManager::layerDisplayListener()");
        if (newValue == null || newValue == oldValue) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            switch (newValue.displayedLayer.ordinal()) {
                case 0: {
                    AppLogger.d("MAIN state");
                    this.setVisibleLayer(TheLayerCake.MAIN_LAYER);
                    this.displayModalLayerIfNeeded(TheLayerCake.MAIN_LAYER);
                    break;
                }
                case 1: {
                    AppLogger.d("OWNED_IDENTITY_MANAGEMENT state");
                    this.setVisibleLayer(TheLayerCake.IDENTITY_CREATION_FLOW_LAYER);
                    this.displayModalLayerIfNeeded(TheLayerCake.IDENTITY_CREATION_FLOW_LAYER);
                    break;
                }
                case 2: {
                    AppLogger.d("MODAL state");
                    this.setVisibleLayer(TheLayerCake.MODAL_LAYER);
                    break;
                }
                case 3: {
                    if (this.lastLayerBeforeModal.isEmpty()) {
                        this.setVisibleLayer(TheLayerCake.MAIN_LAYER);
                        break;
                    }
                    this.setVisibleLayer(this.lastLayerBeforeModal.get());
                    break;
                }
                default: {
                    AppLogger.d(String.valueOf(newValue) + " state not handled...");
                }
            }
        });
    }

    private void setVisibleLayer(TheLayerCake layer) {
        Node currentVisibleNode;
        if (layer.value == this.currentStackIndex) {
            return;
        }
        if (layer == TheLayerCake.NONE) {
            ViewControllerHelper.hideNode((Node)this.views_stack_pane);
            return;
        }
        if (!this.views_stack_pane.isVisible()) {
            ViewControllerHelper.showNode((Node)this.views_stack_pane);
            Scene scene = ViewControllerHelper.MAIN_STAGE.getScene();
            if (scene != null) {
                scene.getWindow().setWidth(scene.getWindow().getWidth() + 0.001);
            }
        }
        switch (layer.ordinal()) {
            case 0: {
                ViewControllerHelper.showNode(this.mainLayer);
                ViewControllerHelper.hideNode(this.identityCreationLayer);
                ViewControllerHelper.hideNode(this.modalLayer);
                break;
            }
            case 1: {
                ViewControllerHelper.showNode(this.identityCreationLayer);
                ViewControllerHelper.hideNode(this.mainLayer);
                ViewControllerHelper.hideNode(this.modalLayer);
                break;
            }
            case 3: {
                ViewControllerHelper.showNode(this.modalLayer);
            }
        }
        if (this.currentStackIndex != -1 && (currentVisibleNode = (Node)this.views_stack_pane.getChildren().get(this.currentStackIndex)) instanceof LayerAnchorPane) {
            ((LayerAnchorPane)currentVisibleNode).onHideLayer();
        }
        this.currentStackIndex = layer.value;
    }

    void displayModalLayerIfNeeded(TheLayerCake lastLayerBeforeModal) {
        if (this.modalLayerController.hasQueuedModals()) {
            this.setVisibleLayer(TheLayerCake.MODAL_LAYER);
        }
        this.lastLayerBeforeModal = Optional.of(lastLayerBeforeModal);
    }

    private static enum TheLayerCake {
        MAIN_LAYER(0),
        IDENTITY_CREATION_FLOW_LAYER(1),
        NOTIFICATION_LAYER(2),
        MODAL_LAYER(3),
        NONE(4);

        private final int value;

        private TheLayerCake(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class DisplayedLayerWrapper {
        public final DisplayedLayer displayedLayer;

        private DisplayedLayerWrapper(DisplayedLayer displayedLayer) {
            this.displayedLayer = displayedLayer;
        }

        public static DisplayedLayerWrapper of(DisplayedLayer displayedLayer) {
            return new DisplayedLayerWrapper(displayedLayer);
        }
    }

    public static enum DisplayedLayer {
        MAIN,
        OWNED_IDENTITY_MANAGEMENT,
        MODAL,
        CLOSE_MODAL;

    }
}

