/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.invitations;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListModel;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.AutoInvitationHelper;
import io.olvid.windows.messenger.fx.invitations.InvitationListCell;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/invitation/invitation_view.fxml")
public class InvitationViewController
extends BaseModalController {
    @FXML
    private VBox invitation_list_container;
    @FXML
    private Hyperlink invitation_link;
    @FXML
    private Button button_refresh;
    @FXML
    public TextField invitation_new_input;
    @FXML
    public Button invitation_new_submit;
    @FXML
    private ListView<Invitation> invitation_list_view;
    @FXML
    public Button button_start_auto_invite;
    @FXML
    public Button button_invite_everyone;
    private String invitationUrl;
    private ListModel<Invitation> model;

    public InvitationViewController() {
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        Optional<OwnedIdentityInfo> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (ownedIdentity.isPresent()) {
            this.invitationUrl = InvitationApi.getUrlRepresentation(ownedIdentity.get());
        } else {
            this.invitationUrl = "";
            AppLogger.e("Unable to find current identity for invitation link !!!");
        }
        this.invitation_link.setText("Copy Invitation Link");
        this.invitation_link.setOnMouseClicked(event -> this.eventHandlerCopyUrlInvitationLinkToClipboard());
        this.invitation_new_submit.setOnMouseClicked(event -> this.eventHandlerSendInvitation());
        this.button_refresh.setOnMouseClicked(event -> this.eventHandlerRefreshMessages());
        ListPanelSelectModel<Invitation> invitationListPanelSelectModel = new ListPanelSelectModel<Invitation>(false, false);
        invitationListPanelSelectModel.setListView(this.invitation_list_view);
        this.model = new ListModel(LiveDataFactory.buildDbLiveDataList(Invitation.class, () -> ownedIdentity.map(ownedIdentityInfo -> DbManager.getInstance().getInvitationDao().getInvitationsByIdentity(ownedIdentityInfo.genId())).orElse(null)), invitationListPanelSelectModel);
        this.invitation_list_view.setItems(this.model.getList());
        this.invitation_list_view.setCellFactory(createInvitationCell -> new InvitationListCell());
        this.button_start_auto_invite.setOnMouseClicked(event -> AutoInvitationHelper.getInstance().startAutoInvitation());
        this.button_invite_everyone.setOnMouseClicked(event -> AutoInvitationHelper.getInstance().inviteEveryOtherIdentities());
    }

    private void eventHandlerRefreshMessages() {
        Optional<OwnedIdentityInfo> selectedOwnedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        selectedOwnedIdentity.ifPresent(ownedIdentityInfo -> EngineWrapper.getInstance().downloadMessages(ownedIdentityInfo.bytesOwnedIdentity()));
    }

    private void eventHandlerCopyUrlInvitationLinkToClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.invitationUrl);
        clipboard.setContent((Map)content);
    }

    private void eventHandlerSendInvitation() {
        Optional<OwnedIdentityInfo> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (ownedIdentity.isPresent() && InvitationApi.sendInvitation(this.invitation_new_input.getText(), ownedIdentity.get().bytesOwnedIdentity())) {
            this.invitation_new_input.setText("");
            this.invitation_new_input.setStyle("");
        } else {
            this.invitation_new_input.setText("");
            this.invitation_new_input.setStyle("-fx-background-color: red;");
        }
    }

    @Override
    public Region getLayout() {
        return this.invitation_list_container;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.model.unPlug();
    }

    @FXML
    public void closeModal(ActionEvent event) {
        this.closeModalDelegate.run();
    }
}

