/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;

public class TextHelper {
    static final Text helper = new Text();
    static final double DEFAULT_WRAPPING_WIDTH = helper.getWrappingWidth();
    static final double DEFAULT_LINE_SPACING = helper.getLineSpacing();
    static final String DEFAULT_TEXT = helper.getText();
    static final TextBoundsType DEFAULT_BOUNDS_TYPE = helper.getBoundsType();

    public static double computeTextWidth(Font font, String text, double help0) {
        helper.setText(text);
        helper.setFont(font);
        helper.setWrappingWidth(0.0);
        helper.setLineSpacing(0.0);
        double d = Math.min(helper.prefWidth(-1.0), help0);
        helper.setWrappingWidth((double)((int)Math.ceil(d)));
        d = Math.ceil(helper.getLayoutBounds().getWidth());
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        return d;
    }

    public static String getFirstNameAndLastNameFormatted(String firstName, String lastName) {
        Object textFormatted = firstName == null || firstName.isEmpty() ? lastName : (lastName == null || lastName.isEmpty() ? firstName : firstName + " " + lastName);
        return textFormatted;
    }

    public static String getPositionAndCompanyFormatted(String position, String company) {
        Object textFormatted = position == null || position.isEmpty() ? company : (company == null || company.isEmpty() ? position : position + " @ " + company);
        return textFormatted;
    }

    public static TextFormatter<String> getDigitOnlyTextFormatter() {
        UnaryOperator numberValidationFormatter = change -> {
            if (change.getText().matches("\\d+") || change.isDeleted()) {
                return change;
            }
            change.setText("");
            return change;
        };
        return new TextFormatter(numberValidationFormatter);
    }
}

