/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import io.olvid.windows.messenger.misc.Watches;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.PauseTransition;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.util.Duration;

public class ScrollbarOverlayHelper {
    private static final PseudoClass SCROLLBAR_VISIBLE = PseudoClass.getPseudoClass((String)"scrollbar-visible");
    private static final Duration HIDE_DELAY = Duration.millis((double)1000.0);
    private static final Map<ListView<?>, Listeners> LISTENERS_MAP = new WeakHashMap();
    private static final Map<ScrollPane, Listeners> SCROLL_PANE_LISTENERS_MAP = new WeakHashMap<ScrollPane, Listeners>();

    public static void setupOverlayScrollbar(ListView<?> listView) {
        ScrollbarOverlayHelper.setupOverlayScrollbar(listView, HIDE_DELAY);
    }

    public static void setupOverlayScrollbar(ScrollPane scrollPane) {
        ScrollbarOverlayHelper.setupOverlayScrollbar(scrollPane, HIDE_DELAY);
    }

    public static void setupOverlayScrollbar(ListView<?> listView, Duration hideDelay) {
        PauseTransition hideTransition = new PauseTransition(hideDelay);
        hideTransition.setOnFinished(e -> {
            Watches.Watch w = Watches.getInstance().start("listViewScrollBarHide");
            listView.pseudoClassStateChanged(SCROLLBAR_VISIBLE, false);
            w.stop();
        });
        listView.skinProperty().addListener((obs, oldSkin, newSkin) -> {
            ScrollbarOverlayHelper.removeListeners(listView);
            if (newSkin != null) {
                Watches.Watch wSkin = Watches.getInstance().start("listViewScrollbarSkinReady");
                ScrollBar scrollBar = (ScrollBar)listView.lookup(".scroll-bar:vertical");
                wSkin.stop();
                if (scrollBar != null) {
                    ChangeListener scrollValueListener = (o, oldVal, newVal) -> {
                        Watches.Watch w = Watches.getInstance().start("listViewScrollbarOnScroll");
                        listView.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                        hideTransition.playFromStart();
                        w.stop();
                    };
                    ChangeListener listHoverListener = (o, wasHover, isHover) -> {
                        Watches.Watch w = Watches.getInstance().start("listViewScrollBarListHover");
                        if (isHover.booleanValue()) {
                            listView.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                            hideTransition.stop();
                        } else {
                            hideTransition.playFromStart();
                        }
                        w.stop();
                    };
                    ChangeListener barHoverListener = (o, wasHover, isHover) -> {
                        Watches.Watch w = Watches.getInstance().start("listViewScrollBarSelfHover");
                        if (isHover.booleanValue()) {
                            hideTransition.stop();
                            listView.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                        } else {
                            hideTransition.playFromStart();
                        }
                        w.stop();
                    };
                    scrollBar.valueProperty().addListener(scrollValueListener);
                    listView.hoverProperty().addListener(listHoverListener);
                    scrollBar.hoverProperty().addListener(barHoverListener);
                    LISTENERS_MAP.put(listView, new Listeners((ChangeListener<Number>)scrollValueListener, (ChangeListener<Boolean>)listHoverListener, (ChangeListener<Boolean>)barHoverListener));
                }
            }
        });
    }

    public static void setupOverlayScrollbar(ScrollPane scrollPane, Duration hideDelay) {
        PauseTransition hideTransition = new PauseTransition(hideDelay);
        hideTransition.setOnFinished(e -> {
            Watches.Watch w = Watches.getInstance().start("scrollPaneScrollBarHide");
            scrollPane.pseudoClassStateChanged(SCROLLBAR_VISIBLE, false);
            w.stop();
        });
        scrollPane.skinProperty().addListener((obs, oldSkin, newSkin) -> {
            ScrollbarOverlayHelper.removeListeners(scrollPane);
            if (newSkin != null) {
                Watches.Watch wSkin = Watches.getInstance().start("scrollPaneScrollbarSkinReady");
                ScrollBar scrollBar = (ScrollBar)scrollPane.lookup(".scroll-bar:vertical");
                wSkin.stop();
                if (scrollBar != null) {
                    ChangeListener scrollValueListener = (o, oldVal, newVal) -> {
                        Watches.Watch w = Watches.getInstance().start("scrollPaneScrollbarOnScroll");
                        scrollPane.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                        hideTransition.playFromStart();
                        w.stop();
                    };
                    ChangeListener listHoverListener = (o, wasHover, isHover) -> {
                        Watches.Watch w = Watches.getInstance().start("scrollPaneScrollBarListHover");
                        if (isHover.booleanValue()) {
                            scrollPane.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                            hideTransition.stop();
                        } else {
                            hideTransition.playFromStart();
                        }
                        w.stop();
                    };
                    ChangeListener barHoverListener = (o, wasHover, isHover) -> {
                        Watches.Watch w = Watches.getInstance().start("scrollPaneScrollBarSelfHover");
                        if (isHover.booleanValue()) {
                            hideTransition.stop();
                            scrollPane.pseudoClassStateChanged(SCROLLBAR_VISIBLE, true);
                        } else {
                            hideTransition.playFromStart();
                        }
                        w.stop();
                    };
                    scrollBar.valueProperty().addListener(scrollValueListener);
                    scrollPane.hoverProperty().addListener(listHoverListener);
                    scrollBar.hoverProperty().addListener(barHoverListener);
                    SCROLL_PANE_LISTENERS_MAP.put(scrollPane, new Listeners((ChangeListener<Number>)scrollValueListener, (ChangeListener<Boolean>)listHoverListener, (ChangeListener<Boolean>)barHoverListener));
                }
            }
        });
    }

    public static void removeListeners(ListView<?> listView) {
        Listeners l = LISTENERS_MAP.remove(listView);
        if (l == null) {
            return;
        }
        ScrollBar scrollBar = (ScrollBar)listView.lookup(".scroll-bar:vertical");
        if (scrollBar == null) {
            return;
        }
        scrollBar.valueProperty().removeListener(l.scrollValueListener());
        listView.hoverProperty().removeListener(l.listHoverListener());
        scrollBar.hoverProperty().removeListener(l.barHoverListener());
    }

    public static void removeListeners(ScrollPane scrollPane) {
        Listeners l = SCROLL_PANE_LISTENERS_MAP.remove(scrollPane);
        if (l == null) {
            return;
        }
        ScrollBar scrollBar = (ScrollBar)scrollPane.lookup(".scroll-bar:vertical");
        if (scrollBar == null) {
            return;
        }
        scrollBar.valueProperty().removeListener(l.scrollValueListener());
        scrollPane.hoverProperty().removeListener(l.listHoverListener());
        scrollBar.hoverProperty().removeListener(l.barHoverListener());
    }

    private record Listeners(ChangeListener<Number> scrollValueListener, ChangeListener<Boolean> listHoverListener, ChangeListener<Boolean> barHoverListener) {
    }
}

