/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListItemSearchHelper {
    public static boolean contactSearchPredicate(ContactInfo contactInfo, List<Pattern> filterPatterns) {
        String fullSearchDisplayName = contactInfo.getFullSearchDisplayName();
        return ListItemSearchHelper.checkIfPatternsFound(Stream.of(Optional.of(fullSearchDisplayName)), filterPatterns);
    }

    public static boolean groupSearchPredicate(Group group, List<Pattern> filterPatterns) {
        Stream<Optional<String>> searchOptional = Stream.of(group.getCustomNameOrName(), group.getDescription(), group.getGroupMembersNames());
        return ListItemSearchHelper.checkIfPatternsFound(searchOptional, filterPatterns);
    }

    public static boolean discussionSearchPredicate(DiscussionInfo discussion, List<Pattern> filterPatterns) {
        return ListItemSearchHelper.checkIfPatternsFound(Stream.of(discussion.title()), filterPatterns);
    }

    public static boolean keycloakDirectorySearchPredicate(KeycloakUserDetailsListItemData currentKeycloakDetails, List<Pattern> filterPatterns) {
        return ListItemSearchHelper.checkIfPatternsFound(Stream.of(Optional.ofNullable(currentKeycloakDetails.fullSearchDisplayName)), filterPatterns);
    }

    private static boolean checkIfPatternsFound(Stream<Optional<String>> searchOptional, List<Pattern> filterPatterns) {
        Set stringSearch = searchOptional.flatMap(Optional::stream).filter(it -> !it.isEmpty()).map(String::toLowerCase).map(StringUtils::unAccent).collect(Collectors.toSet());
        return filterPatterns.stream().allMatch(pattern -> stringSearch.stream().anyMatch(searchString -> pattern.matcher((CharSequence)searchString).find()));
    }
}

