/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.groups_list;

import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;

public class GroupListCell
extends AbstractListCell<Group> {
    private final BubbleAndDescription bubbleAndDescription;
    private Optional<Group> lastKnownGroup = Optional.empty();

    public GroupListCell() {
        this.initListCell(true);
        this.bubbleAndDescription = new BubbleAndDescription();
        BorderPane.setMargin((Node)this.bubbleAndDescription.bubble, (Insets)new Insets(0.0, 12.0, 0.0, 4.0));
    }

    @Override
    protected void updateItem(Group group, boolean empty) {
        super.updateItem(group, empty);
        if (empty || group == null) {
            this.lastKnownGroup = Optional.empty();
            this.setGraphic(null);
            return;
        }
        if (this.lastKnownGroup.isPresent() && this.lastKnownGroup.get().equals(group)) {
            return;
        }
        this.bubbleAndDescription.title.setText(group.getDisplayName().orElse(ViewControllerHelper.getString("unnamed_group")));
        this.bubbleAndDescription.setSubtitle(group.getGroupMembersNames());
        BubbleUtils.setBubbleData(group, this.bubbleAndDescription.bubble);
        this.lastKnownGroup = Optional.of(group);
        this.setGraphic((Node)this.bubbleAndDescription);
    }
}

