/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management.creation.controller;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BindingUtils;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;

@FXMLView(path="fx/groups/new_group_flow/confirmation.fxml")
public class ConfirmationController
extends BaseViewController {
    public static final int CELL_HEIGHT = 88;
    private final GroupCreationFlowModel model;
    @FXML
    private VBox root;
    @FXML
    private TextField group_name_text_field;
    @FXML
    private TextField group_description_text_field;
    @FXML
    private Button group_picture_button;
    @FXML
    private StackPane bubble_container;
    @FXML
    private StackPane list_view_container;

    public ConfirmationController(GroupCreationFlowModel flowModel) {
        this.model = flowModel;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.group_picture_button.setOnAction(this::editPhotoButtonHandler);
        this.model.descriptionProperty().bindBidirectional((Property)this.group_description_text_field.textProperty());
        this.model.nameProperty().bindBidirectional((Property)this.group_name_text_field.textProperty());
        this.addMemberList();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void addMemberList() {
        ListView memberList = new ListView();
        memberList.setCellFactory(contactListView -> new ContactListCell(false));
        memberList.setFixedCellSize(70.0);
        BindingUtils.bindMappedListFromSelectModel(memberList.getItems(), this.model.getSelectedModelContact(), Function.identity());
        this.list_view_container.getChildren().add((Object)memberList);
        this.list_view_container.prefHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)Bindings.size((ObservableList)memberList.getItems()).multiply(88), (int)250));
    }

    private void editPhotoButtonHandler(ActionEvent event) {
        AppLogger.t("CardCreateGroupController::editPhotoButtonHandler()");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("choose_photo"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File homeFile = homePath == null ? null : new File(homePath);
        fileChooser.setInitialDirectory(homeFile);
        File photo = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (photo != null && !photo.getAbsolutePath().isEmpty()) {
            AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(photo.getAbsolutePath(), 1080, 1080, this::onSuccess, null));
        }
    }

    private void onSuccess(String secureRelativeFilePath) {
        AppLogger.t("CardCreateGroupController::onSuccess()");
        ViewControllerHelper.smartUIUpdate(() -> {
            IdentityBubble pictureBubble = new IdentityBubble(this.bubble_container.getHeight() / 2.0);
            pictureBubble.setPhotoUrlRelPath(Optional.of(secureRelativeFilePath));
            this.bubble_container.getChildren().setAll((Object[])new Node[]{pictureBubble});
            this.group_name_text_field.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.isEmpty()) {
                    pictureBubble.setInitial(StringUtils.firstChar(newValue));
                    pictureBubble.setColorByteSource(null);
                    pictureBubble.setPhotoUrlRelPath(Optional.of(secureRelativeFilePath));
                }
            });
            this.model.setAbsPhotoPath(FileApi.absolutePathFromRelative(secureRelativeFilePath));
        });
    }
}

