/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management.creation;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.api.GroupCreationInterface;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupType;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.AdminSelectionController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.AdvanceParametersController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.ConfirmationController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.MemberSelectionController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.TemplateSelectionController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonBuilder;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ModalButtonType;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilderInterfaces;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class FlowConstructor {
    public static void initGroupModal(ModalFlowController<DiscussionFlowId> groupModalFlow, DiscussionFlowId previousStateId) {
        GroupCreationFlowModel flowModel = new GroupCreationFlowModel();
        FlowConstructor.addMemberSelectionModalWithPrevious(groupModalFlow, flowModel, previousStateId);
        FlowConstructor.addDiscussionTypeModal(groupModalFlow, flowModel);
        FlowConstructor.addAdvanceParametersModal(groupModalFlow, flowModel);
        FlowConstructor.addAdminChoiceModal(groupModalFlow, flowModel);
        FlowConstructor.addConfirmationModal(groupModalFlow, flowModel);
    }

    public static void initGroupModal(ModalFlowController<DiscussionFlowId> groupModalFlow) {
        GroupCreationFlowModel flowModel = new GroupCreationFlowModel();
        FlowConstructor.addMemberSelectionModal(groupModalFlow, flowModel);
        FlowConstructor.addDiscussionTypeModal(groupModalFlow, flowModel);
        FlowConstructor.addAdvanceParametersModal(groupModalFlow, flowModel);
        FlowConstructor.addAdminChoiceModal(groupModalFlow, flowModel);
        FlowConstructor.addConfirmationModal(groupModalFlow, flowModel);
    }

    private static void addConfirmationModal(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        ConfirmationController groupConfirmation = new ConfirmationController(flowModel);
        ModalFlowController.builder().withInnerNode((Node)groupConfirmation.getLayout()).withTitle(ViewControllerHelper.getString("modal_new_group_confirm_title")).withBottomButton(new ButtonBuilder().withStandardButtonDefault(ModalButtonType.CANCEL).build(), new ButtonBuilder().withStandardButtonDefault(ModalButtonType.TEXT_PRIMARY).withAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            switch (flowModel.getDiscussionType()) {
                case READ_ONLY: {
                    FlowConstructor.setReadOnlyPresetPermission(flowModel);
                    break;
                }
                case CUSTOM: {
                    FlowConstructor.setCustomPermission(flowModel);
                    break;
                }
                case STANDARD: {
                    FlowConstructor.setPublicPresetPermission(flowModel);
                    break;
                }
                case CONTROLLED: {
                    FlowConstructor.setPrivatePresetPermission(flowModel);
                    break;
                }
            }
            FlowConstructor.createGroup(flowModel);
            groupModalFlow.close();
        })).withText(ViewControllerHelper.getString("modal_new_group_type_save")).build()).withPreviousStep(() -> {
            GroupFlowStateId next = null;
            switch (flowModel.getDiscussionType()) {
                case STANDARD: 
                case CONTROLLED: 
                case READ_ONLY: {
                    next = GroupFlowStateId.DISCUSSION_TYPE;
                    break;
                }
                case CUSTOM: {
                    next = GroupFlowStateId.ADVANCE_PARAMETERS;
                    break;
                }
                case NONE: {
                    AppLogger.e("The dicussion type of the group creation is NONE at the creation moment, this should be impossible", new Exception());
                }
            }
            return next;
        }).addInModalStateFlow(GroupFlowStateId.CONFIRMATION, groupModalFlow);
    }

    private static void addAdminChoiceModal(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        AdminSelectionController listMemberParameters = new AdminSelectionController(flowModel);
        ModalFlowController.builder().withInnerNode(listMemberParameters.getRoot()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal_new_group_admin_title")).withoutButton().withPreviousStep(GroupFlowStateId.ADVANCE_PARAMETERS).addInModalStateFlow(GroupFlowStateId.ADMIN_CHOICE, groupModalFlow);
    }

    private static void addAdvanceParametersModal(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        AdvanceParametersController advanceParametersController = new AdvanceParametersController(flowModel, groupModalFlow);
        ModalFlowController.builder().withInnerNode((Node)advanceParametersController.getLayout()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_group.type.parameters.title")).withBottomButton(new ButtonBuilder().withStandardButtonDefault(ModalButtonType.CANCEL).build(), new ButtonBuilder().withStandardButtonDefault(ModalButtonType.TEXT_PRIMARY).withCustomInstance(button -> {
            button.setText(ViewControllerHelper.getString("modal_new_group_type_save"));
            button.setOnAction(event -> groupModalFlow.setState(GroupFlowStateId.CONFIRMATION));
        }).build()).withPreviousStep(GroupFlowStateId.DISCUSSION_TYPE).addInModalStateFlow(GroupFlowStateId.ADVANCE_PARAMETERS, groupModalFlow);
    }

    private static void addDiscussionTypeModal(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        TemplateSelectionController discussionTypeController = new TemplateSelectionController(flowModel);
        ModalFlowController.builder().withInnerNode((Node)discussionTypeController.getLayout()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_group.type.title")).withBottomButton(new ButtonBuilder().withStandardButtonDefault(ModalButtonType.NEXT_ARROW).withCustomInstance(button -> button.disableProperty().bind((ObservableValue)discussionTypeController.selectedStateProperty().isEqualTo((Object)GroupType.NONE))).withAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            switch (discussionTypeController.getSelectedState()) {
                case CUSTOM: {
                    groupModalFlow.setState(GroupFlowStateId.ADVANCE_PARAMETERS);
                    break;
                }
                case STANDARD: 
                case CONTROLLED: 
                case READ_ONLY: {
                    groupModalFlow.setState(GroupFlowStateId.CONFIRMATION);
                    break;
                }
            }
        })).build()).withPreviousStep(GroupFlowStateId.MEMBER_SELECTION).addInModalStateFlow(GroupFlowStateId.DISCUSSION_TYPE, groupModalFlow);
    }

    private static void addMemberSelectionModal(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        MemberSelectionController chooseMember = new MemberSelectionController(flowModel);
        ModalFlowController.builder().withInnerNode((Node)chooseMember.getRoot()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_group.title")).withFloatingButton(new ButtonBuilder().withStandardButtonDefault(ModalButtonType.NEXT_ARROW).withAction((EventHandler<MouseEvent>)((EventHandler)event -> groupModalFlow.setState(GroupFlowStateId.DISCUSSION_TYPE))).build().button()).addInModalStateFlow(GroupFlowStateId.MEMBER_SELECTION, groupModalFlow);
    }

    private static void addMemberSelectionModalWithPrevious(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel, DiscussionFlowId previousStateId) {
        ModalBuilderInterfaces.AllBuilder boostrapBuilder = FlowConstructor.getBootstrappedMemberSelectionBuilder(groupModalFlow, flowModel);
        boostrapBuilder.withPreviousStep(previousStateId).addInModalStateFlow(GroupFlowStateId.MEMBER_SELECTION, groupModalFlow);
    }

    private static ModalBuilderInterfaces.AllBuilder getBootstrappedMemberSelectionBuilder(ModalFlowController<DiscussionFlowId> groupModalFlow, GroupCreationFlowModel flowModel) {
        MemberSelectionController chooseMember = new MemberSelectionController(flowModel);
        return ModalFlowController.builder().withInnerNode((Node)chooseMember.getRoot()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_group.title")).withFloatingButton(new ButtonBuilder().withStandardButtonDefault(ModalButtonType.NEXT_ARROW).withAction((EventHandler<MouseEvent>)((EventHandler)event -> groupModalFlow.setState(GroupFlowStateId.DISCUSSION_TYPE))).build().button());
    }

    private static void setCustomPermission(GroupCreationFlowModel flowModel) {
        HashSet<String> memberSet = new HashSet<String>();
        if (!flowModel.isReadOnly()) {
            memberSet.add(GroupV2.Permission.SEND_MESSAGE.getString());
            memberSet.add(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES.getString());
        }
        Set<String> adminSet = GroupHelper.getReadOnlyAdminPermissionsAsString();
        switch (flowModel.getDeletePermission()) {
            case ADMIN_ONLY: {
                adminSet.add(GroupV2.Permission.REMOTE_DELETE_ANYTHING.getString());
                break;
            }
            case EVERY_ONE: {
                adminSet.add(GroupV2.Permission.REMOTE_DELETE_ANYTHING.getString());
                memberSet.add(GroupV2.Permission.REMOTE_DELETE_ANYTHING.getString());
                break;
            }
        }
        ObservableSet<ContactInfo> admins = flowModel.getAdminSelectModel().getSelectedItems();
        flowModel.getSelectedModelContact().getSelectedItems().forEach(contact -> {
            if (admins.contains(contact)) {
                flowModel.getContactPermission().put(contact, (Object)adminSet);
            } else {
                flowModel.getContactPermission().put(contact, (Object)memberSet);
            }
        });
        flowModel.getOwnedPermission().addAll(adminSet);
    }

    private static void setPrivatePresetPermission(GroupCreationFlowModel flowModel) {
        flowModel.getContactPermission().clear();
        flowModel.getSelectedModelContact().getSelectedItems().forEach(contact -> flowModel.getContactPermission().put(contact, GroupHelper.getDefaultMemberPermissionsAsString()));
        flowModel.getOwnedPermission().addAll(GroupHelper.getDefaultAdminPermissionsAsString());
    }

    private static void setPublicPresetPermission(GroupCreationFlowModel flowModel) {
        flowModel.getContactPermission().clear();
        flowModel.getSelectedModelContact().getSelectedItems().forEach(contact -> flowModel.getContactPermission().put(contact, GroupHelper.getDefaultAdminPermissionsAsString()));
        flowModel.getOwnedPermission().addAll(GroupHelper.getDefaultAdminPermissionsAsString());
    }

    private static void setReadOnlyPresetPermission(GroupCreationFlowModel flowModel) {
        flowModel.getContactPermission().clear();
        flowModel.getSelectedModelContact().getSelectedItems().forEach(contact -> flowModel.getContactPermission().put(contact, Collections.emptySet()));
        flowModel.getOwnedPermission().addAll(GroupHelper.getDefaultAdminPermissionsAsString());
    }

    private static void createGroup(GroupCreationFlowModel model) {
        GroupCreationInterface apiImpl = Api.getGroupCreationApi(GroupGenerated.Version.VERSION_2);
        HashMap groupMemberPermission = new HashMap();
        model.getSelectedModelContact().getSelectedItems().forEach(contact -> groupMemberPermission.put(BytesKey.of(contact.bytesContactIdentity()), (Set)model.getContactPermission().get(contact)));
        Optional<OwnedIdentityInfo> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (ownedIdentity.isPresent() && apiImpl != null) {
            String name = !Objects.equals(model.getName(), "") ? model.getName() : null;
            Optional<String> serializedObvGroupType = GroupHelper.getObvSerializedGroupType((GroupType)((Object)model.discussionTypeProperty().get()), model.isReadOnly(), (GroupCreationFlowModel.DeletePermission)((Object)model.deletePermissionProperty().get()));
            serializedObvGroupType.ifPresentOrElse(s -> apiImpl.createGroup(((OwnedIdentityInfo)ownedIdentity.get()).bytesOwnedIdentity(), Optional.ofNullable(name), Optional.of(model.getDescription()), Optional.ofNullable(model.getAbsPhotoPath()), model.getOwnedPermission(), groupMemberPermission, (String)s), () -> AppLogger.w("GroupCreationFlow::createGroup couldn't compute serialized group type"));
        }
    }

    public static enum GroupFlowStateId implements DiscussionFlowId
    {
        MEMBER_SELECTION,
        DISCUSSION_TYPE,
        ADVANCE_PARAMETERS,
        EPHEMERAL_PARAMETERS,
        CONFIRMATION,
        ADMIN_CHOICE;

    }
}

