/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view.model;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.misc.ByteArray;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.control.ListView;

public class ListPanelSelectModel<DataType extends Diffable> {
    private final Boolean multiSelectionEnabled;
    private final boolean unselectDisabled;
    private final ObservableSet<HashsetItemWrapper<DataType>> selectedItems = FXCollections.observableSet(ConcurrentHashMap.newKeySet());
    private final ObservableSet<DataType> selectedItemsUnwrap = FXCollections.observableSet(ConcurrentHashMap.newKeySet());
    private final ObservableSet<DataType> unmodifiableSelectedItemsList = FXCollections.unmodifiableObservableSet(this.selectedItemsUnwrap);

    public ListPanelSelectModel(Boolean multiSelectionEnabled, boolean unselectDisabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
        this.unselectDisabled = unselectDisabled;
        this.selectedItems.addListener(change -> {
            Object item;
            if (change.wasAdded()) {
                item = ((HashsetItemWrapper)change.getElementAdded()).item();
                this.selectedItemsUnwrap.add(item);
            }
            if (change.wasRemoved()) {
                item = ((HashsetItemWrapper)change.getElementRemoved()).item();
                this.selectedItemsUnwrap.remove(item);
            }
        });
    }

    public void setListView(ListView<DataType> listView) {
        this.selectedItems.addListener(change -> {
            Object item;
            if (change.wasAdded()) {
                item = ((HashsetItemWrapper)change.getElementAdded()).item();
                listView.getSelectionModel().select(item);
            }
            if (change.wasRemoved()) {
                item = ((HashsetItemWrapper)change.getElementRemoved()).item();
                int index = listView.getItems().indexOf(item);
                if (index != -1) {
                    listView.getSelectionModel().clearSelection(index);
                }
            }
        });
    }

    public void clearSelection() {
        this.selectedItems.clear();
    }

    public ObservableSet<DataType> getSelectedItems() {
        return this.unmodifiableSelectedItemsList;
    }

    public void selectItem(DataType item) {
        ViewControllerHelper.smartUIUpdate(() -> {
            Objects.requireNonNull(item);
            Objects.requireNonNull(this.multiSelectionEnabled);
            HashsetItemWrapper<Diffable> wrappedItem = new HashsetItemWrapper<Diffable>((Diffable)item);
            if (!this.selectedItems.contains(wrappedItem)) {
                if (!this.multiSelectionEnabled.booleanValue()) {
                    this.selectedItems.clear();
                }
                this.selectedItems.add(wrappedItem);
            }
        });
    }

    public void unselectItem(DataType item) {
        ViewControllerHelper.smartUIUpdate(() -> {
            Objects.requireNonNull(item);
            Objects.requireNonNull(this.multiSelectionEnabled);
            HashsetItemWrapper<Diffable> wrappedItem = new HashsetItemWrapper<Diffable>((Diffable)item);
            if (this.selectedItems.contains(wrappedItem)) {
                if (this.multiSelectionEnabled.booleanValue()) {
                    this.selectedItems.remove(wrappedItem);
                } else if (!this.unselectDisabled) {
                    this.selectedItems.remove(wrappedItem);
                }
            }
        });
    }

    public void switchItemSelection(DataType item) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (this.multiSelectionEnabled == null) {
                return;
            }
            Objects.requireNonNull(item);
            HashsetItemWrapper<Diffable> wrappedItem = new HashsetItemWrapper<Diffable>((Diffable)item);
            if (!this.selectedItems.contains(wrappedItem)) {
                if (!this.multiSelectionEnabled.booleanValue()) {
                    this.selectedItems.clear();
                }
                this.selectedItems.add(wrappedItem);
            } else if (this.multiSelectionEnabled.booleanValue()) {
                this.selectedItems.remove(wrappedItem);
            } else if (!this.unselectDisabled) {
                this.selectedItems.remove(wrappedItem);
            }
        });
    }

    public void plug() {
    }

    public void unplug() {
    }

    public ObservableValue<Boolean> isSelectProperty(DataType item) {
        HashsetItemWrapper<DataType> wrappedItem = new HashsetItemWrapper<DataType>(item);
        return Bindings.createBooleanBinding(() -> this.selectedItems.contains((Object)wrappedItem), (Observable[])new Observable[]{this.selectedItems});
    }

    public BooleanBinding hasSelectedItemsProperty() {
        return Bindings.isNotEmpty(this.selectedItems);
    }

    private record HashsetItemWrapper<DataType extends Diffable>(DataType item) {
        @Override
        public int hashCode() {
            Object id = this.item.getItemId();
            if (id instanceof Long) {
                return Long.hashCode((Long)id);
            }
            if (id instanceof String) {
                return id.hashCode();
            }
            if (id instanceof Id) {
                return id.hashCode();
            }
            if (id instanceof ByteArray) {
                return id.hashCode();
            }
            throw new RuntimeException("RHOOOO hashcode not implemented for " + String.valueOf(id.getClass()));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HashsetItemWrapper) {
                HashsetItemWrapper casted = (HashsetItemWrapper)obj;
                return Objects.equals(this.item().getItemId(), casted.item().getItemId());
            }
            return false;
        }
    }
}

