/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view.model;

import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import java.util.Comparator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public final class ListModel<DataType extends Diffable> {
    private final ListPanelSelectModel<DataType> selectModel;
    private final boolean addEmptyElementAsLast;
    private LiveData<List<DataType>> liveData;
    private final ObservableList<DataType> observableList = FXCollections.observableArrayList();
    private final FilteredList<DataType> filteredList;
    private final ObservableList<DataType> unmodifiableList;
    private final LiveDataListener<List<DataType>> listElementChanged = this::listElementChanged;

    public ListModel(LiveData<List<DataType>> liveData, ListPanelSelectModel<DataType> selectModel, Comparator<DataType> comparator, boolean addEmptyElementAsLast) {
        this.addEmptyElementAsLast = addEmptyElementAsLast;
        this.selectModel = selectModel;
        this.filteredList = new FilteredList(this.observableList);
        SortedList list = this.filteredList;
        if (comparator != null) {
            SortedList sortedList = new SortedList(list);
            if (addEmptyElementAsLast) {
                sortedList.setComparator(Comparator.nullsLast(comparator));
            } else {
                sortedList.setComparator(comparator);
            }
            list = sortedList;
        }
        this.unmodifiableList = FXCollections.unmodifiableObservableList(list);
        if (liveData != null) {
            this.liveData = liveData;
            this.liveData.addListener(this.listElementChanged);
        }
    }

    public ListModel(LiveData<List<DataType>> liveData, ListPanelSelectModel<DataType> selectModel) {
        this(liveData, selectModel, null, false);
    }

    private void listElementChanged(List<DataType> newValue, List<DataType> oldValue) {
        List<Object> values = this.addEmptyElementAsLast ? CollectionUtils.asList(newValue, (Diffable)null) : newValue;
        ViewControllerHelper.smartUIUpdate(() -> DiffUtils.applyChanges(values, this.observableList));
    }

    public void addListener(LiveDataListener<List<DataType>> liveDataListener) {
        if (this.liveData != null) {
            this.liveData.addListener(liveDataListener);
        }
    }

    public void removeListener(LiveDataListener<List<DataType>> liveDataListener) {
        if (this.liveData != null) {
            this.liveData.removeListener(liveDataListener);
        }
    }

    public void plug() {
        if (this.liveData != null) {
            this.liveData.addListener(this.listElementChanged);
        }
        this.selectModel.plug();
    }

    public void unPlug() {
        if (this.liveData != null) {
            this.liveData.removeListener(this.listElementChanged);
        }
        this.selectModel.unplug();
    }

    public FilteredList<DataType> getFilteredList() {
        return this.filteredList;
    }

    public ObservableList<DataType> getList() {
        return this.unmodifiableList;
    }
}

