/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view.controller;

import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseButton;
import javafx.util.Callback;

public class StandardListViewController<DataType extends Diffable> {
    private final ListPanelSelectModel<DataType> selectModel;
    protected ListView<DataType> listView = new ListView();
    private final Callback<ListView<DataType>, AbstractListCell<DataType>> cellFactory;
    protected final AppLogger logger = new AppLogger(this.getClass());
    private final BiConsumer<DataType, Node> onItemSelectionConsumer;
    private final DoubleBinding emptySizeBinding;
    private final Optional<Double> emptySizeFix;

    public StandardListViewController(Callback<ListView<DataType>, AbstractListCell<DataType>> cellFactory, ObservableList<DataType> items, ListPanelSelectModel<DataType> selectModel, BiConsumer<DataType, Node> onItemSelectionConsumer) {
        this(cellFactory, items, selectModel, onItemSelectionConsumer, null, Optional.empty());
    }

    public StandardListViewController(Callback<ListView<DataType>, AbstractListCell<DataType>> cellFactory, ObservableList<DataType> items, ListPanelSelectModel<DataType> selectModel, BiConsumer<DataType, Node> onItemSelectionConsumer, DoubleBinding emptySizeBinding, Optional<Double> emptySizeFix) {
        this.cellFactory = cellFactory;
        this.selectModel = selectModel;
        this.emptySizeBinding = emptySizeBinding;
        this.emptySizeFix = emptySizeFix;
        this.onItemSelectionConsumer = onItemSelectionConsumer;
        this.listView.setItems(items);
        this.listView.setCellFactory(this::abstractCellFactory);
        this.listView.setPrefHeight(-1.0);
    }

    private ListCell<DataType> abstractCellFactory(ListView<DataType> listView) {
        AbstractListCell cellInTheMaking = (AbstractListCell)((Object)this.cellFactory.call(this.listView));
        cellInTheMaking.setSelectModel(this.selectModel);
        if (this.emptySizeBinding != null) {
            cellInTheMaking.emptySizeProperty().bind((ObservableValue)this.emptySizeBinding);
        }
        if (this.emptySizeFix.isPresent()) {
            cellInTheMaking.setEmptySize(this.emptySizeFix.get());
        }
        cellInTheMaking.setOnMouseClicked(event -> {
            if (event == null || MouseButton.PRIMARY != event.getButton() || cellInTheMaking.getItem() == null) {
                return;
            }
            Diffable item = (Diffable)cellInTheMaking.getItem();
            this.selectModel.switchItemSelection(item);
            if (this.onItemSelectionConsumer != null) {
                EventTarget target = event.getTarget();
                if (target instanceof Node) {
                    Node node = (Node)target;
                    this.onItemSelectionConsumer.accept(item, node);
                } else {
                    this.logger.error("clicked on target that is not a Node -> " + String.valueOf(target.getClass()));
                }
            }
        });
        if (cellInTheMaking.checkBox != null) {
            cellInTheMaking.checkBox.setMouseTransparent(true);
        }
        return cellInTheMaking;
    }

    public ListView<DataType> getListView() {
        return this.listView;
    }
}

