/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.BuilderInterface;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListBuilder;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.StandardListViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListModel;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.geometry.Insets;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public final class StandardPanelListController<DataType extends Diffable>
extends BaseViewController {
    private static final double SCROLL_BAR_TOLERANCE = 100.0;
    private final VBox listViewContainer = new VBox();
    private final ListView<DataType> listViewNode;
    private final ListPanelSelectModel<DataType> selectModel;
    private Optional<SearchBarController> searchBar = Optional.empty();
    private ListModel<DataType> listModel;
    private final Predicate<DataType> baseFilter;

    StandardPanelListController(StandardPanelListBuilder<DataType> builder) {
        this.listViewContainer.setFillWidth(true);
        this.baseFilter = builder.filter;
        this.selectModel = Objects.requireNonNullElseGet(builder.listSelectionModel, () -> new ListPanelSelectModel(builder.multiSelectionEnable, builder.disableUnselect));
        boolean addEmptyElementAsLast = builder.bottomMarginBinding != null || builder.bottomMarginFixSize.isPresent();
        this.listModel = new ListModel(builder.liveData, this.selectModel, builder.comparator, addEmptyElementAsLast);
        if (builder.searchPredicate != null || builder.customSearchTextConsumer != null) {
            this.searchBar = builder.searchBarController.isPresent() ? builder.searchBarController : Optional.of(new SearchBarController());
            this.listViewContainer.getChildren().add((Object)this.searchBar.get().getLayout());
            if (builder.searchPredicate != null) {
                this.searchBar.get().bindFilter(builder.searchPredicate, this.listModel.getFilteredList(), Optional.ofNullable(builder.filter));
            } else {
                this.searchBar.get().addCustomSearchListener(builder.customSearchTextConsumer);
            }
        }
        if (builder.searchPredicate == null && builder.filter != null) {
            this.listModel.getFilteredList().setPredicate(builder.filter);
        }
        StandardListViewController standardListView = new StandardListViewController(builder.cellFactory, this.listModel.getList(), this.selectModel, builder.itemClickedConsumer, builder.bottomMarginBinding, builder.bottomMarginFixSize);
        this.listViewNode = standardListView.getListView();
        this.selectModel.setListView(this.listViewNode);
        if (builder.multiSelectionEnable != null) {
            this.listViewNode.getSelectionModel().setSelectionMode(builder.multiSelectionEnable != false ? SelectionMode.MULTIPLE : SelectionMode.SINGLE);
        }
        this.listViewContainer.getChildren().add(this.listViewNode);
        VBox.setMargin(this.listViewNode, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        VBox.setVgrow(this.listViewNode, (Priority)Priority.ALWAYS);
        if (builder.buttonController != null) {
            this.listViewContainer.getChildren().add((Object)builder.buttonController.getLayout());
        }
        this.bindLifecycle();
    }

    public static BuilderInterface.LiveDatable builder() {
        return new BuilderInterface.LiveDatable(){

            @Override
            public <DataType extends Diffable> BuilderInterface.DataTypeable<DataType> withLiveData(LiveData<List<DataType>> liveData) {
                StandardPanelListBuilder subBuilder = new StandardPanelListBuilder();
                subBuilder.liveData = liveData;
                return subBuilder;
            }
        };
    }

    public VBox getLayout() {
        return this.listViewContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public ListPanelSelectModel<DataType> getSelectionModel() {
        return this.selectModel;
    }

    public ListModel<DataType> getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel<DataType> listModel) {
        this.listModel = listModel;
    }

    public ListView<DataType> getListView() {
        return this.listViewNode;
    }

    public Optional<SearchBarController> getSearchBar() {
        return this.searchBar;
    }

    public int getFilteredItemCount() {
        if (this.listModel == null) {
            return 0;
        }
        return this.listModel.getFilteredList().size();
    }

    public void applyExternalFilter(Predicate<DataType> predicate) {
        this.listModel.getFilteredList().setPredicate(predicate);
    }
}

