/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view;

import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.Pane;

public abstract class AbstractListCell<T extends Diffable>
extends ListCell<T> {
    private static final PseudoClass PSEUDO_CLASS_FILLED = PseudoClass.getPseudoClass((String)"filled");
    protected final DoubleProperty emptySize = new SimpleDoubleProperty();
    public CheckBox checkBox;
    protected BooleanProperty select = new SimpleBooleanProperty();
    protected ListPanelSelectModel<T> selectModel;
    protected final AppLogger logger = new AppLogger(((Object)((Object)this)).getClass());

    protected AbstractListCell(String fxml_path, boolean selectable) {
        this();
        Objects.requireNonNull(fxml_path);
        ViewControllerHelper.loadNodeWithExplicitController(this, fxml_path);
        this.initListCell(selectable);
    }

    protected AbstractListCell() {
        this.bindWidth();
    }

    private void bindWidth() {
        this.listViewProperty().addListener((o, old, newList) -> {
            if (newList == null) {
                this.setPrefWidth(Double.NEGATIVE_INFINITY);
            } else {
                this.maxWidth(Double.MAX_VALUE);
                this.prefWidthProperty().bind((ObservableValue)this.getListView().widthProperty());
            }
        });
    }

    protected void initListCell(boolean selectable) {
        if (selectable) {
            this.select.addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.getStyleClass().remove((Object)"selected-item");
                } else if (!this.getStyleClass().contains((Object)"selected-item")) {
                    this.getStyleClass().addFirst((Object)"selected-item");
                }
            });
            if (this.getCheckBoxParent() != null) {
                this.checkBox = new CheckBox();
                this.checkBox.setMnemonicParsing(false);
                this.checkBox.selectedProperty().bind((ObservableValue)this.select);
                this.getCheckBoxParent().getChildren().add(0, (Object)this.checkBox);
            }
        }
    }

    protected void updateItem(T item, boolean empty) {
        boolean itemChanged = this.getItem() == null || item == null || ((Diffable)this.getItem()).getItemId() != item.getItemId();
        super.updateItem(item, empty);
        if (item == null) {
            if (!this.prefHeightProperty().isBound()) {
                this.prefHeightProperty().bind((ObservableValue)this.emptySize);
            }
            this.pseudoClassStateChanged(PSEUDO_CLASS_FILLED, false);
            if (this.selectModel != null) {
                this.select.unbind();
                this.select.set(false);
            }
            return;
        }
        this.prefHeightProperty().unbind();
        this.prefHeightProperty().set(-1.0);
        if (this.selectModel != null && (itemChanged || !this.select.isBound())) {
            this.select.bind(this.selectModel.isSelectProperty(item));
        }
    }

    protected boolean isItemChanged(T oldItem, T newItem) {
        return !DiffUtils.areContentTheSame(oldItem, newItem);
    }

    protected Pane getCheckBoxParent() {
        return null;
    }

    public boolean isSelect() {
        return this.select.get();
    }

    public BooleanProperty selectProperty() {
        return this.select;
    }

    public void setSelect(boolean select) {
        this.select.set(select);
    }

    public void setSelectModel(ListPanelSelectModel<T> panelSelectModel) {
        this.selectModel = panelSelectModel;
    }

    public DoubleProperty emptySizeProperty() {
        return this.emptySize;
    }

    public void setEmptySize(Double emptySize) {
        this.emptySize.unbind();
        this.emptySize.set(emptySize.doubleValue());
    }
}

