/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.reactions_details.components.ReactionInfoRow;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public final class DiffUtils {
    private DiffUtils() {
    }

    public static <T extends Diffable> boolean areContentTheSame(T left, T right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.areContentTheSame(right);
    }

    public static <T extends Diffable> boolean areContentTheSame(Optional<? extends T> left, Optional<? extends T> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.isEmpty() && right.isEmpty()) {
            return true;
        }
        if (left.isPresent() && right.isPresent()) {
            return ((Diffable)left.get()).areContentTheSame(right.get());
        }
        return false;
    }

    public static <T extends Diffable> boolean areContentTheSame(List<? extends T> left, List<? extends T> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            Diffable r;
            Diffable l = (Diffable)left.get(i);
            if (l.areContentTheSame(r = (Diffable)right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Diffable> void applyChanges(List<T> newValues, ObservableList<T> observableList) {
        ViewControllerHelper.checkUIThread();
        if (newValues == null || newValues.isEmpty()) {
            AppLogger.t("ListModel::onChange NewVal is NULL");
            observableList.clear();
            return;
        }
        for (int i = 0; i < Math.min(newValues.size(), observableList.size()); ++i) {
            Diffable current;
            Diffable value = (Diffable)newValues.get(i);
            if (DiffUtils.areContentTheSame(value, current = (Diffable)observableList.get(i))) continue;
            observableList.set(i, (Object)value);
        }
        if (newValues.size() > observableList.size()) {
            List<T> valuesToAdd = newValues.subList(observableList.size(), newValues.size());
            observableList.addAll(valuesToAdd);
        } else if (newValues.size() < observableList.size()) {
            List valuesToRemove = observableList.subList(newValues.size(), observableList.size());
            valuesToRemove.clear();
        }
    }

    public static <T extends Diffable> void replace(List<T> newValues, ObservableList<ObjectProperty<T>> observableList) {
        ViewControllerHelper.checkUIThread();
        if (newValues == null || newValues.isEmpty()) {
            AppLogger.t("ListModel::onChange NewVal is NULL");
            observableList.clear();
            return;
        }
        List<SimpleObjectProperty> values = newValues.stream().map(SimpleObjectProperty::new).toList();
        observableList.setAll(values);
    }

    public static <T extends Diffable> void applyChanges2(List<T> newValues, ObservableList<ObjectProperty<T>> observableList) {
        ViewControllerHelper.checkUIThread();
        if (newValues == null) {
            AppLogger.t("ListModel::onChange newValues is null");
        }
        if (newValues == null || newValues.isEmpty()) {
            observableList.clear();
            return;
        }
        if (observableList.isEmpty()) {
            List<SimpleObjectProperty> values = newValues.stream().map(SimpleObjectProperty::new).toList();
            observableList.addAll(values);
            return;
        }
        int delta = 0;
        Diffable t = (Diffable)((ObjectProperty)observableList.get(0)).get();
        if (t != null) {
            int indexOfT = -1;
            for (int i = 0; i < newValues.size(); ++i) {
                Diffable value = (Diffable)newValues.get(i);
                if (!t.getItemId().equals(value.getItemId())) continue;
                indexOfT = i;
                break;
            }
            if (indexOfT > 0) {
                List<SimpleObjectProperty> values = newValues.subList(0, indexOfT).stream().map(SimpleObjectProperty::new).toList();
                observableList.addAll(0, values);
                delta += values.size();
            }
        }
        for (int i = delta; i < Math.min(newValues.size(), observableList.size()); ++i) {
            Diffable value = (Diffable)newValues.get(i);
            ObjectProperty current = (ObjectProperty)observableList.get(i);
            if (current.get() == null) {
                observableList.set(i, (Object)new SimpleObjectProperty((Object)value));
                continue;
            }
            if (((Diffable)current.get()).getItemId().equals(value.getItemId())) {
                if (((Diffable)current.get()).areContentTheSame(value)) continue;
                current.set((Object)value);
                continue;
            }
            observableList.set(i, (Object)new SimpleObjectProperty((Object)value));
        }
        if (newValues.size() > observableList.size()) {
            List<T> valuesToAdd = newValues.subList(observableList.size(), newValues.size());
            observableList.addAll(valuesToAdd.stream().map(SimpleObjectProperty::new).toList());
        } else if (newValues.size() < observableList.size()) {
            List valuesToRemove = observableList.subList(newValues.size(), observableList.size());
            valuesToRemove.clear();
        }
    }

    private static <T extends Diffable, N extends Node> void clear(List<Node> nodes, Class<N> clazz) {
        for (Node node : nodes) {
            if (!clazz.isInstance(node)) {
                throw new ClassCastException();
            }
            Node n = (Node)clazz.cast(node);
            ((NodeController)n).dispose();
        }
        nodes.clear();
    }

    public static <T extends Diffable, N extends Node> void applyChanges(List<? extends T> values, Class<N> clazz, ObservableList<Node> nodes, Function<T, N> makeNode) {
        if (values == null || values.isEmpty()) {
            DiffUtils.clear(nodes, clazz);
            return;
        }
        for (int i = 0; i < Math.min(values.size(), nodes.size()); ++i) {
            Diffable value = (Diffable)values.get(i);
            Node node = (Node)nodes.get(i);
            if (!clazz.isInstance(node)) {
                throw new ClassCastException();
            }
            Node n = (Node)clazz.cast(node);
            if (DiffUtils.areContentTheSame(value, ((NodeController)n).getValue())) continue;
            ((NodeController)n).update(value);
        }
        if (values.size() > nodes.size()) {
            List<T> valuesToAdd = values.subList(nodes.size(), values.size());
            List<N> nodesToAdd = valuesToAdd.stream().map(makeNode).toList();
            nodes.addAll(nodesToAdd);
        } else if (values.size() < nodes.size()) {
            List nodesToRemove = nodes.subList(values.size(), nodes.size());
            DiffUtils.clear(nodesToRemove, clazz);
        }
    }

    private static <T extends Diffable, C extends NodeController<T>> void clear(List<C> controllers, List<Node> children) {
        if (controllers.isEmpty()) {
            return;
        }
        ArrayList<Node> toRemove = new ArrayList<Node>(controllers.size());
        ListIterator<C> iterator = controllers.listIterator();
        while (iterator.hasNext()) {
            NodeController controller = (NodeController)iterator.next();
            toRemove.add(controller.getNode());
            controller.dispose();
            iterator.remove();
        }
        children.removeAll(toRemove);
    }

    public static <T extends Diffable, C extends NodeController<T>> void applyChanges(List<? extends T> values, ObservableList<Node> children, List<C> controllers, Function<T, C> makeController) {
        int i;
        boolean clearRequired = false;
        if (controllers.size() != children.size()) {
            clearRequired = true;
        } else {
            for (i = 0; i < children.size(); ++i) {
                if (((NodeController)controllers.get(i)).getNode() == children.get(i)) continue;
                clearRequired = true;
                break;
            }
        }
        if (clearRequired) {
            children.clear();
            controllers.clear();
        }
        if (values == null || values.isEmpty()) {
            DiffUtils.clear(controllers, children);
            return;
        }
        for (i = 0; i < Math.min(values.size(), children.size()); ++i) {
            NodeController controller;
            Object currentValue;
            Diffable newValue = (Diffable)values.get(i);
            if (DiffUtils.areContentTheSame(newValue, currentValue = (controller = (NodeController)controllers.get(i)).getValue())) continue;
            controller.update(newValue);
        }
        for (i = 0; i < controllers.size(); ++i) {
            NodeController ctrl = (NodeController)controllers.get(i);
            if (!(ctrl instanceof ReactionInfoRow)) continue;
            ReactionInfoRow row = (ReactionInfoRow)ctrl;
            row.setIndex(i);
        }
        if (values.size() > children.size()) {
            List<T> valuesToAdd = values.subList(children.size(), values.size());
            ArrayList<Node> nodesToAdd = new ArrayList<Node>(valuesToAdd.size());
            for (Diffable value : valuesToAdd) {
                NodeController controller = (NodeController)makeController.apply(value);
                if (children.contains((Object)controller.getNode())) continue;
                if (controller instanceof ReactionInfoRow) {
                    ReactionInfoRow row = (ReactionInfoRow)controller;
                    row.setIndex(controllers.size());
                }
                nodesToAdd.add(controller.getNode());
                controllers.add(controller);
            }
            children.addAll(nodesToAdd);
        } else if (values.size() < children.size()) {
            int newSize = values.size();
            int currentSize = children.size();
            List<C> controllersToRemove = controllers.subList(newSize, currentSize);
            DiffUtils.clear(controllersToRemove, children);
        }
    }

    public static interface NodeController<T extends Diffable> {
        public T getValue();

        public Node getNode();

        public void update(T var1);

        public void dispose();
    }
}

