/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.view_controller;

import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javafx.animation.Animation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class ViewControllerManager<Key> {
    private final AppLogger logger = new AppLogger(this.getClass());
    private Map<Key, Callable<BaseViewController>> childrenControllerFactoriesPerId;
    private Map<Key, BaseViewController> childrenViewControllersPerId;
    private final Map<String, InternalReplaceArgsStruct> fragmentParentIdPerLastAnimatedReplaceData = new ConcurrentHashMap<String, InternalReplaceArgsStruct>();
    private Key currentViewControllerKey;
    private Key preparedControllerKey;
    private final ManagementMode managementMode;

    public ViewControllerManager(ManagementMode managementMode) {
        this.managementMode = managementMode;
    }

    public void registerChildrenControllers(Map<Key, Callable<BaseViewController>> controllerFactories) {
        this.childrenControllerFactoriesPerId = new HashMap<Key, Callable<BaseViewController>>(controllerFactories);
        this.childrenViewControllersPerId = new HashMap<Key, BaseViewController>(this.childrenControllerFactoriesPerId.size());
        if (this.managementMode == ManagementMode.EAGER) {
            for (Key viewControllerName : controllerFactories.keySet()) {
                try {
                    Callable<BaseViewController> facto = controllerFactories.get(viewControllerName);
                    BaseViewController viewController = facto != null ? facto.call() : null;
                    if (viewController == null) continue;
                    this.childrenViewControllersPerId.put(viewControllerName, viewController);
                }
                catch (Exception e) {
                    this.logger.error("NEVER DISPLAYED...");
                }
            }
        }
    }

    public void replaceView(Key viewControllerId, Pane parent, AnimationConfiguration.AnimationEnumType addedNodeAnimationType, AnimationConfiguration.AnimationEnumType removedNodeAnimationType) {
        if (parent == null) {
            this.logger.error("ViewControllerManager::replaceView Provided null parent to attache layout handled by : " + String.valueOf(viewControllerId), new Exception());
            return;
        }
        if (viewControllerId == null) {
            this.logger.error("ViewControllerManager::replaceView Provided null viewControllerId to attache layout handled by : " + String.valueOf(viewControllerId), new Exception());
            return;
        }
        this.logger.debug("ViewControllerManager::replaceView controller id : " + String.valueOf(viewControllerId) + "\nParent id : " + parent.getId());
        if (this.preparedControllerKey != null && this.currentViewControllerKey != null) {
            this.logger.debug("ViewControllerManager::replaceView Animation in progress, schedule new one for viewControllerId : " + String.valueOf(viewControllerId));
            InternalReplaceArgsStruct internalReplaceArgsStruct1 = new InternalReplaceArgsStruct(this, viewControllerId, addedNodeAnimationType, removedNodeAnimationType);
            this.fragmentParentIdPerLastAnimatedReplaceData.put(parent.getId(), internalReplaceArgsStruct1);
            return;
        }
        if (viewControllerId.equals(this.currentViewControllerKey)) {
            this.logger.debug("ViewControllerManager::replaceView Request same controller id viewControllerId : " + String.valueOf(viewControllerId) + " Nothing to do...");
            return;
        }
        this.prepareViewController(viewControllerId);
        if (this.preparedControllerKey == null) {
            return;
        }
        ArrayList<Animation> animationsToAssemble = new ArrayList<Animation>(2);
        this.buildAndAddAnimationIfNeeded(addedNodeAnimationType, parent, (Node)this.childrenViewControllersPerId.get(this.preparedControllerKey).getLayout(), animationsToAssemble);
        this.logger.debug("ViewControllerManager::replaceView animation built for prepared controller");
        if (this.currentViewControllerKey != null) {
            this.buildAndAddAnimationIfNeeded(removedNodeAnimationType, parent, (Node)this.childrenViewControllersPerId.get(this.currentViewControllerKey).getLayout(), animationsToAssemble);
            this.logger.debug("ViewControllerManager::replaceView animation built for current controller");
        }
        ViewControllerHelper.attachNodeToAnchorPane((Node)this.childrenViewControllersPerId.get(this.preparedControllerKey).getLayout(), parent);
        if (!animationsToAssemble.isEmpty()) {
            Animation parallelTransition = AnimationUtils.assembleAnimations(() -> this.defaultParallelTransitionCallback(parent), animationsToAssemble);
            this.logger.debug("ViewControllerManager::replaceView launching parallel transition \nAnimation count : " + animationsToAssemble.size());
            parallelTransition.play();
        } else {
            if (this.currentViewControllerKey != null) {
                this.detachChildView(this.currentViewControllerKey, parent, false);
            }
            this.currentViewControllerKey = this.preparedControllerKey;
            this.preparedControllerKey = null;
        }
    }

    public void detachChildView(Key childControllerId, Pane parent, boolean destroy) {
        if (parent == null) {
            this.logger.error("ViewControllerManager::detachChildView Can't detach view from null parent m8...");
            return;
        }
        this.logger.debug("ViewControllerManager::detachChildView parent id : " + parent.getId() + "\n child controller id : " + String.valueOf(childControllerId));
        BaseViewController child = this.childrenViewControllersPerId.get(childControllerId);
        ViewControllerHelper.detachNodeFromAnchorPane((Node)child.getLayout(), parent);
        if (destroy) {
            this.childrenViewControllersPerId.remove(childControllerId);
        }
    }

    public Key getCurrentViewController() {
        if (this.preparedControllerKey == null) {
            return this.currentViewControllerKey;
        }
        return this.preparedControllerKey;
    }

    public void clearViewControllers(Pane parent) {
        if (parent != null) {
            this.logger.debug("ViewControllerManager::clearViewControllers parent id : " + parent.getId());
            parent.getChildren().clear();
            this.currentViewControllerKey = null;
        }
    }

    private void defaultParallelTransitionCallback(Pane parent) {
        this.logger.debug("ViewControllerManager::defaultParallelTransitionCallback parent id : " + parent.getId());
        if (this.currentViewControllerKey != null) {
            this.detachChildView(this.currentViewControllerKey, parent, false);
        }
        this.currentViewControllerKey = this.preparedControllerKey;
        this.preparedControllerKey = null;
        InternalReplaceArgsStruct internalReplaceArgsStruct = this.fragmentParentIdPerLastAnimatedReplaceData.remove(parent.getId());
        if (internalReplaceArgsStruct != null) {
            this.replaceView(internalReplaceArgsStruct.viewControllerId, parent, internalReplaceArgsStruct.addedNodeAnimationType, internalReplaceArgsStruct.removedNodeAnimationType);
        }
    }

    private void buildAndAddAnimationIfNeeded(AnimationConfiguration.AnimationEnumType animationType, Pane parent, Node childLayout, List<Animation> animationsToAssemble) {
        this.logger.debug("ViewControllerManager::buildAndAddAnimationIfNeeded parent id : " + parent.getId());
        if (animationType != null) {
            AnimationConfiguration addedNodeAnimationConfiguration = new AnimationConfiguration(animationType, parent.getWidth(), childLayout, null);
            Animation animation = AnimationUtils.buildAnimation(addedNodeAnimationConfiguration);
            animationsToAssemble.add(animation);
        }
    }

    private void prepareViewController(Key viewControllerId) {
        if (viewControllerId == null) {
            this.logger.error("ViewControllerManager::prepareViewController Provided null child controller id ");
            return;
        }
        this.logger.debug("ViewControllerManager::prepareViewController controller id : " + String.valueOf(viewControllerId));
        switch (this.managementMode.ordinal()) {
            case 0: {
                BaseViewController preparedController = this.childrenViewControllersPerId.get(viewControllerId);
                if (preparedController == null) {
                    try {
                        Callable<BaseViewController> facto = this.childrenControllerFactoriesPerId.get(viewControllerId);
                        preparedController = facto != null ? facto.call() : null;
                    }
                    catch (Exception e) {
                        this.logger.error("NEVER DISPLAYED", e);
                    }
                }
                if (preparedController != null) {
                    this.childrenViewControllersPerId.put(viewControllerId, preparedController);
                    this.preparedControllerKey = viewControllerId;
                    break;
                }
                this.logger.error("ViewControllerManager::prepareViewController Can't prepare controller with id : " + String.valueOf(viewControllerId));
                break;
            }
            case 1: {
                this.preparedControllerKey = viewControllerId;
                break;
            }
            default: {
                this.logger.error("ViewControllerManager::prepareViewController Unknown management mode --> " + this.managementMode.name());
            }
        }
    }

    public BaseViewController getCurrentController() {
        Key key = this.preparedControllerKey != null ? this.preparedControllerKey : this.currentViewControllerKey;
        return key == null ? null : this.childrenViewControllersPerId.get(key);
    }

    public Map<Key, BaseViewController> getControllers() {
        return this.childrenViewControllersPerId;
    }

    public void prepareAllControllers() {
        if (this.childrenControllerFactoriesPerId == null) {
            return;
        }
        for (Map.Entry<Key, Callable<BaseViewController>> entry : this.childrenControllerFactoriesPerId.entrySet()) {
            Key key = entry.getKey();
            if (this.childrenViewControllersPerId.containsKey(key)) continue;
            try {
                BaseViewController ctrl = entry.getValue().call();
                if (ctrl == null) continue;
                this.childrenViewControllersPerId.put(key, ctrl);
            }
            catch (Exception exception) {}
        }
    }

    public static enum ManagementMode {
        LAZY,
        EAGER;

    }

    private final class InternalReplaceArgsStruct {
        Key viewControllerId;
        AnimationConfiguration.AnimationEnumType addedNodeAnimationType;
        AnimationConfiguration.AnimationEnumType removedNodeAnimationType;

        public InternalReplaceArgsStruct(ViewControllerManager viewControllerManager, Key viewControllerId, AnimationConfiguration.AnimationEnumType addedNodeAnimationType, AnimationConfiguration.AnimationEnumType removedNodeAnimationType) {
            this.viewControllerId = viewControllerId;
            this.addedNodeAnimationType = addedNodeAnimationType;
            this.removedNodeAnimationType = removedNodeAnimationType;
        }
    }
}

