/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.view_controller;

import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerLifeCycle;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.layout.Region;

public abstract class BaseViewController
implements ViewControllerLifeCycle {
    private final ChangeListener<Scene> sceneChangeListener = new SceneChangeListener();
    protected final AppLogger logger = new AppLogger(this.getClass());

    public abstract Region getLayout();

    protected void loadFxml() {
        String fxmlPathFromAnnotation = this.getFxmlPathFromAnnotation();
        ViewControllerHelper.loadNodeWithExplicitController(this, fxmlPathFromAnnotation);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.bindLifecycle();
    }

    @Override
    public void bindLifecycle() {
        this.getLayout().sceneProperty().addListener(this.sceneChangeListener);
    }

    private String getFxmlPathFromAnnotation() {
        if (this.getClass().isAnnotationPresent(FXMLView.class)) {
            return this.getClass().getAnnotation(FXMLView.class).path();
        }
        this.logger.warning("Can't find annotation to get associated fxml path....class in fault : " + this.getClass().getSimpleName());
        return null;
    }

    @Override
    public void destroy() {
        this.getLayout().sceneProperty().removeListener(this.sceneChangeListener);
    }

    class SceneChangeListener
    implements ChangeListener<Scene> {
        SceneChangeListener() {
        }

        public void changed(ObservableValue<? extends Scene> observable, Scene oldScene, Scene newScene) {
            if (newScene == null) {
                BaseViewController.this.onLayoutDetached();
            } else {
                BaseViewController.this.onLayoutAttached();
            }
        }
    }
}

