/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.view_controller;

import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerLifeCycle;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ContextMenu;

public abstract class BaseContextMenuController
implements ViewControllerLifeCycle {
    private final ChangeListener<Boolean> showingPropertyListener = new ShowingChangeListener();
    protected final AppLogger logger = new AppLogger(this.getClass());

    protected abstract ContextMenu getContextMenu();

    @Override
    public void initialize(URL location, ResourceBundle resources) {
    }

    @Override
    public void bindLifecycle() {
        this.getContextMenu().showingProperty().addListener(this.showingPropertyListener);
    }

    @Override
    public void destroy() {
        this.getContextMenu().showingProperty().removeListener(this.showingPropertyListener);
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    class ShowingChangeListener
    implements ChangeListener<Boolean> {
        ShowingChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                BaseContextMenuController.this.onLayoutAttached();
            } else {
                BaseContextMenuController.this.onLayoutDetached();
            }
        }
    }
}

