/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.utils;

import io.olvid.windows.messenger.fx.framework.utils.SVGBuilder;
import io.olvid.windows.messenger.fx.framework.utils.SVGPathBuilder;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.transform.Rotate;

public final class FxIcons {
    private FxIcons() {
    }

    public static Node icon(IconDef def, double targetHeight, double viewBoxHeight) {
        SVGBuilder builder = new SVGBuilder(targetHeight, viewBoxHeight);
        if (def == null) {
            return builder.build();
        }
        def.layers().forEach(builder::addSVGPath);
        Node n = builder.build();
        n.setMouseTransparent(true);
        n.getStyleClass().add((Object)"fx-icon");
        return n;
    }

    public static Node icon(IconDef def, double targetHeight, double viewBoxHeight, double targetWidth, double viewBoxWidth) {
        SVGBuilder builder = new SVGBuilder(targetHeight, viewBoxHeight, targetWidth, viewBoxWidth);
        if (def == null) {
            return builder.build();
        }
        def.layers().forEach(builder::addSVGPath);
        Node n = builder.build();
        n.setMouseTransparent(true);
        n.getStyleClass().add((Object)"fx-icon");
        return n;
    }

    public static IconDef MONITOR(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M9.33301 23.625H18.2219").setStroke(stroke).setStrokeWidth(2.22222).build();
        SVGPath p2 = new SVGPathBuilder("M13.7773 19.1248V23.6248").setStroke(stroke).setStrokeWidth(2.22222).build();
        SVGPath p3 = new SVGPathBuilder("M22.2662 19.125H4.88921C3.66191 19.125 2.66699 18.1176 2.66699 16.875V5.625C2.66699 4.38236 3.66191 3.375 4.88921 3.375H22.667C23.8943 3.375 24.8892 4.38236 24.8892 5.625V9.7071").setStroke(stroke).setStrokeWidth(2.22222).build();
        SVGPath p4 = new SVGPathBuilder("M21.7773 11.6833C21.7773 11.1458 21.9304 10.6228 22.2218 10.2122C22.5122 9.80303 22.9903 9.45015 23.6057 9.45015H28.4256C29.0408 9.45025 29.5183 9.80315 29.8087 10.2122C30.1001 10.6228 30.254 11.1457 30.254 11.6833V22.5469C30.254 23.0844 30.1001 23.6074 29.8087 24.018C29.5183 24.427 29.0408 24.7799 28.4256 24.78H23.6057C22.9903 24.78 22.5122 24.4271 22.2218 24.018C21.9304 23.6074 21.7773 23.0844 21.7773 22.5469V11.6833Z M23.5062 22.5469C23.5062 22.759 23.5685 22.915 23.6258 22.996C23.6373 23.0122 23.6485 23.0222 23.6555 23.0296H28.3741C28.3812 23.0222 28.3927 23.0127 28.4046 22.996C28.4621 22.9151 28.5251 22.7592 28.5251 22.5469V11.6833C28.5251 11.471 28.4621 11.3151 28.4046 11.2342C28.3927 11.2174 28.3812 11.208 28.3741 11.2006H23.6555C23.6485 11.208 23.6373 11.218 23.6258 11.2342C23.5685 11.3152 23.5062 11.4712 23.5062 11.6833V22.5469Z").setFill(fill).build();
        return new IconDef(List.of(p1, p2, p3, p4));
    }

    public static IconDef TRASH(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M14 5V4.2C14 3.0799 14 2.51984 13.782 2.09202C13.5903 1.71569 13.2843 1.40973 12.908 1.21799C12.4802 1 11.9201 1 10.8 1H9.2C8.07989 1 7.51984 1 7.09202 1.21799C6.71569 1.40973 6.40973 1.71569 6.21799 2.09202C6 2.51984 6 3.0799 6 4.2V5M8 10.5V15.5M12 10.5V15.5M1 5H19M17 5V16.2C17 17.8802 17 18.7202 16.673 19.362C16.3854 19.9265 15.9265 20.3854 15.362 20.673C14.7202 21 13.8802 21 12.2 21H7.8C6.11984 21 5.27976 21 4.63803 20.673C4.07354 20.3854 3.6146 19.9265 3.32698 19.362C3 18.7202 3 17.8802 3 16.2V5").setStroke(stroke).setStrokeWidth(2.0).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef PLAY_CIRCLE(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M10.0003 18.3334C14.6027 18.3334 18.3337 14.6025 18.3337 10.0001C18.3337 5.39771 14.6027 1.66675 10.0003 1.66675C5.39795 1.66675 1.66699 5.39771 1.66699 10.0001C1.66699 14.6025 5.39795 18.3334 10.0003 18.3334Z").setStroke(stroke).setStrokeWidth(1.5).build();
        SVGPath p2 = new SVGPathBuilder("M8.33301 6.66675L13.333 10.0001L8.33301 13.3334V6.66675Z").setStroke(stroke).setStrokeWidth(1.5).build();
        return new IconDef(List.of(p1, p2));
    }

    public static IconDef STAR(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M10.0003 1.66675L12.5753 6.88341L18.3337 7.72508L14.167 11.7834L15.1503 17.5167L10.0003 14.8084L4.85033 17.5167L5.83366 11.7834L1.66699 7.72508L7.42533 6.88341L10.0003 1.66675Z").setStroke(stroke).setStrokeWidth(1.5).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef CHEVRON_DOWN(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M5 7.5L10 12.5L15 7.5").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef CHEVRON(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M7.5 15L12.5 10L7.5 5").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef SHIELD(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M5.55994 0.404617C5.8216 0.311818 6.11387 0.30961 6.38025 0.399734L10.8051 1.88411C11.3004 2.0495 11.6354 2.50505 11.6381 3.01497L11.6664 7.44173C11.6751 8.78365 11.1862 10.085 10.2904 11.1048C9.87831 11.5729 9.34969 11.9757 8.67517 12.3353L6.29626 13.6068C6.22196 13.6458 6.14029 13.6656 6.05798 13.6663C5.97543 13.667 5.89255 13.6473 5.81873 13.6087L3.41833 12.3665C2.73651 12.0129 2.20358 11.6171 1.78748 11.1556C0.876713 10.1462 0.370419 8.85026 0.361694 7.50618L0.333374 3.08235C0.330814 2.5719 0.660172 2.11363 1.15271 1.94173L5.55994 0.404617ZM8.49646 5.14583C8.29847 4.95561 7.97985 4.95689 7.78455 5.14973L5.53845 7.3636L4.61951 6.47981C4.42162 6.28968 4.1036 6.29117 3.90759 6.48372C3.71232 6.67653 3.71362 6.98683 3.9115 7.17708L5.18884 8.40559C5.28817 8.50104 5.4174 8.5485 5.54626 8.5472C5.67492 8.54652 5.80284 8.49815 5.90076 8.40169L8.50037 5.83919C8.69567 5.64634 8.69378 5.33607 8.49646 5.14583Z").setStroke(stroke).setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef SHIELD_BACKGROUND(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M8.06772 16C7.9706 16.0008 7.87348 15.9772 7.78662 15.9309L4.96222 14.4404C4.15999 14.016 3.53305 13.5406 3.0435 12.9868C1.97201 11.7755 1.37665 10.2207 1.36639 8.60778L1.33322 3.29917C1.33007 2.68649 1.71697 2.13657 2.29654 1.93025L7.48263 0.0851428C7.79057 -0.0262539 8.13405 -0.0286074 8.44752 0.0796514L13.6533 1.86121C14.2361 2.05969 14.6301 2.60569 14.6332 3.21759L14.6664 8.53011C14.6767 10.1407 14.1011 11.7026 13.0469 12.9264C12.5621 13.488 11.9407 13.9705 11.1472 14.402L8.34882 15.9278C8.26117 15.9749 8.16484 15.9992 8.06772 16").setStroke(stroke).setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef CLOSE(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M18.3337 5.83325L5.83366 18.3333M5.83366 5.83325L18.3337 18.3333").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef CHECK(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M5 10L8.33333 13.3333L15 6.66667").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef CANCEL(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M6.66699 6.66675L13.3337 13.3334M13.3337 6.66675L6.66699 13.3334").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef BAN(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M10 1.66675C5.39772 1.66675 1.66699 5.39748 1.66699 10.0001C1.66699 14.6024 5.39772 18.3334 10 18.3334C14.6023 18.3334 18.3337 14.6024 18.3337 10.0001C18.3337 5.39748 14.6023 1.66675 10 1.66675ZM14.1663 14.1667L5.83301 5.83341").setStroke(stroke).setStrokeWidth(1.5).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef ZAP(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M9.08333 0.75L0.75 10.75H8.25L7.41667 17.4167L15.75 7.41667H8.25L9.08333 0.75Z").setStroke(stroke).setStrokeWidth(1.5).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef EYE(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M0.833008 10.0002C0.833008 10.0002 4.16634 3.3335 9.99967 3.3335C15.833 3.3335 19.1663 10.0002 19.1663 10.0002C19.1663 10.0002 15.833 16.6668 9.99967 16.6668C4.16634 16.6668 0.833008 10.0002 0.833008 10.0002Z").setStroke(stroke).setStrokeWidth(1.5).build();
        SVGPath p2 = new SVGPathBuilder("M10 12.5C11.3807 12.5 12.5 11.3807 12.5 10C12.5 8.61929 11.3807 7.5 10 7.5C8.61929 7.5 7.5 8.61929 7.5 10C7.5 11.3807 8.61929 12.5 10 12.5Z").setStroke(stroke).setStrokeWidth(1.5).build();
        return new IconDef(List.of(p1, p2));
    }

    public static IconDef FRAME3(Paint stroke, Paint fill) {
        SVGPath outer = new SVGPathBuilder("M10 18.333C14.1421 18.333 17.5 14.9751 17.5 10.833C17.5 6.69087 14.1421 3.33301 10 3.33301C5.85786 3.33301 2.5 6.69087 2.5 10.833C2.5 14.9751 5.85786 18.333 10 18.333Z").setStroke(stroke).setStrokeWidth(1.66667).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        SVGPath inner = new SVGPathBuilder("M8.74967 10.8332 A 1.25 1.25 0 1 0 11.24967 10.8332 A 1.25 1.25 0 1 0 8.74967 10.8332 Z").setStroke(stroke).setStrokeWidth(0.833333).build();
        SVGPath rect45 = new SVGPathBuilder(FxIcons.roundedRectPath(12.9668, 7.77363, 0.416667, 2.9022, 0.208333)).setFill(fill).setStroke(stroke).setStrokeWidth(0.416667).build();
        rect45.getTransforms().add((Object)new Rotate(45.0, 12.9668, 7.77363));
        SVGPath topBar = new SVGPathBuilder(FxIcons.roundedRectPath(7.5, 2.08301, 1.66667, 5.0, 0.833333)).setFill(fill).build();
        topBar.getTransforms().add((Object)new Rotate(-90.0, 7.5, 2.08301));
        SVGPath topRect = new SVGPathBuilder("M9.16699 1.6665 H10.83366 V4.1665 H9.16699 Z").setFill(fill).build();
        SVGPath lug = new SVGPathBuilder("M14.6914 3.14762C14.981 2.78995 15.5058 2.7348 15.8634 3.02443L17.1587 4.0733C17.5164 4.36294 17.5715 4.88768 17.2819 5.24536L16.5276 6.17685L13.9371 4.07912L14.6914 3.14762Z").setFill(fill).build();
        return new IconDef(List.of(outer, inner, rect45, topBar, topRect, lug));
    }

    public static IconDef FLAME(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M7.26809 0C7.77368 0.349116 8.25615 0.632453 8.6924 0.981569C10.1629 2.1377 11.1047 3.59821 11.3349 5.4297C11.4726 6.62883 11.3118 7.78492 10.8986 8.91827C10.5538 9.83406 10.9448 10.7718 11.8404 11.1429C12.4837 11.4043 13.1039 11.3174 13.6557 10.9245C14.2075 10.5104 14.4367 9.94291 14.3221 9.26745C14.3221 9.2236 14.299 9.15867 14.299 9.09289C14.3452 9.11482 14.3683 9.11482 14.3683 9.13674C15.3564 10.6631 15.9997 12.2983 15.9997 14.1306C16.0228 16.5508 14.8508 18.4043 12.8516 19.8438C12.2776 20.2578 11.6565 20.5631 10.9679 20.8034C11.9559 19.9315 12.4153 18.9061 12.2083 17.6419C12.0474 16.6393 11.4734 15.8542 10.7146 15.1999C10.6453 15.5052 10.6231 15.8324 10.4845 16.1157C10.0482 16.9657 8.87627 17.1403 8.14049 16.5078C7.03781 15.5482 6.69307 14.327 6.80769 12.9534C6.92319 11.6666 8.16358 9.13672 8.16358 9.04994C7.93345 9.11571 1.33964 13.6507 4.3954 19.5605C4.67084 20.1053 5.08489 20.5851 5.56737 21C5.38344 20.9342 5.22262 20.8912 5.03869 20.8254C3.29272 20.193 1.84532 19.1904 0.880414 17.6421C0.0762814 16.3553 -0.107646 14.9596 0.0531939 13.4992C0.351741 10.9914 1.54682 8.92029 3.38441 7.13175C4.6248 5.93262 5.70523 4.62391 6.53252 3.14149C6.90038 2.46519 7.19892 1.7678 7.26735 1.00465C7.29134 0.698542 7.26823 0.393292 7.26823 0.000332438L7.26809 0Z").setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef PLUS(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M10 1.66675V18.3334M1.66699 10.0001H18.3337").setStroke(stroke).setStrokeWidth(1.5).setStrokeLineCap(StrokeLineCap.ROUND).setStrokeLineJoin(StrokeLineJoin.ROUND).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef NEWCONTACT(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M26.7031 27.6855C24.6133 27.6855 22.7969 25.8105 22.7969 23.3691C22.7969 20.957 24.6133 19.1699 26.7031 19.1699C28.793 19.1699 30.6094 20.9961 30.6094 23.3887C30.6094 25.8105 28.8027 27.6855 26.7031 27.6855ZM26.7129 29.4336C28.373 29.4336 29.8281 29.8242 31.0195 30.4199C29.6133 31.582 28.7148 33.3203 28.7148 35.2832C28.7148 35.7715 28.7637 36.2695 28.8906 36.7285H20.5801C19.0371 36.7285 18.4902 36.2891 18.4902 35.4297C18.4902 32.9102 21.6445 29.4336 26.7129 29.4336ZM35.0234 40.2441C32.2988 40.2441 30.0527 38.0078 30.0527 35.2832C30.0527 32.5586 32.2988 30.3223 35.0234 30.3223C37.7383 30.3223 39.9844 32.5586 39.9844 35.2832C39.9844 37.9883 37.709 40.2441 35.0234 40.2441ZM35.0234 38.3887C35.3848 38.3887 35.6191 38.1445 35.6191 37.793V35.8789H37.5234C37.8848 35.8789 38.1191 35.6445 38.1191 35.2832C38.1191 34.9121 37.8848 34.6777 37.5234 34.6777H35.6191V32.7734C35.6191 32.4219 35.3848 32.1777 35.0234 32.1777C34.6523 32.1777 34.418 32.4219 34.418 32.7734V34.6777H32.5137C32.1523 34.6777 31.9082 34.9121 31.9082 35.2832C31.9082 35.6445 32.1523 35.8789 32.5137 35.8789H34.418V37.793C34.418 38.1445 34.6523 38.3887 35.0234 38.3887Z").setStroke(stroke).setStrokeWidth(0.5).setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef GROUP_V2(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M32.8984 27.6855C30.7988 27.6855 28.9922 25.8105 28.9922 23.3887C28.9922 20.9961 30.8086 19.1699 32.8984 19.1699C34.9785 19.1699 36.7949 20.957 36.7949 23.3691C36.7949 25.8105 34.9883 27.6855 32.8984 27.6855ZM21.6484 27.9102C19.832 27.9102 18.25 26.2695 18.25 24.1699C18.25 22.0801 19.8418 20.498 21.6484 20.498C23.4648 20.498 25.0469 22.041 25.0469 24.1504C25.0469 26.2695 23.4746 27.9102 21.6484 27.9102ZM16.209 36.7285C14.9688 36.7285 14.4902 36.2402 14.4902 35.3516C14.4902 32.6562 17.2441 29.4043 21.6484 29.4043C23.4648 29.4043 24.8613 29.9414 25.9551 30.6641C23.8457 32.2852 22.6055 35.2539 23.6211 36.7285H16.209ZM26.7559 36.7285C25.2227 36.7285 24.6758 36.2891 24.6758 35.4297C24.6758 32.9102 27.8301 29.4336 32.8887 29.4336C37.957 29.4336 41.1113 32.9102 41.1113 35.4297C41.1113 36.2891 40.5645 36.7285 39.0215 36.7285H26.7559Z").setStroke(stroke).setStrokeWidth(0.5).setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef SMILEY(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M2.41669 10C2.41669 5.81184 5.81186 2.41667 10 2.41667C14.1882 2.41667 17.5834 5.81184 17.5834 10C17.5834 14.1882 14.1882 17.5833 10 17.5833C5.81186 17.5833 2.41669 14.1882 2.41669 10ZM10 0.916666C4.98343 0.916666 0.916687 4.98341 0.916687 10C0.916687 15.0166 4.98343 19.0833 10 19.0833C15.0166 19.0833 19.0834 15.0166 19.0834 10C19.0834 4.98341 15.0166 0.916666 10 0.916666ZM6.21669 11.0667C6.54714 10.8188 7.01555 10.8849 7.26461 11.2139L7.26474 11.2141L7.26927 11.2199C7.2747 11.2267 7.28463 11.2391 7.29895 11.2561C7.32764 11.2903 7.37363 11.343 7.43604 11.4082C7.56149 11.5391 7.74963 11.7163 7.99323 11.8934C8.48332 12.2499 9.165 12.5833 10 12.5833C10.835 12.5833 11.5167 12.2499 12.0068 11.8934C12.2504 11.7163 12.4385 11.5391 12.564 11.4082C12.6264 11.343 12.6724 11.2903 12.7011 11.2561C12.7154 11.2391 12.7253 11.2267 12.7308 11.2199L12.7336 11.2162H12.7337L12.734 11.2158L12.7345 11.2151L12.7353 11.2141L12.7336 11.2162L7.26461 11.2139L12.7354 11.2139C12.9845 10.8849 13.4529 10.8188 13.7834 11.0667C14.1147 11.3152 14.1819 11.7853 13.9334 12.1167L13.3334 11.6667C13.9334 12.1167 13.9332 12.1169 13.933 12.1172L13.9326 12.1177L13.9317 12.1189L13.9296 12.1217L13.9239 12.1291L13.9068 12.1509C13.8929 12.1685 13.874 12.1919 13.8501 12.2204C13.8022 12.2774 13.7343 12.3549 13.647 12.446C13.4729 12.6276 13.2184 12.867 12.8891 13.1066C12.2333 13.5835 11.2483 14.0833 10 14.0833C8.75171 14.0833 7.76672 13.5835 7.11097 13.1066C6.78166 12.867 6.52709 12.6276 6.35306 12.446C6.26574 12.3549 6.19779 12.2774 6.14999 12.2204C6.12606 12.1919 6.1071 12.1685 6.0932 12.1509L6.07614 12.1291L6.07046 12.1217L6.06833 12.1189L6.06745 12.1177L6.06705 12.1172C6.06687 12.1169 6.06669 12.1167 6.66669 11.6667L6.06669 12.1167C5.81816 11.7853 5.88532 11.3152 6.21669 11.0667ZM11.5 7.5C11.5 6.94771 11.9477 6.5 12.5 6.5H12.5084C13.0606 6.5 13.5084 6.94771 13.5084 7.5C13.5084 8.05228 13.0606 8.5 12.5084 8.5H12.5C11.9477 8.5 11.5 8.05228 11.5 7.5ZM7.50002 6.5C6.94774 6.5 6.50002 6.94771 6.50002 7.5C6.50002 8.05228 6.94774 8.5 7.50002 8.5H7.50835C8.06064 8.5 8.50835 8.05228 8.50835 7.5C8.50835 6.94771 8.06064 6.5 7.50835 6.5H7.50002Z").setFill(fill).build();
        return new IconDef(List.of(p1));
    }

    public static IconDef AVG_PACE(Paint stroke, Paint fill) {
        SVGPath p1 = new SVGPathBuilder("M574.5-774.5Q560-789 560-810t14.5-35.5Q589-860 610-860t35.5 14.5Q660-831 660-810t-14.5 35.5Q631-760 610-760t-35.5-14.5Zm0 660Q560-129 560-150t14.5-35.5Q589-200 610-200t35.5 14.5Q660-171 660-150t-14.5 35.5Q631-100 610-100t-35.5-14.5Zm160-520Q720-649 720-670t14.5-35.5Q749-720 770-720t35.5 14.5Q820-691 820-670t-14.5 35.5Q791-620 770-620t-35.5-14.5Zm0 380Q720-269 720-290t14.5-35.5Q749-340 770-340t35.5 14.5Q820-311 820-290t-14.5 35.5Q791-240 770-240t-35.5-14.5Zm60-190Q780-459 780-480t14.5-35.5Q809-530 830-530t35.5 14.5Q880-501 880-480t-14.5 35.5Q851-430 830-430t-35.5-14.5ZM480-80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880v80q-134 0-227 93t-93 227q0 134 93 227t227 93v80Zm-56.5-343.5Q400-447 400-480q0-5 .5-10.5T403-501l-83-83 56-56 83 83q4-1 21-3 33 0 56.5 23.5T560-480q0 33-23.5 56.5T480-400q-33 0-56.5-23.5Z").setFill(fill).build();
        p1.setScaleX(0.025);
        p1.setScaleY(0.025);
        return new IconDef(List.of(p1));
    }

    private static String roundedRectPath(double x, double y, double w, double h, double r) {
        double rr = Math.min(r, Math.min(w, h) / 2.0);
        double x2 = x + w;
        double y2 = y + h;
        double xr = x + rr;
        double yr = y + rr;
        double x2r = x2 - rr;
        double y2r = y2 - rr;
        return "M" + xr + " " + y + " H" + x2r + " A " + rr + " " + rr + " 0 0 1 " + x2 + " " + yr + " V" + y2r + " A " + rr + " " + rr + " 0 0 1 " + x2r + " " + y2 + " H" + xr + " A " + rr + " " + rr + " 0 0 1 " + x + " " + y2r + " V" + yr + " A " + rr + " " + rr + " 0 0 1 " + xr + " " + y + " Z";
    }

    public record IconDef(List<SVGPath> layers) {
    }
}

