/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.lib;

import io.olvid.windows.messenger.logger.AppLogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.WeakListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class OlvidBindings {
    public static final String OLVID_CLASS_BINDINGS = "OLVID_CLASS_BINDINGS_PROPERTY";

    public static StaticListBindings<String> bindClass(Node node) {
        StaticListBindings<String> classBindings = new StaticListBindings<String>(node.getStyleClass());
        node.getProperties().put((Object)OLVID_CLASS_BINDINGS, classBindings);
        return classBindings;
    }

    public static <Target, Source> void bindMappedContent(List<Target> targets, ObservableList<Source> sources, Function<Source, Target> mapper) {
        ListMappedContentBinding<Target, Source> contentBinding = new ListMappedContentBinding<Target, Source>(targets, mapper);
        if (targets instanceof ObservableList) {
            ObservableList oTargets = (ObservableList)targets;
            oTargets.setAll(sources.stream().map(mapper).toList());
        } else {
            targets.clear();
            targets.addAll(sources.stream().map(mapper).toList());
        }
        sources.removeListener(contentBinding);
        sources.addListener(contentBinding);
    }

    public static <Target, Source> void unbindMappedContent(List<Target> targets, ObservableList<Source> sources) {
        ListMappedContentBinding<Object, Object> contentBinding = new ListMappedContentBinding<Object, Object>(targets, s -> null);
        sources.removeListener(contentBinding);
    }

    public static class StaticListBindings<Type> {
        private final ObservableList<Type> list;
        private final List<Object> bindObject = new ArrayList<Object>();
        private final Map<ChangeListener<Type>, ObservableValue<Type>> listeners = new HashMap<ChangeListener<Type>, ObservableValue<Type>>();

        public StaticListBindings(ObservableList<Type> list) {
            this.list = list;
        }

        public StaticListBindings<Type> to(Type type) {
            this.list.add(type);
            return this;
        }

        public StaticListBindings<Type> to(ObservableValue<Type> typeBinding) {
            int index = this.list.size();
            this.list.add(typeBinding.getValue());
            this.bindObject.add(typeBinding);
            ChangeListener typeChangeListener = (observable, oldValue, newValue) -> {
                if (this.list.get(index) == oldValue) {
                    this.list.set(index, newValue);
                } else {
                    AppLogger.e("The bind list has change externally. This is not supported.");
                }
            };
            this.listeners.put(typeChangeListener, typeBinding);
            typeBinding.addListener(typeChangeListener);
            return this;
        }

        public void unbind() {
            for (Map.Entry<ChangeListener<Type>, ObservableValue<Type>> entry : this.listeners.entrySet()) {
                entry.getValue().removeListener(entry.getKey());
            }
            this.listeners.clear();
            this.bindObject.clear();
        }
    }

    private static class ListMappedContentBinding<Target, Source>
    implements ListChangeListener<Source>,
    WeakListener {
        private final WeakReference<List<Target>> targets;
        private final Function<Source, Target> mapper;

        public ListMappedContentBinding(List<Target> list, Function<Source, Target> mapper) {
            this.targets = new WeakReference<List<Target>>(list);
            this.mapper = mapper;
        }

        public void onChanged(ListChangeListener.Change<? extends Source> change) {
            List list = (List)this.targets.get();
            if (list == null) {
                change.getList().removeListener((ListChangeListener)this);
            } else {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        list.subList(change.getFrom(), change.getTo()).clear();
                        list.addAll(change.getFrom(), change.getList().subList(change.getFrom(), change.getTo()).stream().map(this.mapper).toList());
                        continue;
                    }
                    if (change.wasRemoved()) {
                        try {
                            list.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                        }
                        catch (Exception e) {
                            AppLogger.e("Exception in ListMappedContentBinding.onChanged: ", e);
                        }
                    }
                    if (!change.wasAdded()) continue;
                    list.addAll(change.getFrom(), change.getAddedSubList().stream().map(this.mapper).toList());
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.targets.get() == null;
        }

        public int hashCode() {
            List list = (List)this.targets.get();
            return list == null ? 0 : list.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            List list1 = (List)this.targets.get();
            if (list1 == null) {
                return false;
            }
            if (obj instanceof ListMappedContentBinding) {
                ListMappedContentBinding castedObj = (ListMappedContentBinding)obj;
                List list2 = (List)castedObj.targets.get();
                return list1 == list2;
            }
            return false;
        }
    }
}

