/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.animation;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class AnimationUtils {
    public static final double DEFAULT_ANIMATION_TIME_MS = 200.0;
    public static final Duration FADE_ANIMATION_DURATION = Duration.millis((double)125.0);

    public static Animation buildAnimation(AnimationConfiguration animationConfiguration) {
        switch (animationConfiguration.animationType) {
            case SLIDE_IN_FROM_LEFT: {
                return AnimationUtils.buildSlideInFromLeftAnimation(animationConfiguration);
            }
            case SLIDE_IN_FROM_RIGHT: {
                return AnimationUtils.buildSlideInFromRightAnimation(animationConfiguration);
            }
            case SLIDE_OUT_TO_LEFT: {
                return AnimationUtils.buildSlideOutToLeftAnimation(animationConfiguration);
            }
            case SLIDE_OUT_TO_RIGHT: {
                return AnimationUtils.buildSlideOutToRightAnimation(animationConfiguration);
            }
            case FADE_IN: {
                return AnimationUtils.buildFadeInTransition(animationConfiguration);
            }
            case FADE_OUT: {
                return AnimationUtils.buildFadeOutTransition(animationConfiguration);
            }
            case EXPAND_IN: {
                return AnimationUtils.buildExpandInAnimation(animationConfiguration);
            }
            case COLLAPSE_OUT: {
                return AnimationUtils.buildCollapseOutAnimation(animationConfiguration);
            }
        }
        return null;
    }

    private static Animation buildFadeOutTransition(AnimationConfiguration animationConfiguration) {
        return AnimationUtils.buildFadeTransition(animationConfiguration, 1.0, 0.0);
    }

    private static Animation buildFadeInTransition(AnimationConfiguration animationConfiguration) {
        return AnimationUtils.buildFadeTransition(animationConfiguration, 0.0, 1.0);
    }

    private static FadeTransition buildFadeTransition(AnimationConfiguration animationConfiguration, double from, double to) {
        if (animationConfiguration.targetNode == null) {
            AppLogger.e("AnimationUtils::buildTranslateXAnimation Can't set animation on null Node m8....returning null");
            return null;
        }
        FadeTransition fadeIn = new FadeTransition(FADE_ANIMATION_DURATION);
        fadeIn.setFromValue(from);
        fadeIn.setToValue(to);
        fadeIn.setNode(animationConfiguration.targetNode);
        if (animationConfiguration.onFinish != null) {
            fadeIn.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return fadeIn;
    }

    public static Animation assembleAnimations(Runnable onFinish, List<Animation> animations) {
        ParallelTransition parallelTransition = new ParallelTransition(animations.toArray(new Animation[0]));
        if (onFinish != null) {
            parallelTransition.setOnFinished(event -> onFinish.run());
        }
        return parallelTransition;
    }

    private static Animation buildSlideInFromLeftAnimation(AnimationConfiguration animationConfiguration) {
        if (animationConfiguration.targetNode == null) {
            AppLogger.e("AnimationUtils::buildTranslateXAnimation Can't set animation on null Node m8....returning null");
            return null;
        }
        animationConfiguration.targetNode.setTranslateX(-animationConfiguration.range);
        KeyValue keyValue = new KeyValue((WritableValue)animationConfiguration.targetNode.translateXProperty(), (Object)(animationConfiguration.targetNode.translateXProperty().getValue() + animationConfiguration.range));
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue});
        Timeline animation = new Timeline(new KeyFrame[]{keyFrame});
        if (animationConfiguration.onFinish != null) {
            animation.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return animation;
    }

    private static Animation buildSlideOutToRightAnimation(AnimationConfiguration animationConfiguration) {
        if (animationConfiguration.targetNode == null) {
            AppLogger.e("AnimationUtils::buildTranslateXAnimation Can't set animation on null Node m8....returning null");
            return null;
        }
        KeyValue keyValue = new KeyValue((WritableValue)animationConfiguration.targetNode.translateXProperty(), (Object)(animationConfiguration.targetNode.translateXProperty().getValue() + animationConfiguration.range));
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue});
        Timeline animation = new Timeline(new KeyFrame[]{keyFrame});
        if (animationConfiguration.onFinish != null) {
            animation.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return animation;
    }

    private static Animation buildSlideInFromRightAnimation(AnimationConfiguration animationConfiguration) {
        if (animationConfiguration.targetNode == null) {
            AppLogger.e("AnimationUtils::buildTranslateXAnimation Can't set animation on null Node m8....returning null");
            return null;
        }
        animationConfiguration.targetNode.setTranslateX(animationConfiguration.range);
        KeyValue keyValue = new KeyValue((WritableValue)animationConfiguration.targetNode.translateXProperty(), (Object)(animationConfiguration.targetNode.translateXProperty().getValue() - animationConfiguration.range));
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue});
        Timeline animation = new Timeline(new KeyFrame[]{keyFrame});
        if (animationConfiguration.onFinish != null) {
            animation.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return animation;
    }

    private static Animation buildSlideOutToLeftAnimation(AnimationConfiguration animationConfiguration) {
        if (animationConfiguration.targetNode == null) {
            AppLogger.e("AnimationUtils::buildTranslateXAnimation Can't set animation on null Node m8....returning null");
            return null;
        }
        KeyValue keyValue = new KeyValue((WritableValue)animationConfiguration.targetNode.translateXProperty(), (Object)(animationConfiguration.targetNode.translateXProperty().getValue() - animationConfiguration.range));
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue});
        Timeline animation = new Timeline(new KeyFrame[]{keyFrame});
        if (animationConfiguration.onFinish != null) {
            animation.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return animation;
    }

    public static ParallelTransition vanishOnVBox(Region toVanishNode, VBox box, int duration) {
        double height = toVanishNode.getHeight() + VBox.getMargin((Node)toVanishNode).getTop() + VBox.getMargin((Node)toVanishNode).getBottom() + box.getSpacing();
        ArrayList<Object> l = new ArrayList<Object>();
        for (Node n : box.getChildren().subList(box.getChildren().indexOf((Object)toVanishNode) + 1, box.getChildren().size())) {
            TranslateTransition t = new TranslateTransition(Duration.millis((double)duration), n);
            t.setToY(-height);
            t.setByY(0.0);
            l.add(t);
        }
        FadeTransition fade = new FadeTransition(Duration.millis((double)duration), (Node)toVanishNode);
        fade.setToValue(0.3);
        l.add(fade);
        ParallelTransition parallelTransition = new ParallelTransition(l.toArray(new Animation[0]));
        parallelTransition.setOnFinished(event -> {
            for (Node n : box.getChildren().subList(box.getChildren().indexOf((Object)toVanishNode) + 1, box.getChildren().size())) {
                n.setLayoutY(0.0);
                n.setLayoutX(0.0);
                n.setTranslateX(0.0);
                n.setTranslateY(0.0);
            }
            toVanishNode.setOpacity(1.0);
            toVanishNode.setVisible(false);
            toVanishNode.setManaged(false);
        });
        return parallelTransition;
    }

    private static Animation buildExpandInAnimation(AnimationConfiguration animationConfiguration) {
        if (!(animationConfiguration.targetNode instanceof Region)) {
            AppLogger.e("AnimationUtils::buildExpandInAnimation Node must be a Region");
            return null;
        }
        Region container = (Region)animationConfiguration.targetNode;
        double expandedHeight = container.prefHeight(-1.0);
        double hiddenOffset = -12.0;
        container.setMinHeight(0.0);
        container.setVisible(true);
        container.setManaged(true);
        container.setMaxHeight(0.0);
        container.setOpacity(0.0);
        container.setTranslateY(hiddenOffset);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)container.maxHeightProperty(), (Object)expandedHeight, Interpolator.EASE_BOTH), new KeyValue((WritableValue)container.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)container.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
        if (animationConfiguration.onFinish != null) {
            timeline.setOnFinished(event -> animationConfiguration.onFinish.run());
        }
        return timeline;
    }

    private static Animation buildCollapseOutAnimation(AnimationConfiguration animationConfiguration) {
        if (!(animationConfiguration.targetNode instanceof Region)) {
            AppLogger.e("AnimationUtils::buildCollapseOutAnimation Node must be a Region");
            return null;
        }
        Region container = (Region)animationConfiguration.targetNode;
        double hiddenOffset = -12.0;
        container.setMinHeight(0.0);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)container.maxHeightProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)container.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)container.translateYProperty(), (Object)hiddenOffset, Interpolator.EASE_BOTH)})});
        timeline.setOnFinished(event -> {
            container.setVisible(false);
            container.setManaged(false);
            container.setTranslateY(0.0);
            if (animationConfiguration.onFinish != null) {
                animationConfiguration.onFinish.run();
            }
        });
        return timeline;
    }

    public static class SizeTransition
    extends Transition {
        private final double fromValue;
        private final Rectangle rectangle;
        private final double delta;

        public SizeTransition(Duration duration, double fromValue, double toValue, Rectangle rectangle) {
            this.setCycleDuration(duration);
            this.fromValue = fromValue;
            this.rectangle = rectangle;
            this.delta = toValue - fromValue;
        }

        protected void interpolate(double frac) {
            this.rectangle.setWidth(this.fromValue + frac * this.delta);
        }
    }

    public static class BlurTransition
    extends Transition {
        private final double from;
        private final double to;
        protected GaussianBlur blur = new GaussianBlur(0.0);

        public BlurTransition(Duration duration, double from, double to) {
            this.setCycleDuration(duration);
            this.setInterpolator(Interpolator.EASE_OUT);
            this.from = from;
            this.to = to;
        }

        protected void interpolate(double frac) {
            this.blur.setRadius(this.from * (1.0 - frac) + frac * this.to);
        }

        public GaussianBlur getBlurEffect() {
            return this.blur;
        }
    }

    public static class PaneColorTransition
    extends Transition {
        private final SvgSizeable newButton;
        private final Color colorTo;
        private final Color colorFrom;

        public PaneColorTransition(SvgSizeable newButtonIcon, Color colorFrom, Color colorTo, double duration) {
            this.newButton = newButtonIcon;
            this.setCycleDuration(Duration.millis((double)duration));
            this.setInterpolator(Interpolator.EASE_BOTH);
            this.colorTo = colorTo;
            this.colorFrom = colorFrom;
        }

        protected void interpolate(double frac) {
            Color interpolateColor = new Color(this.colorTo.getRed() * frac + this.colorFrom.getRed() * (1.0 - frac), this.colorTo.getGreen() * frac + this.colorFrom.getGreen() * (1.0 - frac), this.colorTo.getBlue() * frac + this.colorFrom.getBlue() * (1.0 - frac), 1.0);
            this.newButton.setPaint((Paint)interpolateColor);
        }
    }
}

