/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class DiscussionTabModel {
    private final LiveData<List<Discussion>> discussionLiveData;
    private final LiveData<Boolean> hasUnreadMessagesLiveData;
    public final BooleanProperty autoIdentitySync = new SimpleBooleanProperty();
    public final BooleanProperty manualIdentitySync = new SimpleBooleanProperty();
    private final BooleanProperty unreadTagDisplayed = new SimpleBooleanProperty();

    DiscussionTabModel() {
        this.discussionLiveData = LiveDataFactory.switchMap(SelectedOwnedIdentitySingleton.getInstance().currentOwnedIdentityInfo, ownedIdentity -> ownedIdentity.map(ownedIdentityInfo -> LiveDataFactory.buildDbLiveDataList(Discussion.class, () -> DbManager.getInstance().getDiscussionDao().getVisibleDiscussionsAssociatedToIdentitySortedByLastMessageTimestamp(ownedIdentityInfo.genId()), List.of())).orElse(null));
        this.hasUnreadMessagesLiveData = LiveDataFactory.switchMap(SelectedOwnedIdentitySingleton.getInstance().currentOwnedIdentityId, ownedIdentity -> LiveDataFactory.map(UnreadMessageCountCache.getInstance().getUnreadCountLiveData(), false, info -> {
            if (ownedIdentity.isEmpty()) {
                return false;
            }
            return info.hasUnreadMessages((Id)ownedIdentity.get());
        }));
        SelectedOwnedIdentitySingleton.getInstance().addOwnedIdInitialSyncingListener(this::ownedIdentityInitialSyncingListener);
        SelectedOwnedIdentitySingleton.getInstance().addOwnedIdManualSyncingListener(this::ownedIdentityManualSyncingListener);
    }

    public LiveData<List<Discussion>> getDiscussionsLiveData() {
        return this.discussionLiveData;
    }

    public boolean isUnreadTagDisplayed() {
        return this.unreadTagDisplayed.get();
    }

    public BooleanProperty unreadTagDisplayedProperty() {
        return this.unreadTagDisplayed;
    }

    public void setUnreadTagDisplayed(boolean unreadTagDisplayed) {
        this.unreadTagDisplayed.set(unreadTagDisplayed);
    }

    public LiveData<Boolean> getHasUnreadMessagesLiveData() {
        return this.hasUnreadMessagesLiveData;
    }

    private void ownedIdentityInitialSyncingListener(Boolean newVal, Boolean oldVal) {
        boolean value = newVal != null && newVal != false;
        this.autoIdentitySync.set(value);
    }

    private void ownedIdentityManualSyncingListener(Boolean newVal, Boolean oldVal) {
        boolean value = newVal != null && newVal != false;
        this.manualIdentitySync.set(value);
    }
}

