/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.NewDiscussionModalController;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionListCell;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionTabModel;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.IdentitySyncingView;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FlowConstructor;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ScrollbarOverlayHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.BaseNavBarTab;
import io.olvid.windows.messenger.fx.modal.qrcode.QrCodeModalController;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.util.Callback;
import javafx.util.Duration;

public class DiscussionTabController
extends BaseNavBarTab {
    private final DiscussionTabModel model;
    private StandardPanelListController<DiscussionInfo> discussionTitleListViewController;
    private final IdentitySyncingView identitySyncingView = new IdentitySyncingView();
    private Button tabButton;
    private final SearchBarController searchBarController;
    private SvgSizeable iconButton;
    private LiveDataListener<Boolean> hasUnreadMessagesLiveDataListener;
    final RotateTransition rt;
    private final ListPanelSelectModel<DiscussionInfo> discussionSelectModel = new ListPanelSelectModel<DiscussionInfo>(this, Boolean.valueOf(false), true){

        @Override
        public void setListView(ListView<DiscussionInfo> listView) {
            super.setListView(listView);
            DiscussionSelectionModel.getInstance().getSelectedDiscussionInfoLiveData().addListener((newValue, oldValue) -> {
                if (newValue.isEmpty()) {
                    ViewControllerHelper.smartUIUpdate(this::clearSelection);
                    return;
                }
                Optional<DiscussionInfo> newSelectedDiscussion = listView.getItems().stream().filter(i -> i.id().equals(((DiscussionInfo)newValue.get()).id())).findAny();
                newSelectedDiscussion.ifPresent(this::selectItem);
            });
        }
    };

    private StringBinding getDiscussionTitleBinding() {
        return Bindings.createStringBinding(() -> {
            int count = this.discussionTitleListViewController.getListView().getItems().size();
            return ViewControllerHelper.getString("left.panel.discussion.title", Pair.of("count", count));
        }, (Observable[])new Observable[]{this.discussionTitleListViewController.getListView().getItems()});
    }

    public DiscussionTabController() {
        this.model = new DiscussionTabModel();
        LiveData discussionTitleList = MapLiveData.list(this.model.getDiscussionsLiveData(), AbstractTableGenerated::getItemId, DbCache.getInstance().discussionInfoMapLiveData, discussion -> DiscussionInfo.empty((Id<Discussion>)discussion.getItemId()));
        this.discussionTitleListViewController = StandardPanelListController.builder().withLiveData(discussionTitleList).withDataClass(DiscussionInfo.class).withCellFactory((Callback<ListView<DiscussionInfo>, AbstractListCell<DiscussionInfo>>)((Callback)param -> this.buildDiscussionTitleInfoCell())).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().setListSelectionModel(this.discussionSelectModel).withSingleSelection().withDisableUnselect(true).withoutButton(this::discussionTitleInfoSelectionListener).build();
        this.searchBarController = new SearchBarController();
        this.searchBarController.bindFilter(ListItemSearchHelper::discussionSearchPredicate, this.discussionTitleListViewController.getListModel().getFilteredList(), Optional.empty());
        ViewControllerHelper.smartUIUpdate(() -> {
            VBox.setMargin((Node)this.searchBarController.getLayout(), (Insets)new Insets(18.0, 10.0, 0.0, 10.0));
            VBox.setMargin(this.discussionTitleListViewController.getListView(), (Insets)new Insets(22.0, 0.0, 0.0, 0.0));
            this.discussionTitleListViewController.getListView().setFixedCellSize(70.0);
            this.discussionTitleListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
            ScrollbarOverlayHelper.setupOverlayScrollbar(this.discussionTitleListViewController.getListView());
        });
        super.buildStandardTab(Either.right(this.getDiscussionTitleBinding()), Optional.of(Bindings.concat((Object[])new Object[]{"(", this.getDiscussionNumber(), ")"})), Optional.of("svg-plus"), Optional.of(DiscussionTabController::displayNewDiscussionModal), Optional.of("icon-refresh"), Optional.of(this::getActionEventEventHandler), Optional.empty(), new Node[]{this.searchBarController.getLayout(), this.identitySyncingView, this.discussionTitleListViewController.getLayout()});
        this.rt = new RotateTransition(Duration.millis((double)1000.0), (Node)this.tabContainer.getParameterButton());
        this.rt.setByAngle(-360.0);
        this.rt.setCycleCount(1);
        this.rt.setInterpolator(Interpolator.LINEAR);
        this.rt.onFinishedProperty().set(actionEvent -> {
            if (this.model.manualIdentitySync.get()) {
                this.rt.play();
            } else {
                this.rt.stop();
            }
        });
        this.model.manualIdentitySync.addListener(this::replayAnimationIfNeeded);
        this.tabButton = this.createButtonUnread();
        this.identitySyncingView.managedProperty().bind((ObservableValue)this.identitySyncingView.visibleProperty());
        this.identitySyncingView.visibleProperty().bind((ObservableValue)this.model.autoIdentitySync);
        this.initUnread();
    }

    private void replayAnimationIfNeeded(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        boolean val;
        boolean bl = val = newValue != null && newValue != false;
        if (val && this.rt.getStatus().equals((Object)Animation.Status.STOPPED)) {
            this.rt.play();
        }
    }

    private void getActionEventEventHandler(ActionEvent event) {
        if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent()) {
            Api.getOwnedIdentityApi().downloadMessages(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
        }
    }

    private void initUnread() {
        this.hasUnreadMessagesLiveDataListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.model.setUnreadTagDisplayed(Objects.requireNonNullElse(newValue, false)));
        this.model.getHasUnreadMessagesLiveData().addListener(this.hasUnreadMessagesLiveDataListener);
    }

    public IntegerBinding getDiscussionNumber() {
        return Bindings.createIntegerBinding(() -> this.discussionTitleListViewController.getListView().getItems().size(), (Observable[])new Observable[]{this.discussionTitleListViewController.getListView().getItems()});
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public Region getLayout() {
        return this.tabContainer;
    }

    private void discussionTitleInfoSelectionListener(DiscussionInfo selectedDiscussion, Node node) {
        if (selectedDiscussion == null) {
            return;
        }
        NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, selectedDiscussion.id()));
    }

    @Override
    public Button getNavBarButton() {
        return this.tabButton;
    }

    @Override
    public SvgSizeable getNavBarButtonIcon() {
        return this.iconButton;
    }

    private AbstractListCell<DiscussionInfo> buildDiscussionTitleInfoCell() {
        DiscussionListCell<DiscussionInfo> discussionListCell = new DiscussionListCell<DiscussionInfo>(this){

            @Override
            Id<Discussion> getId(DiscussionInfo discussion) {
                return discussion.id();
            }
        };
        discussionListCell.prefWidthProperty().bind((ObservableValue)this.discussionTitleListViewController.getListView().widthProperty());
        discussionListCell.setMaxWidth(Double.NEGATIVE_INFINITY);
        discussionListCell.setMinWidth(Double.NEGATIVE_INFINITY);
        return discussionListCell;
    }

    private Button createButtonUnread() {
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"nav-button"});
        StackPane stackPane = new StackPane();
        this.iconButton = new SvgSizeable();
        Circle redCircle = new Circle(5.0);
        redCircle.getStyleClass().add((Object)"red-circle");
        redCircle.setVisible(false);
        redCircle.visibleProperty().bind((ObservableValue)this.model.unreadTagDisplayedProperty());
        redCircle.setTranslateX(10.0);
        redCircle.setTranslateY(-7.0);
        stackPane.getChildren().addAll((Object[])new Node[]{this.iconButton, redCircle});
        this.iconButton.getStyleClass().add((Object)"svg-discussion");
        button.setGraphic((Node)stackPane);
        return button;
    }

    public static void displayNewDiscussionModal(ActionEvent event) {
        ModalFlowController<DiscussionFlowId> flowController = new ModalFlowController<DiscussionFlowId>();
        NewDiscussionModalController modalController = new NewDiscussionModalController(flowController::close, flowController);
        ModalFlowController.builder().withInnerNode((Node)modalController.getLayout()).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_discussion.title")).withoutButton().addInModalStateFlow(DiscussionFlow.INIT, flowController);
        QrCodeModalController.builder(flowController).withPreviousStep(DiscussionFlow.INIT).addInModalStateFlow(DiscussionFlow.NEW_CONTACT, flowController);
        FlowConstructor.initGroupModal(flowController, DiscussionFlow.INIT);
        flowController.setState(DiscussionFlow.INIT);
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(flowController));
    }

    public static enum DiscussionFlow implements DiscussionFlowId
    {
        NEW_CONTACT,
        INIT;

    }
}

