/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.RemainingAttachmentsToCreateLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class DiscussionSelectionModel {
    private final AppLogger logger = new AppLogger(this.getClass());
    private static DiscussionSelectionModel discussionSelectionModel;
    private final MutableLiveData<Discussion> selectedDiscussionLiveData;
    private final LiveData<Optional<DiscussionInfo>> selectedDiscussionInfoLiveData;
    private final RemainingAttachmentsToCreateLiveData remainingDraftAttachmentToCreate;
    final NotificationListener<GenericNotification<Id<Discussion>>> discussionSelectedNotificationListener = this::notificationConsumer;
    private final MutableLiveData<Optional<DiscussionCustomization>> selectedDiscussionCustomizationLiveData;
    private final AtomicLong customizationRequestVersion = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DiscussionSelectionModel getInstance() {
        if (discussionSelectionModel != null) return discussionSelectionModel;
        Class<DiscussionSelectionModel> clazz = DiscussionSelectionModel.class;
        synchronized (DiscussionSelectionModel.class) {
            discussionSelectionModel = new DiscussionSelectionModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return discussionSelectionModel;
        }
    }

    DiscussionSelectionModel() {
        AppLogger.t("DiscussionSelectionModel::DiscussionSelectionModel()");
        this.selectedDiscussionLiveData = new MutableLiveData();
        this.selectedDiscussionCustomizationLiveData = new MutableLiveData(Optional.empty());
        LiveData discussionIdLiveData = LiveDataFactory.mapNullable(this.selectedDiscussionLiveData, Optional.empty(), d -> Optional.ofNullable(d).map(AbstractTableGenerated::getItemId));
        this.selectedDiscussionInfoLiveData = DbCache.getInstance().discussionInfoMapLiveData.optionalOf(discussionIdLiveData);
        this.remainingDraftAttachmentToCreate = new RemainingAttachmentsToCreateLiveData((LiveData<Discussion>)this.selectedDiscussionLiveData);
        this.selectedDiscussionLiveData.addListener((newDiscussion, oldDiscussion) -> {
            long myVersion = this.customizationRequestVersion.incrementAndGet();
            if (newDiscussion == null) {
                this.selectedDiscussionCustomizationLiveData.postValue(Optional.empty());
                return;
            }
            Object discussionId = newDiscussion.getItemId();
            AsyncTaskExecutor.submitTask(() -> this.lambda$new$1((Id)discussionId, myVersion));
        });
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, this.discussionSelectedNotificationListener);
    }

    public LiveData<Discussion> getSelectedDiscussionLiveData() {
        return this.selectedDiscussionLiveData;
    }

    public LiveData<Optional<DiscussionInfo>> getSelectedDiscussionInfoLiveData() {
        return this.selectedDiscussionInfoLiveData;
    }

    private void notificationConsumer(GenericNotification<Id<Discussion>> notification) {
        if (notification == null) {
            return;
        }
        Id<Discussion> discussionID = notification.getIncomingValue();
        if (discussionID == null) {
            this.selectedDiscussionLiveData.postValue(null);
            return;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionID);
        Optional<Id<OwnedIdentity>> selectedOwnedIdentityId = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityId();
        if (selectedOwnedIdentityId.isEmpty()) {
            return;
        }
        Id<OwnedIdentity> ownedIdentityId = discussion.getOwnedIdentityId();
        if (!ownedIdentityId.equals(selectedOwnedIdentityId.get())) {
            this.logger.warning("Received a change discussion notification from another identity.");
            return;
        }
        this.logger.trace("notificationConsumer()");
        this.selectedDiscussionLiveData.postValue(discussion);
    }

    public LiveData<Integer> getRemainingDraftAttachmentToCreate() {
        return this.remainingDraftAttachmentToCreate;
    }

    public Map<Id<Discussion>, Integer> getRemainingDraftAttachmentToCreatePerDiscussion() {
        return this.remainingDraftAttachmentToCreate.getRemainingDraftAttachmentToCreatePerDiscussion();
    }

    public LiveData<Optional<DiscussionCustomization>> getSelectedDiscussionCustomizationLiveData() {
        return this.selectedDiscussionCustomizationLiveData;
    }

    private /* synthetic */ void lambda$new$1(Id discussionId, long myVersion) {
        DiscussionCustomization dc = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization(discussionId);
        if (this.customizationRequestVersion.get() != myVersion) {
            return;
        }
        this.selectedDiscussionCustomizationLiveData.postValue(Optional.ofNullable(dc));
    }
}

