/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuFactory;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItem;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItemView;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.fx.modal.confirmation.discussion_deletion.DiscussionDeletionModalController;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoForCell;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

abstract class DiscussionListCell<T extends Diffable>
extends AbstractListCell<T> {
    private final BubbleAndDescription bubbleAndDescription;
    private Id<Discussion> lastDiscussionId;
    private static final int DISCUSSION_UNREAD_MESSAGE_LIMIT = 100;
    private final LongProperty numberUnreadMsg = new SimpleLongProperty(0L);
    private final BooleanProperty isMute = new SimpleBooleanProperty(false);
    private final Label unreadMessageCount = new Label();
    private final SvgSizeable muteIndicator = new SvgSizeable();
    public final Label sub_accessory = new Label();
    private final LiveDataListener<Optional<DiscussionInfoForCell>> discussionInfoChangeListener = this::discussionInfoChangeListener;

    protected DiscussionListCell() {
        this.initListCell(true);
        this.bubbleAndDescription = new BubbleAndDescription();
        BorderPane.setMargin((Node)this.bubbleAndDescription.bubble, (Insets)new Insets(0.0, 12.0, 0.0, 4.0));
        this.bindUnreadNumberLabel();
        this.bindMuteImage();
        this.sub_accessory.getStyleClass().add((Object)"body-3");
        this.unreadMessageCount.getStyleClass().add((Object)"notification-number");
        this.unreadMessageCount.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.muteIndicator.getStyleClass().setAll((Object[])new String[]{"svg-bell-off", "icon-grey"});
        HBox indicatorHBox = new HBox();
        indicatorHBox.getChildren().addAll((Object[])new Node[]{this.unreadMessageCount, this.muteIndicator});
        indicatorHBox.setAlignment(Pos.CENTER_RIGHT);
        this.bubbleAndDescription.rightVBox.maxHeightProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.bubbleAndDescription.title.heightProperty(), (ObservableNumberValue)this.bubbleAndDescription.subtitleHeightProperty()));
        this.bubbleAndDescription.rightVBox.getChildren().addAll((Object[])new Node[]{indicatorHBox, this.sub_accessory});
    }

    abstract Id<Discussion> getId(T var1);

    private void resetListenerAndLastDiscussion() {
        if (this.lastDiscussionId == null) {
            return;
        }
        DbCache.getInstance().discussionInfoForCellMapLiveData.removeListener(this.lastDiscussionId, this.discussionInfoChangeListener);
        this.lastDiscussionId = null;
    }

    private void bindUnreadNumberLabel() {
        this.unreadMessageCount.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.isMute.not(), (ObservableBooleanValue)this.numberUnreadMsg.isNotEqualTo(0)));
        this.unreadMessageCount.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.numberUnreadMsg, (int)100)).then("100+").otherwise((ObservableStringValue)this.numberUnreadMsg.asString()));
    }

    private void bindMuteImage() {
        this.muteIndicator.visibleProperty().bind((ObservableValue)this.isMute);
        this.muteIndicator.managedProperty().bind((ObservableValue)this.muteIndicator.visibleProperty());
    }

    @Override
    protected void updateItem(T discussion, boolean empty) {
        super.updateItem(discussion, empty);
        if (empty || discussion == null) {
            this.setGraphic(null);
            this.setText(null);
            this.resetListenerAndLastDiscussion();
            return;
        }
        if (this.lastDiscussionId != null && !this.lastDiscussionId.equals(this.getId(discussion))) {
            this.resetListenerAndLastDiscussion();
        }
        if (this.lastDiscussionId == null) {
            DbCache.getInstance().discussionInfoForCellMapLiveData.addListener(this.getId(discussion), this.discussionInfoChangeListener);
        }
        this.setGraphic((Node)this.bubbleAndDescription);
        this.lastDiscussionId = this.getId(discussion);
    }

    private List<MenuItem> getMenuItems(Optional<DiscussionInfoForCell> discussionInfoOpt) {
        if (discussionInfoOpt.isEmpty()) {
            return List.of();
        }
        DiscussionInfoForCell discussionInfo = discussionInfoOpt.get();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add((MenuItem)new ContextMenuItem(ViewControllerHelper.getString("center_header_panel_menu_delete_discussion"), Optional.empty(), () -> AsyncTaskExecutor.submitTask(() -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(DiscussionDeletionModalController.of(discussionInfo.id()), false))), List.of("svg-trash1", "icon-small"), 350.0));
        items.add((MenuItem)new ContextMenuItem(ViewControllerHelper.getString("menu_item_mark_discussion_as_read_label"), Optional.empty(), () -> AsyncTaskExecutor.submitTask(() -> DiscussionApi.markDiscussionMessagesAsReadUpTo(discussionInfo.id(), Optional.empty())), Collections.emptyList(), 350.0));
        items.add((MenuItem)new SeparatorMenuItem());
        items.add(this.getMuteMenu(discussionInfo));
        return items;
    }

    private MenuItem getMuteMenu(DiscussionInfoForCell discussionInfo) {
        if (discussionInfo.muteNotificationsTimestamp().isPresent()) {
            return MuteDuration.NONE.getFxMenuItem(discussionInfo.id());
        }
        String menuLabel = ViewControllerHelper.getString("settings_disable_notifications_label");
        Menu menu = new Menu("", (Node)new ContextMenuItemView(menuLabel, Optional.empty(), List.of(), 300.0));
        for (MuteDuration muteDuration : MuteDuration.values()) {
            if (muteDuration == MuteDuration.NONE) continue;
            menu.getItems().add((Object)muteDuration.getFxMenuItem(discussionInfo.id()));
        }
        return menu;
    }

    private void discussionInfoChangeListener(Optional<DiscussionInfoForCell> newValue, Optional<DiscussionInfoForCell> oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (newValue.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> {
                BubbleUtils.resetBubbleData(this.bubbleAndDescription.bubble);
                this.numberUnreadMsg.setValue(null);
                this.bubbleAndDescription.setTitle(null);
                this.bubbleAndDescription.setSubtitle(Optional.empty());
                this.sub_accessory.setText(null);
            });
        } else {
            DiscussionInfoForCell discussionInfoForCell = newValue.get();
            DiscussionInfo discussionInfo = discussionInfoForCell.info();
            ViewControllerHelper.smartUIUpdate(() -> {
                if (this.lastDiscussionId == null) {
                    return;
                }
                if (!discussionInfo.id().equals(this.lastDiscussionId)) {
                    return;
                }
                this.bubbleAndDescription.setTitle(discussionInfo.title().orElse(""));
                if (discussionInfoForCell.lastTimestamp() > 0L) {
                    LocalDateTime time = DateUtils.of(discussionInfoForCell.lastTimestamp());
                    String format = DateUtils.formatTimeOrDate(time);
                    this.sub_accessory.setText(format);
                } else {
                    this.sub_accessory.setText(null);
                }
                BubbleUtils.setBubbleData(discussionInfo, this.bubbleAndDescription.bubble);
                if (discussionInfoForCell.lastMessageBody().isPresent()) {
                    this.bubbleAndDescription.setSubtitle(discussionInfoForCell.lastMessageBody());
                } else {
                    AppLogger.t("last message empty for discussion id : " + String.valueOf(discussionInfo.id()) + "\n title : " + String.valueOf(discussionInfo.title()));
                    this.bubbleAndDescription.setSubtitle(Optional.empty());
                }
                this.numberUnreadMsg.set(discussionInfoForCell.unreadMessages());
                this.isMute.set(discussionInfoForCell.muteNotificationsTimestamp().isPresent());
            });
        }
        this.setOnContextMenuRequested(event -> ContextMenuFactory.loadContextMenuWithScreenCoordinates(event.getScreenX(), event.getScreenY(), this.getMenuItems(newValue)));
    }
}

