/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.save;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.fx.modal.save_mode.SaveModeModalController;
import io.olvid.windows.messenger.fx.modal.save_mode.SaveSuccessModalController;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;

public final class AttachmentSaveUtils {
    private static final AppLogger logger = new AppLogger(AttachmentSaveUtils.class);

    private AttachmentSaveUtils() {
    }

    public static void askSaveMode(Consumer<SaveModeModalController.SaveMode> callback) {
        SaveModeModalController controller = new SaveModeModalController(callback);
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(controller));
    }

    public static void saveAsZip(List<? extends AbstractAttachmentGenerated<?>> attachments) {
        File selectedFile = AttachmentSaveUtils.showSaveFileDialog(ViewControllerHelper.getString("save_all_attachments_label"), "medias.zip", new FileChooser.ExtensionFilter("ZIP File", new String[]{"*.zip"}));
        if (selectedFile == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> AttachmentSaveUtils.performZipSave(selectedFile, attachments));
    }

    public static void saveIndividually(List<? extends AbstractAttachmentGenerated<?>> attachments) {
        File selectedDir = AttachmentSaveUtils.showSaveDirectoryDialog(ViewControllerHelper.getString("Choose_save_folder"));
        if (selectedDir == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> AttachmentSaveUtils.performIndividualSave(selectedDir, attachments));
    }

    private static File showSaveFileDialog(String title, String initialFileName, FileChooser.ExtensionFilter filter) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        fileChooser.setInitialFileName(initialFileName);
        fileChooser.getExtensionFilters().add((Object)filter);
        fileChooser.setInitialDirectory(AttachmentSaveUtils.getInitialDirectory());
        return fileChooser.showSaveDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
    }

    private static File showSaveDirectoryDialog(String title) {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle(title);
        dirChooser.setInitialDirectory(AttachmentSaveUtils.getInitialDirectory());
        return dirChooser.showDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
    }

    private static File getInitialDirectory() {
        String previousPath;
        File dir = new File(AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH);
        File downloads = new File(dir, "Downloads");
        if (downloads.exists()) {
            dir = downloads;
        }
        if ((previousPath = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY)) != null) {
            File previousFolder = new File(previousPath);
            if (previousFolder.exists()) {
                dir = previousFolder;
            } else {
                ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY, null);
            }
        }
        return dir;
    }

    private static void performZipSave(File outputFile, List<? extends AbstractAttachmentGenerated<?>> attachments) {
        try {
            List<AbstractAttachmentGenerated> validAttachments = attachments.stream().filter(a -> a.getFyleId() != null && a.getMimeType() != null).toList();
            if (validAttachments.isEmpty()) {
                logger.warning("No valid files found");
                return;
            }
            int[] count = new int[]{0};
            HashSet<String> zipEntries = new HashSet<String>();
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));){
                for (AbstractAttachmentGenerated attachment : validAttachments) {
                    if (!AttachmentSaveUtils.addAttachmentToZip(zos, attachment, zipEntries)) continue;
                    count[0] = count[0] + 1;
                }
            }
            logger.info("ZIP saved successfully: " + count[0] + " file(s) at " + outputFile.getAbsolutePath());
            AttachmentSaveUtils.cacheDirectory(outputFile.getParentFile());
            ViewControllerHelper.smartUIUpdate(() -> {
                SaveSuccessModalController controller = new SaveSuccessModalController(count[0]);
                NCRegistry.getUIActionNC().postNotification(new ModalNotification(controller));
            });
        }
        catch (Exception e) {
            logger.error("Error creating ZIP: " + e.getMessage(), e);
            AttachmentSaveUtils.showSaveError();
        }
    }

    private static boolean addAttachmentToZip(ZipOutputStream zos, AbstractAttachmentGenerated<?> attachment, Set<String> existingEntries) {
        try {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
            if (fyle == null || fyle.getFilePath() == null) {
                return false;
            }
            SecureFile secureFile = new SecureFile(FileApi.absolutePathFromRelative(fyle.getFilePath()));
            if (!secureFile.exists()) {
                logger.warning("File not found: " + fyle.getFilePath());
                return false;
            }
            String entryName = AttachmentSaveUtils.getUniqueName(attachment.getFilename(), existingEntries);
            existingEntries.add(entryName);
            try (SecureFileInputStream in = new SecureFileInputStream(secureFile);){
                zos.putNextEntry(new ZipEntry(entryName));
                in.transferTo((OutputStream)zos);
                zos.closeEntry();
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to add file to ZIP: ", e);
            return false;
        }
    }

    private static void performIndividualSave(File targetDir, List<? extends AbstractAttachmentGenerated<?>> attachments) {
        try {
            String[] existingFiles;
            HashSet<String> usedNames = new HashSet<String>();
            if (targetDir.exists() && targetDir.isDirectory() && (existingFiles = targetDir.list()) != null) {
                usedNames.addAll(Arrays.asList(existingFiles));
            }
            int[] count = new int[]{0};
            for (AbstractAttachmentGenerated<?> attachment : attachments) {
                if (!AttachmentSaveUtils.saveAttachmentIndividually(targetDir, attachment, usedNames)) continue;
                count[0] = count[0] + 1;
            }
            logger.info("Files saved successfully: " + count[0] + " file(s) to " + targetDir.getAbsolutePath());
            AttachmentSaveUtils.cacheDirectory(targetDir);
            ViewControllerHelper.smartUIUpdate(() -> {
                SaveSuccessModalController controller = new SaveSuccessModalController(count[0]);
                NCRegistry.getUIActionNC().postNotification(new ModalNotification(controller));
            });
        }
        catch (Exception e) {
            logger.error("Error saving files individually: " + e.getMessage(), e);
            AttachmentSaveUtils.showSaveError();
        }
    }

    private static boolean saveAttachmentIndividually(File targetDir, AbstractAttachmentGenerated<?> attachment, Set<String> usedNames) {
        try {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
            if (fyle == null || fyle.getFilePath() == null) {
                return false;
            }
            SecureFile secureFile = new SecureFile(FileApi.absolutePathFromRelative(fyle.getFilePath()));
            if (!secureFile.exists()) {
                return false;
            }
            String filename = AttachmentSaveUtils.getUniqueName(attachment.getFilename(), usedNames);
            usedNames.add(filename);
            File outputFile = new File(targetDir, filename);
            try (SecureFileInputStream in = new SecureFileInputStream(secureFile);
                 FileOutputStream out = new FileOutputStream(outputFile);){
                in.transferTo((OutputStream)out);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error saving file: ", e);
            return false;
        }
    }

    public static void save(AttachmentInfos attachmentInfos) {
        String previousFolderDir;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("save_attachment_label"));
        String filename = attachmentInfos.getFilename();
        String extension = AttachmentUtils.getFileExtension(filename);
        if (extension != null && !extension.isEmpty()) {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(extension.toUpperCase() + " files", new String[]{"*." + extension}));
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All files", new String[]{"*.*"}));
        File dir = new File(AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH);
        File downloads = new File(dir, "Downloads");
        if (downloads.exists()) {
            dir = downloads;
        }
        if ((previousFolderDir = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY)) != null) {
            File previousFolder = new File(previousFolderDir);
            if (previousFolder.exists()) {
                dir = previousFolder;
            } else {
                ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY, null);
            }
        }
        fileChooser.setInitialDirectory(dir);
        fileChooser.setInitialFileName(attachmentInfos.getFilename());
        File file = fileChooser.showSaveDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (file == null) {
            return;
        }
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY, file.getParent());
        AsyncTaskExecutor.submitTask(() -> {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachmentInfos.getFyleId());
            SecureFile secureInputFile = new SecureFile(FileApi.absolutePathFromRelative(fyle.getFilePath()));
            try (SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);
                 FileOutputStream outputStream = new FileOutputStream(file);){
                secureFileInputStream.transferTo((OutputStream)outputStream);
            }
            catch (Exception e) {
                AttachmentUtils.logger.error("Error saving attachment", e);
                ViewControllerHelper.smartUIUpdate(AttachmentSaveUtils::showSaveError);
            }
            try {
                AttachmentUtils.createZoneIdentifier(file.getAbsolutePath());
            }
            catch (IOException e) {
                AttachmentUtils.logger.error("Error creating Zone.Identifier file", e);
            }
        });
    }

    private static String getUniqueName(String filename, Set<String> existing) {
        String newName;
        if (!existing.contains(filename)) {
            return filename;
        }
        int dotIndex = filename.lastIndexOf(46);
        String baseName = dotIndex > 0 ? filename.substring(0, dotIndex) : filename;
        String extension = dotIndex > 0 ? filename.substring(dotIndex) : "";
        int counter = 1;
        while (existing.contains(newName = baseName + " (" + counter + ")" + extension)) {
            ++counter;
        }
        return newName;
    }

    private static void cacheDirectory(File directory) {
        if (directory != null && directory.exists()) {
            ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.PREVIOUS_DOWNLOAD_DIRECTORY, directory.getAbsolutePath());
        }
    }

    public static void showSaveError() {
        ConfirmModalController modal = new ConfirmModalController(420.0);
        String title = ViewControllerHelper.getString("save_attachment_error_title");
        String desc = ViewControllerHelper.getString("save_attachment_error_label");
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(ViewControllerHelper.getString("modal.ok"), List.of("button-outline", "button-outline"), null).asDefault());
        Node icon = FxIcons.icon(FxIcons.BAN((Paint)Color.web((String)"#E53935"), null), 22.0, 22.0);
        modal.configure(title, desc, icon, actions);
        modal.setBadgeKind(ConfirmModalController.BadgeKind.DANGER);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(modal, false));
    }
}

