/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.reaction;

import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;

public class ReactionsHBox
extends HBox {
    private List<? extends Diffable> previousReactions = null;
    private Runnable onClickCallback;

    public ReactionsHBox() {
        this.getStylesheets().add((Object)"fx/discussions/discussion_view/messages/message_list/message_list_cell.css");
        this.getStyleClass().addAll((Object[])new String[]{"reaction-box", "shadow-long"});
        this.setPickOnBounds(true);
    }

    public <Reaction extends AbstractReactionGenerated<?>> void update(List<Reaction> reactions) {
        if (reactions == null || reactions.isEmpty()) {
            this.previousReactions = null;
            this.getChildren().clear();
            return;
        }
        if (DiffUtils.areContentTheSame(this.previousReactions, reactions)) {
            return;
        }
        this.getChildren().clear();
        HashMap<String, Integer> reactionsCount = new HashMap<String, Integer>();
        for (AbstractReactionGenerated reaction : reactions) {
            Optional<String> emoji = reaction.getEmoji();
            if (emoji.isEmpty()) continue;
            int count = reactionsCount.computeIfAbsent(emoji.get(), k -> 0);
            reactionsCount.put(emoji.get(), count + 1);
        }
        ArrayList sortedEmojis = new ArrayList(reactionsCount.keySet());
        sortedEmojis.sort(Comparator.naturalOrder());
        SimpleDoubleProperty fontSizeProperty = new SimpleDoubleProperty(14.0);
        for (String emoji : sortedEmojis) {
            EmojiHelper.EmojiView emojiView = new EmojiHelper.EmojiView(emoji);
            emojiView.configure((DoubleExpression)fontSizeProperty);
            this.getChildren().add((Object)emojiView);
            int count = (Integer)reactionsCount.get(emoji);
            if (count <= 1) continue;
            Label label = new Label();
            label.getStyleClass().add((Object)"reaction-count");
            label.setText(Integer.toString(count));
            this.getChildren().add((Object)label);
        }
        this.previousReactions = reactions;
    }

    public void setOnClickCallback(Runnable callback) {
        this.onClickCallback = callback;
        this.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY && this.onClickCallback != null) {
                this.onClickCallback.run();
            }
        });
    }
}

