/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.reaction;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.misc.GeneratedNotoEmojisConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReactionViewModel {
    private final Map<Id<IdentityRef>, LiveDataListener<Optional<IdentityInfo>>> identityListeners = new HashMap<Id<IdentityRef>, LiveDataListener<Optional<IdentityInfo>>>();
    private final MutableLiveData<String> emojiLiveData = new MutableLiveData();
    private static List<String> cachedEmojiCatalog = null;

    public void addReaction(MessageItem message, String emoji) {
        AsyncTaskExecutor.submitTask(() -> {
            AbstractMessageGenerated<?> patt0$temp = message.getWeakenedMessage();
            if (patt0$temp instanceof AbstractUserMessageGenerated) {
                AbstractUserMessageGenerated userMessage = (AbstractUserMessageGenerated)patt0$temp;
                Api.getMessageApi().reactToMessageDbTask(userMessage, Optional.of(emoji));
            }
        });
    }

    public void removeReaction(MessageItem message) {
        AsyncTaskExecutor.submitTask(() -> {
            AbstractMessageGenerated<?> patt0$temp = message.getWeakenedMessage();
            if (patt0$temp instanceof AbstractUserMessageGenerated) {
                AbstractUserMessageGenerated userMessage = (AbstractUserMessageGenerated)patt0$temp;
                this.emojiLiveData.postValue(null);
                Api.getMessageApi().reactToMessageDbTask(userMessage, Optional.empty());
            }
        });
    }

    public LiveData<String> getMyEmojiLiveData() {
        return this.emojiLiveData;
    }

    public <R extends AbstractReactionGenerated<?>> void loadIdentitiesForReactions(List<R> reactions) {
        List<Id> identityRefIds = reactions.stream().map(AbstractReactionGenerated::getSenderId).distinct().toList();
        identityRefIds.forEach(identityRefId -> {
            if (this.identityListeners.containsKey(identityRefId)) {
                return;
            }
            AbstractReactionGenerated reaction = reactions.stream().filter(r -> r.getSenderId().equals(identityRefId)).findFirst().orElse(null);
            LiveDataListener<Optional> listener = (newV, oldV) -> this.onIdentityLoadedForReaction(reaction, (Optional<IdentityInfo>)newV, (Optional<IdentityInfo>)oldV);
            this.identityListeners.put((Id<IdentityRef>)identityRefId, (LiveDataListener<Optional<IdentityInfo>>)listener);
            DbCache.getInstance().identityInfoMapLiveData.addListener((Id<IdentityRef>)identityRefId, (LiveDataListener<Optional<IdentityInfo>>)listener);
        });
    }

    private void onIdentityLoadedForReaction(AbstractReactionGenerated<?> reaction, Optional<IdentityInfo> newIdentityInfo, Optional<IdentityInfo> oldIdentityInfo) {
        if (reaction == null) {
            return;
        }
        if (newIdentityInfo.isPresent() && newIdentityInfo.get().isMe() && reaction.getEmoji().isPresent()) {
            this.emojiLiveData.postValue(reaction.getEmoji().get());
        }
    }

    public void clearIdentityListeners() {
        this.identityListeners.forEach((k, v) -> DbCache.getInstance().identityInfoMapLiveData.removeListener((Id<IdentityRef>)k, (LiveDataListener<Optional<IdentityInfo>>)v));
        this.identityListeners.clear();
        this.emojiLiveData.postValue(null);
    }

    public List<String> emojiCatalog() {
        if (cachedEmojiCatalog != null) {
            return cachedEmojiCatalog;
        }
        try {
            Map<String, String> allEmojis = GeneratedNotoEmojisConverter.emojiNotoConverter;
            if (allEmojis == null || allEmojis.isEmpty()) {
                return this.defaultEmojiCatalog();
            }
            List filteredEmojis = allEmojis.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            cachedEmojiCatalog = Collections.unmodifiableList(filteredEmojis);
            return cachedEmojiCatalog;
        }
        catch (Exception e) {
            System.err.println("Erreur lors du chargement du catalogue d'emojis: " + e.getMessage());
            return this.defaultEmojiCatalog();
        }
    }

    public List<String> defaultEmojiCatalog() {
        return Arrays.asList("\ud83d\udc4d", "\ud83d\udc4e", "\ud83d\udc4f", "\u270c\ufe0f", "\ud83d\udc4b", "\u261d\ufe0f", "\ud83d\ude4f", "\ud83d\udc4c", "\ud83d\udc4a", "\ud83d\udcaa", "\u2764\ufe0f", "\ud83d\udc99", "\ud83d\udc9a", "\ud83d\udc9b", "\ud83d\udc9c", "\ud83d\udda4", "\ud83e\udd0d", "\ud83d\udc96", "\ud83d\udc97", "\ud83d\udc98", "\ud83d\ude00", "\ud83d\ude01", "\ud83d\ude02", "\ud83d\ude03", "\ud83d\ude04", "\ud83d\ude06", "\ud83d\ude0a", "\ud83d\ude07", "\ud83d\ude42", "\ud83d\ude43", "\ud83d\ude09", "\ud83d\ude0c", "\ud83d\ude0d", "\ud83d\ude18", "\ud83d\ude17", "\ud83d\ude19", "\ud83d\ude1a", "\ud83d\ude0b", "\ud83d\ude1c", "\ud83e\udd2a", "\ud83d\ude0f", "\ud83d\ude12", "\ud83d\ude1e", "\ud83d\ude14", "\ud83d\ude22", "\ud83d\ude2d", "\ud83d\ude21", "\ud83d\ude20", "\ud83e\udd2c", "\ud83e\udd2f", "\ud83d\ude33", "\ud83d\ude31", "\ud83d\ude28", "\ud83d\ude30", "\ud83d\ude25", "\ud83d\ude13", "\ud83e\udd14", "\ud83e\udd28", "\ud83e\udd17", "\ud83e\udd1d", "\ud83d\ude48", "\ud83d\ude49", "\ud83d\ude4a", "\ud83d\udc40", "\ud83d\udc45", "\ud83d\ude34", "\ud83e\udd24", "\ud83d\ude37", "\ud83e\udd12", "\ud83e\udd15", "\ud83d\udd25", "\u2728", "\ud83c\udf89", "\u2b50", "\ud83c\udf1f", "\u26a1", "\ud83d\udca5", "\ud83c\udf08", "\u2600\ufe0f", "\ud83c\udf19", "\ud83d\ude80", "\u26bd", "\ud83c\udfc6", "\ud83c\udf81", "\ud83c\udfa8", "\ud83c\udf55", "\ud83c\udf54", "\ud83c\udf63", "\ud83c\udf69", "\u2615");
    }

    public List<String> getquickReactions() {
        return Arrays.asList("\u2764\ufe0f", "\ud83d\udc4d", "\ud83d\udc4e", "\ud83d\ude02", "\ud83d\ude2e", "\ud83d\ude22");
    }

    public static void initializeEmojiCache() {
        new Thread(() -> {
            System.out.println("Amor\u00e7age du catalogue d'emojis...");
            ReactionViewModel.emojiCatalogStatic();
        }).start();
    }

    public static List<String> emojiCatalogStatic() {
        if (cachedEmojiCatalog != null) {
            return cachedEmojiCatalog;
        }
        try {
            Map<String, String> allEmojis = GeneratedNotoEmojisConverter.emojiNotoConverter;
            if (allEmojis == null || allEmojis.isEmpty()) {
                return Collections.emptyList();
            }
            cachedEmojiCatalog = Collections.unmodifiableList(new ArrayList<String>(allEmojis.keySet()));
            return cachedEmojiCatalog;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public int getCategoryStartIndex(int categoryIndex) {
        return switch (categoryIndex) {
            case 0 -> 0;
            case 1 -> 171;
            case 2 -> 575;
            case 3 -> 736;
            case 4 -> 934;
            case 5 -> 1101;
            case 6 -> 1268;
            case 7 -> 1542;
            default -> 0;
        };
    }
}

