/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.reaction;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.ItemId;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionPalette;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionPaletteDelegate;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionViewModel;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseContextMenuController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.layout.StackPane;

public class ReactionViewController
extends BaseContextMenuController
implements ReactionPaletteDelegate {
    private final ReactionViewModel model;
    private final DiscussionViewModel discussionViewModel;
    private final MutableLiveData<Double> scrollDiscussionLiveData;
    private MessageItem currentMessageItem;
    private final ReactionPalette palette;
    private final LiveDataListener<Double> scrollListener = this::onScrollDiscussionChanged;
    private final LiveDataListener<List<InboundMessageReaction>> inboundReactionListener = this::onInboundReactionsChanged;
    private final LiveDataListener<List<OutboundMessageReaction>> outboundReactionListener = this::onOutboundReactionsChanged;
    private final LiveDataListener<List<OwnedMessageReaction>> ownedReactionListener = this::onOwnedReactionsChanged;
    private final LiveDataListener<String> emojiDataListener = this::onEmojiDataLoaded;

    public ReactionViewController(ReactionViewModel model, MutableLiveData<Double> scrollDiscussionLiveData, DiscussionViewModel discussionViewModel) {
        this.model = model;
        this.scrollDiscussionLiveData = scrollDiscussionLiveData;
        this.discussionViewModel = discussionViewModel;
        this.palette = new ReactionPalette(new StackPane().getScene(), this, true, false);
        this.bindLifecycle();
    }

    @Override
    protected ContextMenu getContextMenu() {
        return this.palette;
    }

    @Override
    public void onLayoutAttached() {
        this.logger.debug("ReactionViewController::onLayoutAttached");
        this.attachReactionListenerToCurrentItem();
    }

    @Override
    public void onLayoutDetached() {
        this.logger.debug("ReactionViewController::onLayoutDetached");
        this.detachReactionListenerFromCurrentItem();
    }

    @Override
    public void onAddReaction(String emoji) {
        if (this.currentMessageItem == null) {
            return;
        }
        this.model.addReaction(this.currentMessageItem, emoji);
    }

    @Override
    public void onRemoveReaction() {
        if (this.currentMessageItem == null) {
            return;
        }
        this.model.removeReaction(this.currentMessageItem);
    }

    @Override
    public List<String> getQuickAccessReactions() {
        return this.model.getquickReactions();
    }

    @Override
    public List<String> getCatalog() {
        return !this.model.emojiCatalog().isEmpty() ? this.model.emojiCatalog() : this.model.defaultEmojiCatalog();
    }

    @Override
    public int getCategoryStartIndex(int index) {
        return this.model.getCategoryStartIndex(index);
    }

    public void showAt(MessageItem messageItem, Node anchor) {
        this.currentMessageItem = messageItem;
        this.palette.resetQuickRow();
        Platform.runLater(() -> {
            this.logger.debug("ReactionViewController::showAt");
            this.palette.show(anchor);
        });
    }

    private void onScrollDiscussionChanged(Double newPosition, Double oldPosition) {
        if (newPosition == null && oldPosition == null) {
            this.logger.debug("ReactionViewController::onScrollDiscussionChanged NEW NULL OLD NULL");
            return;
        }
        if (newPosition != null && oldPosition == null) {
            this.logger.debug("ReactionViewController::onScrollDiscussionChanged NEW NOT NULL OLD NULL");
            return;
        }
        this.logger.debug("ReactionViewController::onScrollDiscussionChanged");
        Platform.runLater(this.palette::repositionIfShowing);
    }

    private void attachReactionListenerToCurrentItem() {
        if (this.currentMessageItem == null) {
            return;
        }
        ItemId itemId = this.currentMessageItem.getItemId().itemId();
        switch (itemId.kind) {
            case INBOUND: {
                this.discussionViewModel.getReactionsLiveDataPerInboundMessage().addListener((Id)itemId.inbound, this.inboundReactionListener);
                break;
            }
            case OUTBOUND: {
                this.discussionViewModel.getReactionsLiveDataPerOutboundMessage().addListener((Id)itemId.outbound, this.outboundReactionListener);
                break;
            }
            case OWNED: {
                this.discussionViewModel.getReactionsLiveDataPerOwnedMessage().addListener((Id)itemId.owned, this.ownedReactionListener);
            }
        }
        this.scrollDiscussionLiveData.addListener(this.scrollListener);
        this.model.getMyEmojiLiveData().addListener(this.emojiDataListener);
    }

    private void detachReactionListenerFromCurrentItem() {
        if (this.currentMessageItem == null) {
            return;
        }
        ItemId itemId = this.currentMessageItem.getItemId().itemId();
        switch (itemId.kind) {
            case INBOUND: {
                this.discussionViewModel.getReactionsLiveDataPerInboundMessage().removeListener((Id)itemId.inbound, this.inboundReactionListener);
                break;
            }
            case OUTBOUND: {
                this.discussionViewModel.getReactionsLiveDataPerOutboundMessage().removeListener((Id)itemId.outbound, this.outboundReactionListener);
                break;
            }
            case OWNED: {
                this.discussionViewModel.getReactionsLiveDataPerOwnedMessage().removeListener((Id)itemId.owned, this.ownedReactionListener);
            }
        }
        this.model.clearIdentityListeners();
        this.scrollDiscussionLiveData.removeListener(this.scrollListener);
        this.model.getMyEmojiLiveData().removeListener(this.emojiDataListener);
    }

    private void onInboundReactionsChanged(List<InboundMessageReaction> newList, List<InboundMessageReaction> oldList) {
        this.handleReactionsChanged(newList, oldList);
    }

    private void onOutboundReactionsChanged(List<OutboundMessageReaction> newList, List<OutboundMessageReaction> oldList) {
        this.handleReactionsChanged(newList, oldList);
    }

    private void onOwnedReactionsChanged(List<OwnedMessageReaction> newList, List<OwnedMessageReaction> oldList) {
        this.handleReactionsChanged(newList, oldList);
    }

    private void handleReactionsChanged(List<? extends AbstractReactionGenerated<?>> newList, List<? extends AbstractReactionGenerated<?>> oldList) {
        this.model.loadIdentitiesForReactions(newList);
    }

    private void onEmojiDataLoaded(String newValue, String oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            this.palette.reflectMySelection(newValue);
            this.palette.focusSelectedQuickOrFirst();
        });
    }
}

