/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.reaction;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionPaletteDelegate;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ReactionPalette
extends ContextMenu {
    final AppLogger logger = new AppLogger(((Object)((Object)this)).getClass());
    private static final int COLS = 13;
    private static final int MAX_EMOJIS = 2000;
    public static final String[] CAT_EMOJIS = new String[]{"\ud83d\ude0d", "\ud83d\udc4b", "\ud83d\udc36", "\ud83e\udd50", "\ud83d\ude98", "\u26bd", "\ud83d\udca1", "\u267b\ufe0f"};
    private static final int TOTAL_ROW_COUNT = 9;
    private static final double EMOJI_SIZE = 22.0;
    private final ReactionPaletteDelegate reactionPaletteDelegate;
    private final Scene scene;
    CustomMenuItem menuItem;
    private final VBox mainContent = new VBox();
    private final HBox quickRow = new HBox(6.0);
    private final Separator separator = new Separator();
    private final VBox gridContainer = new VBox(8.0);
    private final GridPane grid = new GridPane();
    private final ScrollPane scroller = new ScrollPane((Node)this.grid);
    private final HBox categoryBar = new HBox(12.0);
    private final StackPane gridSpinnerStack = new StackPane();
    private final HBox moreButton = new HBox();
    private Node selectedTab;
    private final StackPane loadingOverlay = new StackPane();
    private final RingProgressIndicator spinner = new RingProgressIndicator();
    private Node focusedNode;
    private Area navigationFocusArea = Area.QUICK;
    private final ObjectProperty<Area> displayedArea = new SimpleObjectProperty((Object)Area.QUICK);
    private final ObjectProperty<PaletteLoadingState> paletteLoadingState = new SimpleObjectProperty((Object)PaletteLoadingState.NONE);
    private int quickIdx = 0;
    private int gridRow = 0;
    private int gridCol = 0;
    private EventHandler<KeyEvent> keyFilter;
    private EventHandler<ContextMenuEvent> contextMenuEventFilter;
    private EventHandler<MouseEvent> mouseEventFilter;
    private final ObservableList<PaletteCellInfo> backingList = FXCollections.observableList(new ArrayList());
    private final ChangeListener<Area> displayAreaListener = this::displayStateListener;
    private final ListChangeListener<PaletteCellInfo> paletteCellInfoChangeListener = this::backingListChangeListener;
    boolean hideOnAction;
    boolean forceFull;

    public ReactionPalette(Scene scene, ReactionPaletteDelegate reactionPaletteDelegate, boolean hideOnAction, boolean forceFull) {
        this.reactionPaletteDelegate = reactionPaletteDelegate;
        this.hideOnAction = hideOnAction;
        this.forceFull = forceFull;
        this.scene = scene;
        this.mainContent.getStylesheets().add((Object)"fx/design_system/reaction_palette.css");
        this.mainContent.getStylesheets().add((Object)"fx/main_stack/main_layer/main.css");
        this.setupMenu();
        this.buildContent();
        this.wireKeyboard();
        this.plugInternalListeners();
    }

    public void show(Node anchor) {
        this.logger.trace("ReactionPalette::show with side");
        if (this.isShowing()) {
            this.hide();
        }
        this.show(anchor, Side.BOTTOM, 0.0, 0.0);
        this.mainContent.requestFocus();
        this.focusSelectedQuickOrFirst();
    }

    public void show(Region anchor) {
        this.logger.trace("ReactionPalette::show");
        if (this.isShowing()) {
            this.hide();
        }
        Bounds layoutScreenBounds = anchor.localToScreen(anchor.getBoundsInLocal());
        if (this.forceFull) {
            this.displayedArea.setValue((Object)Area.GRID);
        }
        this.show(anchor.getScene().getWindow(), layoutScreenBounds.getMinX(), layoutScreenBounds.getMinY() - Math.max(450.0, anchor.getHeight() - 300.0));
        this.mainContent.requestFocus();
        if (this.focusedNode == null) {
            this.focusSelectedQuickOrFirst();
        }
    }

    void hideIfShowing() {
        this.logger.debug("ReactionPalette::hideIfShowing");
        if (this.isShowing()) {
            this.logger.debug("ReactionPalette::hideIfShowing --> hide");
            this.hide();
        }
    }

    void repositionIfShowing() {
        if (!this.isShowing()) {
            return;
        }
        this.logger.debug("ReactionPalette::repositionIfShowing --> isShowing TRUE");
        Node anchor = this.getOwnerNode();
        this.hide();
        this.show(anchor, Side.TOP, 0.0, 0.0);
    }

    void resetQuickRow() {
        this.quickRow.getChildren().setAll(this.quickButtons());
        this.quickRow.getChildren().add((Object)this.makeMoreButton());
    }

    void reflectMySelection(String myEmoji) {
        if (myEmoji == null) {
            this.resetQuickRow();
            return;
        }
        this.quickRow.getChildren().clear();
        List<String> quick = this.reactionPaletteDelegate.getQuickAccessReactions();
        boolean inQuick = quick.contains(myEmoji);
        if (inQuick) {
            quick.forEach(k -> {
                boolean sel = Objects.equals(k, myEmoji);
                HBox btn = this.makeEmojiButton((String)k, sel);
                if (sel) {
                    btn.getStyleClass().add((Object)"reaction-emoji-button-selected");
                }
                this.quickRow.getChildren().add((Object)btn);
            });
        } else {
            this.quickRow.getChildren().addAll(this.quickButtons());
            HBox mine = this.makeEmojiButton(myEmoji, true);
            mine.getStyleClass().add((Object)"reaction-emoji-button-selected");
            this.quickRow.getChildren().add((Object)mine);
        }
        this.quickRow.getChildren().add((Object)this.makeMoreButton());
    }

    void focusSelectedQuickOrFirst() {
        this.navigationFocusArea = Area.QUICK;
        for (int i = 0; i < this.quickRow.getChildren().size(); ++i) {
            Node n = (Node)this.quickRow.getChildren().get(i);
            if (!n.getStyleClass().contains((Object)"reaction-emoji-button-selected")) continue;
            this.quickIdx = i;
            this.updateFocus(n);
            return;
        }
        this.quickIdx = 0;
        this.updateFocus(this.getQuickNode(0));
    }

    private void setupMenu() {
        this.setAutoHide(true);
        this.getStyleClass().add((Object)"reaction-palette-container");
        this.menuItem = new CustomMenuItem((Node)this.mainContent, false);
        this.mainContent.getStyleClass().addAll((Object[])new String[]{"reaction-palette-container"});
        this.menuItem.getStyleClass().addAll((Object[])new String[]{"white-item"});
        this.getItems().add((Object)this.menuItem);
        this.setOnShown(e -> {
            this.mainContent.setFocusTraversable(true);
            this.mainContent.requestFocus();
            this.navigationFocusArea = Area.QUICK;
            this.quickIdx = Math.min(this.getQuickEmojiCount() - 1, 0);
            this.updateFocus(this.getQuickNode(this.quickIdx));
        });
        this.setOnHidden(e -> {
            if (this.getScene() != null && this.keyFilter != null) {
                Scene ownerScene;
                this.getScene().removeEventFilter(KeyEvent.KEY_PRESSED, this.keyFilter);
                this.getScene().removeEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuEventFilter);
                this.keyFilter = null;
                this.contextMenuEventFilter = null;
                Node owner = this.getOwnerNode();
                Scene scene = ownerScene = owner != null ? owner.getScene() : null;
                assert (this.scene != null);
                ViewControllerHelper.MAIN_STAGE.getScene().removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEventFilter);
                this.mouseEventFilter = null;
            }
        });
    }

    private void buildContent() {
        this.loadingOverlay.setAlignment(Pos.CENTER);
        this.loadingOverlay.setMouseTransparent(false);
        this.spinner.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.spinner.setProgress(-1);
        this.spinner.setInnerCircleRadius(14);
        this.spinner.setRingWidth(2);
        this.spinner.setMaxSize(40.0, 40.0);
        this.loadingOverlay.getChildren().add((Object)this.spinner);
        this.mainContent.setPadding(new Insets(3.0, 8.0, 3.0, 8.0));
        this.quickRow.setAlignment(Pos.CENTER_LEFT);
        this.quickRow.getChildren().addAll(this.quickButtons());
        this.quickRow.getChildren().add((Object)this.makeMoreButton());
        this.categoryBar.setAlignment(Pos.CENTER);
        this.categoryBar.setPadding(new Insets(6.0, 4.0, 6.0, 4.0));
        this.categoryBar.getStyleClass().add((Object)"reaction-category-container");
        this.categoryBar.setSpacing(0.0);
        this.categoryBar.getChildren().add((Object)this.makeSpacer());
        for (int i = 0; i < CAT_EMOJIS.length; ++i) {
            Node tab = this.makeCategoryTab(CAT_EMOJIS[i], i);
            this.categoryBar.getChildren().add((Object)tab);
            this.categoryBar.getChildren().add((Object)this.makeSpacer());
            if (i != 0) continue;
            tab.getStyleClass().add((Object)"tab-selected");
            this.selectedTab = tab;
        }
        this.grid.setHgap(6.0);
        this.grid.setVgap(6.0);
        this.grid.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.scroller.setFitToHeight(true);
        this.scroller.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scroller.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        double emojiUnit = 38.0;
        int rows = 9;
        this.scroller.setPrefViewportWidth(emojiUnit * 12.5);
        this.scroller.setPrefViewportHeight(emojiUnit * (double)rows);
        this.scroller.setMaxHeight(emojiUnit * (double)rows);
        VBox.setVgrow((Node)this.scroller, (Priority)Priority.NEVER);
        this.separator.getStyleClass().add((Object)"reaction-palette-separator");
        this.gridContainer.getChildren().addAll((Object[])new Node[]{this.separator, this.scroller, this.categoryBar});
        this.gridContainer.setSpacing(8.0);
        this.gridContainer.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        this.gridSpinnerStack.getChildren().addAll((Object[])new Node[]{this.gridContainer, this.loadingOverlay});
        this.mainContent.getChildren().setAll((Object[])new Node[]{this.quickRow, this.gridSpinnerStack});
        this.scroller.hvalueProperty().addListener((observable, oldValue, newValue) -> this.updateActiveTabFromScroll(newValue.doubleValue()));
        this.gridContainer.managedProperty().bind((ObservableValue)this.gridContainer.visibleProperty());
        this.gridContainer.visibleProperty().bind((ObservableValue)this.displayedArea.isEqualTo((Object)Area.GRID));
        this.loadingOverlay.managedProperty().bind((ObservableValue)this.loadingOverlay.visibleProperty());
        this.loadingOverlay.visibleProperty().bind((ObservableValue)this.paletteLoadingState.isEqualTo((Object)PaletteLoadingState.LOADING).and((ObservableBooleanValue)this.displayedArea.isEqualTo((Object)Area.GRID)));
    }

    private Node makeSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    private Node makeCategoryTab(String emojiKey, int index) {
        EmojiHelper.EmojiView iconView = new EmojiHelper.EmojiView(emojiKey);
        iconView.configure((DoubleExpression)new SimpleDoubleProperty(22.0));
        VBox tab = new VBox(new Node[]{iconView});
        tab.setAlignment(Pos.CENTER);
        tab.setPrefSize(60.0, 32.0);
        tab.setMinSize(60.0, 32.0);
        tab.setCursor(Cursor.HAND);
        tab.getStyleClass().add((Object)"reaction-category-tab");
        tab.setOnMouseClicked(e -> {
            if (this.selectedTab != null) {
                this.selectedTab.getStyleClass().remove((Object)"tab-selected");
            }
            tab.getStyleClass().add((Object)"tab-selected");
            this.selectedTab = tab;
            System.out.println("LOG: Clic cat\u00e9gorie " + index);
            this.scrollToCategory(index);
        });
        return tab;
    }

    private void scrollToCategory(int categoryIndex) {
        int col;
        int emojiIndex = this.reactionPaletteDelegate.getCategoryStartIndex(categoryIndex);
        int row = emojiIndex % 9;
        Node targetNode = this.getGridNode(row, col = emojiIndex / 9);
        if (targetNode != null) {
            this.grid.applyCss();
            this.grid.layout();
            double cellWidth = 38.0;
            double targetX = (double)col * cellWidth;
            double contentWidth = this.grid.getLayoutBounds().getWidth();
            double viewportWidth = this.scroller.getViewportBounds().getWidth();
            if (contentWidth > viewportWidth) {
                double hValue = targetX / (contentWidth - viewportWidth);
                this.scroller.setHvalue(Math.max(0.0, Math.min(1.0, hValue)));
            }
            this.navigationFocusArea = Area.GRID;
            this.gridRow = row;
            this.gridCol = col;
            this.updateFocus(targetNode);
        }
    }

    private void updateActiveTabFromScroll(double hValue) {
        double viewportWidth;
        double contentWidth = this.grid.getLayoutBounds().getWidth();
        double maxScrollableWidth = contentWidth - (viewportWidth = this.scroller.getViewportBounds().getWidth());
        if (maxScrollableWidth <= 0.0) {
            return;
        }
        double currentX = hValue * maxScrollableWidth;
        int currentColumn = (int)((currentX + 38.0) / 38.0);
        int currentEmojiIndex = currentColumn * 9;
        int categoryIndex = 0;
        for (int i = 7; i >= 0; --i) {
            if (currentEmojiIndex < this.reactionPaletteDelegate.getCategoryStartIndex(i)) continue;
            categoryIndex = i;
            break;
        }
        this.updateTabSelectionStyle(categoryIndex);
    }

    private void updateTabSelectionStyle(int index) {
        Node tab;
        int nodeIndex = index * 2 + 1;
        if (nodeIndex < this.categoryBar.getChildren().size() && this.selectedTab != (tab = (Node)this.categoryBar.getChildren().get(nodeIndex))) {
            if (this.selectedTab != null) {
                this.selectedTab.getStyleClass().remove((Object)"tab-selected");
            }
            tab.getStyleClass().add((Object)"tab-selected");
            this.selectedTab = tab;
        }
    }

    private void wireKeyboard() {
        this.setOnShown(ev -> {
            if (this.getScene() != null) {
                if (this.keyFilter == null) {
                    this.keyFilter = e -> {
                        switch (e.getCode()) {
                            case ESCAPE: {
                                this.hide();
                                break;
                            }
                            case ENTER: {
                                this.confirmSelection();
                                break;
                            }
                            case LEFT: {
                                this.moveLeft();
                                break;
                            }
                            case RIGHT: {
                                this.moveRight();
                                break;
                            }
                            case UP: {
                                this.moveUp();
                                break;
                            }
                            case DOWN: {
                                this.moveDown();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        e.consume();
                    };
                    this.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this.keyFilter);
                }
                if (this.contextMenuEventFilter == null) {
                    this.contextMenuEventFilter = e -> this.hideIfShowing();
                    this.getScene().addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuEventFilter);
                }
                if (this.mouseEventFilter == null) {
                    Scene ownerScene;
                    this.mouseEventFilter = e -> {
                        if (e.getButton() == MouseButton.SECONDARY) {
                            this.hideIfShowing();
                        }
                    };
                    Node owner = this.getOwnerNode();
                    Scene scene = ownerScene = owner != null ? owner.getScene() : null;
                    assert (this.scene != null);
                    ViewControllerHelper.MAIN_STAGE.getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEventFilter);
                }
            }
        });
    }

    private void confirmSelection() {
        if (this.focusedNode == null) {
            return;
        }
        Object ud = this.focusedNode.getUserData();
        if (ud instanceof String) {
            String key = (String)ud;
            this.reactionPaletteDelegate.onAddReaction(key);
            if (this.hideOnAction) {
                this.hide();
            }
        }
    }

    private HBox makeMoreButton() {
        this.moreButton.getChildren().clear();
        this.moreButton.setSpacing(0.0);
        this.moreButton.setPadding(new Insets(0.0));
        this.moreButton.setPrefSize(32.0, 32.0);
        this.moreButton.setMinSize(32.0, 32.0);
        this.moreButton.setAlignment(Pos.CENTER);
        this.moreButton.setFocusTraversable(false);
        this.moreButton.setCursor(Cursor.HAND);
        Node icon = FxIcons.icon(FxIcons.PLUS((Paint)Color.BLACK, null), 24.0, 32.0, 24.0, 32.0);
        this.moreButton.getStyleClass().add((Object)"reaction-emoji-button");
        this.moreButton.getChildren().add((Object)icon);
        this.moreButton.managedProperty().bind((ObservableValue)this.moreButton.visibleProperty());
        this.moreButton.visibleProperty().bind((ObservableValue)this.displayedArea.isEqualTo((Object)Area.QUICK));
        this.moreButton.setOnMouseClicked(e -> {
            boolean willShow = !this.scroller.isVisible();
            this.toggleCatalogView();
            if (!willShow && this.navigationFocusArea == Area.GRID) {
                this.focusQuickIndex(Math.min(this.getQuickEmojiCount() - 1, this.gridCol));
            }
        });
        return this.moreButton;
    }

    public void toggleCatalogView() {
        this.logger.debug("ReactionPalette::toggleCatalogView");
        switch (((Area)((Object)this.displayedArea.get())).ordinal()) {
            case 0: {
                this.displayedArea.set((Object)Area.GRID);
                break;
            }
            case 1: {
                this.displayedArea.set((Object)Area.QUICK);
            }
        }
    }

    private List<HBox> quickButtons() {
        return this.reactionPaletteDelegate.getQuickAccessReactions().stream().map(k -> this.makeEmojiButton((String)k, false)).toList();
    }

    private HBox makeEmojiButton(String emojiKey, boolean selected) {
        HBox b = new HBox();
        b.setSpacing(0.0);
        b.setPadding(new Insets(0.0));
        b.setPrefSize(32.0, 32.0);
        b.setMinSize(32.0, 32.0);
        b.setAlignment(Pos.CENTER);
        b.setFocusTraversable(false);
        b.setCursor(Cursor.HAND);
        b.setUserData((Object)emojiKey);
        SimpleDoubleProperty fontSizeProperty = new SimpleDoubleProperty(22.0);
        EmojiHelper.EmojiView emojiView = new EmojiHelper.EmojiView(emojiKey);
        emojiView.configure((DoubleExpression)fontSizeProperty);
        HBox.setHgrow((Node)emojiView, (Priority)Priority.NEVER);
        b.getStyleClass().add((Object)"reaction-emoji-button");
        b.getChildren().add((Object)emojiView);
        b.setOnMouseClicked(e -> {
            if (!selected) {
                this.reactionPaletteDelegate.onAddReaction(emojiKey);
            } else {
                this.reactionPaletteDelegate.onRemoveReaction();
                this.resetQuickRow();
            }
            if (this.hideOnAction) {
                this.hide();
            }
        });
        return b;
    }

    private void focusQuickIndex(int idx) {
        if (this.getQuickEmojiCount() == 0) {
            return;
        }
        idx = Math.max(0, Math.min(idx, this.getQuickEmojiCount() - 1));
        this.navigationFocusArea = Area.QUICK;
        this.quickIdx = idx;
        this.updateFocus(this.getQuickNode(this.quickIdx));
    }

    private void loadCatalogAsync() {
        ViewControllerHelper.smartUIUpdate(() -> this.paletteLoadingState.set((Object)PaletteLoadingState.LOADING));
        Task<List<PaletteCellInfo>> task = new Task<List<PaletteCellInfo>>(){

            protected List<PaletteCellInfo> call() throws Exception {
                ReactionPalette.this.logger.debug("ReactionPalette::loadCatalogAsync");
                List<String> catalog = ReactionPalette.this.reactionPaletteDelegate.getCatalog();
                int max = Math.min(2000, catalog.size());
                ArrayList<PaletteCellInfo> list = new ArrayList<PaletteCellInfo>();
                int currentIdx = 0;
                while (currentIdx < max) {
                    int start = currentIdx;
                    int batchSize = start == 0 ? 250 : 100;
                    int end = Math.min(start + batchSize, max);
                    for (int j = start; j < end; ++j) {
                        list.add(new PaletteCellInfo(catalog.get(j), j % 9, j / 9));
                    }
                    currentIdx = end;
                }
                ReactionPalette.this.backingList.addAll(list);
                return list;
            }
        };
        AsyncTaskExecutor.submitTask((Runnable)task);
    }

    private void moveLeft() {
        if (this.navigationFocusArea == Area.QUICK) {
            if (this.quickIdx > 0) {
                this.focusQuickIndex(this.quickIdx - 1);
            }
        } else if (this.gridCol > 0) {
            --this.gridCol;
            this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
        } else if (this.gridRow > 0) {
            --this.gridRow;
            this.gridCol = this.lastColIndexForRow(this.gridRow);
            this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
        } else if (this.getQuickEmojiCount() > 0) {
            this.focusQuickIndex(this.getQuickEmojiCount() - 1);
        }
    }

    private void moveRight() {
        switch (this.navigationFocusArea.ordinal()) {
            case 0: {
                int last = Math.max(0, this.getQuickEmojiCount() - 1);
                if (this.quickIdx < last) {
                    this.focusQuickIndex(this.quickIdx + 1);
                    break;
                }
                if (!this.scroller.isVisible()) break;
                this.navigationFocusArea = Area.GRID;
                this.gridRow = 0;
                this.gridCol = 0;
                this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
                break;
            }
            case 1: {
                int lastCol = this.lastColIndexForRow(this.gridRow);
                if (this.gridCol < lastCol) {
                    ++this.gridCol;
                    this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
                    break;
                }
                if (this.gridRow >= 8) break;
                ++this.gridRow;
                this.gridCol = 0;
                this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
            }
        }
    }

    private void moveUp() {
        if (this.navigationFocusArea == Area.GRID) {
            if (this.gridRow > 0) {
                --this.gridRow;
                this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
            } else if (this.getQuickEmojiCount() > 0) {
                this.focusQuickIndex(Math.min(this.getQuickEmojiCount() - 1, this.gridCol));
            }
        }
    }

    private void moveDown() {
        if (this.navigationFocusArea == Area.QUICK && this.scroller.isVisible()) {
            this.navigationFocusArea = Area.GRID;
            this.gridRow = 0;
            this.gridCol = Math.min(12, this.quickIdx);
            this.logger.trace("ReactionPalette::moveDown updateFocus for r --> %d and c --> %d", this.gridRow, this.gridCol);
            this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
        } else if (this.navigationFocusArea == Area.GRID && this.gridRow < 8) {
            ++this.gridRow;
            this.logger.trace("ReactionPalette::moveDown updateFocus for r --> %d and c --> %d", this.gridRow, this.gridCol);
            this.updateFocus(this.getGridNode(this.gridRow, this.gridCol));
        }
    }

    private int lastColIndexForRow(int row) {
        int max = 0;
        for (Node n : this.grid.getChildren()) {
            Integer cc;
            int C;
            Integer rr = GridPane.getRowIndex((Node)n);
            int R = rr == null ? 0 : rr;
            if (R != row || (C = (cc = GridPane.getColumnIndex((Node)n)) == null ? 0 : cc) <= max) continue;
            max = C;
        }
        this.logger.trace("ReactionPalette::lastColIndexForRow max --> %d", max);
        return max;
    }

    private void updateFocus(Node newNode) {
        if (newNode == null || this.focusedNode == newNode) {
            return;
        }
        if (this.focusedNode != null) {
            this.focusedNode.getStyleClass().remove((Object)"focused");
            this.focusedNode.getStyleClass().remove((Object)"focused-selected");
        }
        this.focusedNode = newNode;
        if (this.focusedNode.getStyleClass().contains((Object)"reaction-emoji-button-selected")) {
            this.focusedNode.getStyleClass().add((Object)"focused-selected");
        } else {
            this.focusedNode.getStyleClass().add((Object)"focused");
        }
        if (this.scroller.isVisible() && this.navigationFocusArea == Area.GRID) {
            this.ensureVisibleInScroll(this.scroller, this.focusedNode);
        }
    }

    private void ensureVisibleInScroll(ScrollPane scroll, Node node) {
        Node content = scroll.getContent();
        if (content == null) {
            return;
        }
        Bounds nodeBounds = node.getBoundsInParent();
        Bounds contentBounds = content.getLayoutBounds();
        double viewportHeight = scroll.getViewportBounds().getWidth();
        double contentHeight = contentBounds.getWidth();
        double current = scroll.getHvalue() * Math.max(1.0, contentHeight - viewportHeight);
        double nodeMin = nodeBounds.getMinX();
        double nodeMax = nodeBounds.getMaxX();
        double target = current;
        if (nodeMin < current) {
            target = nodeMin;
        } else if (nodeMax > current + viewportHeight) {
            target = nodeMax - viewportHeight;
        }
        double denom = Math.max(1.0, contentHeight - viewportHeight);
        double max = Math.max(0.0, Math.min(1.0, target / denom));
        this.logger.trace("ReactionPalette::ensureVisibleInScroll VValue --> " + max);
        scroll.setHvalue(max);
    }

    private int getQuickEmojiCount() {
        return Math.max(0, this.quickRow.getChildren().size() - 1);
    }

    private Node getQuickNode(int i) {
        int count = this.getQuickEmojiCount();
        if (count == 0) {
            return null;
        }
        i = Math.max(0, Math.min(i, count - 1));
        return (Node)this.quickRow.getChildren().get(i);
    }

    private Node getGridNode(int r, int c) {
        r = Math.max(0, Math.min(r, 8));
        c = Math.max(0, Math.min(c, this.lastColIndexForRow(r)));
        for (Node n : this.grid.getChildren()) {
            int C;
            Integer rr = GridPane.getRowIndex((Node)n);
            Integer cc = GridPane.getColumnIndex((Node)n);
            int R = rr == null ? 0 : rr;
            int n2 = C = cc == null ? 0 : cc;
            if (R != r || C != c) continue;
            this.logger.trace("ReactionPalette::getGridNode --> found node in gride with r --> %d and c --> %d ", r, c);
            return n;
        }
        return null;
    }

    private void displayStateListener(ObservableValue<? extends Area> observable, Area oldValue, Area newValue) {
        switch (((PaletteLoadingState)((Object)this.paletteLoadingState.get())).ordinal()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.loadCatalogAsync();
            }
        }
    }

    private void backingListChangeListener(final ListChangeListener.Change<? extends PaletteCellInfo> change) {
        this.logger.trace("ReactionPalette::BackingListListener");
        Task<List<Pair<PaletteCellInfo, HBox>>> task = new Task<List<Pair<PaletteCellInfo, HBox>>>(){

            protected List<Pair<PaletteCellInfo, HBox>> call() {
                if (change.next()) {
                    ArrayList<Pair<PaletteCellInfo, HBox>> preloaded = new ArrayList<Pair<PaletteCellInfo, HBox>>(change.getAddedSize());
                    for (PaletteCellInfo info : change.getAddedSubList()) {
                        preloaded.add(Pair.of(info, ReactionPalette.this.makeEmojiButton(info.emoji, false)));
                    }
                    return preloaded;
                }
                return List.of();
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$backingListChangeListener$13((Task)task, arg_0));
        AsyncTaskExecutor.submitTask((Runnable)task);
    }

    public void hide() {
        this.unplugInternalListeners();
        super.hide();
    }

    public void plugInternalListeners() {
        this.logger.debug("ReactionPalette::plugInternalListeners");
        this.backingList.addListener(this.paletteCellInfoChangeListener);
        this.displayedArea.addListener(this.displayAreaListener);
    }

    public void unplugInternalListeners() {
        this.logger.debug("ReactionPalette::unplugInternalListeners");
        this.backingList.removeListener(this.paletteCellInfoChangeListener);
        this.displayedArea.removeListener(this.displayAreaListener);
    }

    private /* synthetic */ void lambda$backingListChangeListener$13(Task task, WorkerStateEvent event) {
        for (Pair hbox : (List)task.getValue()) {
            this.grid.add((Node)hbox.getSecond(), ((PaletteCellInfo)hbox.getFirst()).col(), ((PaletteCellInfo)hbox.getFirst()).row());
        }
        this.paletteLoadingState.set((Object)PaletteLoadingState.LOADED);
    }

    private static enum Area {
        QUICK,
        GRID;

    }

    private static enum PaletteLoadingState {
        LOADING,
        LOADED,
        NONE;

    }

    record PaletteCellInfo(String emoji, int row, int col) {
    }
}

