/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class PollMessageView
extends VBox {
    private final LiveData<Long> tickerLiveData;
    private static final UUID UUID_NIL = new UUID(0L, 0L);
    private static final Duration POLL_PROGRESS_ANIMATION_DURATION = Duration.millis((double)500.0);
    private boolean enableAnimation = true;
    private BiConsumer<PollMessage, PollMessageChoice> onChoiceClicked;
    private List<PollMessageChoice> displayedChoices = new ArrayList<PollMessageChoice>();
    private Id<PollMessage> displayedPollId;
    private Optional<Long> displayedPollExpiration = Optional.empty();
    private PollMessage currentPollMessage;
    private final LiveDataListener<Long> pollTickerListener = this::onTick;
    private final BooleanProperty pollDisabled = new SimpleBooleanProperty(false);
    private final BooleanProperty hasExpiration = new SimpleBooleanProperty(false);
    private final BooleanProperty hasMultipleChoices = new SimpleBooleanProperty(false);
    private Label expirationLabel;
    private final Pos alignment;
    private CheckBox nilCheckBox;
    private final BooleanProperty nilLockActive = new SimpleBooleanProperty(false);
    private final BooleanProperty userIsActiveProperty = new SimpleBooleanProperty(true);

    public PollMessageView(LiveData<Long> tickerLiveData, Pos alignment) {
        this.tickerLiveData = tickerLiveData;
        this.alignment = alignment;
        this.initialize();
    }

    private void initialize() {
        this.setId("pollMessageVBox");
        this.getStyleClass().setAll((Object[])new String[]{"body"});
        this.setSpacing(4.0);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.setPadding(new Insets(12.0, 12.0, 12.0, 12.0));
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMaxWidth(Double.MAX_VALUE);
        ViewControllerHelper.hideNode((Node)this);
    }

    public void setOnChoiceClicked(BiConsumer<PollMessage, PollMessageChoice> onChoiceClicked) {
        this.onChoiceClicked = onChoiceClicked;
    }

    public void setEnableAnimation(boolean enableAnimation) {
        this.enableAnimation = enableAnimation;
    }

    public void showPoll(PollMessage pollMessage, boolean userIsActive) {
        boolean firstTime;
        boolean samePollSameLayout;
        this.currentPollMessage = pollMessage;
        this.userIsActiveProperty.set(userIsActive);
        int newSize = this.currentPollMessage.choices == null ? 0 : this.currentPollMessage.choices.size();
        Object pollId = this.currentPollMessage.getItemId();
        boolean bl = samePollSameLayout = this.displayedPollId != null && this.displayedPollId.equals(pollId) && this.displayedChoices.size() == newSize;
        if (samePollSameLayout) {
            List<PollMessageChoice> updated = this.currentPollMessage.choices == null ? Collections.emptyList() : this.currentPollMessage.choices;
            this.updateVotes(updated);
            ViewControllerHelper.showNode((Node)this);
            return;
        }
        boolean bl2 = firstTime = this.displayedPollId == null || !this.displayedPollId.equals(pollId) || this.displayedChoices.size() != newSize;
        if (!firstTime) {
            List<PollMessageChoice> updated = this.currentPollMessage.choices == null ? Collections.emptyList() : this.currentPollMessage.choices;
            this.updateVotes(updated);
            ViewControllerHelper.showNode((Node)this);
            return;
        }
        this.tickerLiveData.removeListener(this.pollTickerListener);
        this.tickerLiveData.addListener(this.pollTickerListener);
        this.displayedPollId = pollId;
        this.displayedChoices = this.currentPollMessage.choices == null ? new ArrayList<PollMessageChoice>() : new ArrayList<PollMessageChoice>(this.currentPollMessage.choices);
        this.configureExpiration(this.currentPollMessage);
        this.getChildren().clear();
        this.buildUI();
        this.applyCss();
        this.layout();
        ViewControllerHelper.showNode((Node)this);
    }

    public void updateVotes(List<PollMessageChoice> updatedChoices) {
        if (this.displayedChoices == null || this.displayedChoices.isEmpty()) {
            return;
        }
        HashMap<Object, PollMessageChoice> byId = new HashMap<Object, PollMessageChoice>();
        for (PollMessageChoice existing : this.displayedChoices) {
            byId.put(existing.getItemId(), existing);
        }
        for (PollMessageChoice updated : updatedChoices) {
            PollMessageChoice existing = (PollMessageChoice)byId.get(updated.getItemId());
            if (existing == null) continue;
            existing.setVoteCount(updated.getVoteCount());
            existing.setSelected(updated.isSelected());
        }
    }

    public void reset() {
        this.displayedPollId = null;
        this.displayedChoices.clear();
        this.tickerLiveData.removeListener(this.pollTickerListener);
        this.displayedPollExpiration = Optional.empty();
        this.pollDisabled.unbind();
        this.pollDisabled.set(false);
        this.hasExpiration.set(false);
        this.nilCheckBox = null;
        this.nilLockActive.set(false);
        if (this.expirationLabel != null) {
            this.expirationLabel.textProperty().unbind();
            this.expirationLabel = null;
        }
        this.getChildren().clear();
        ViewControllerHelper.hideNode((Node)this);
    }

    private void buildUI() {
        Label question = new Label(this.currentPollMessage.getQuestion());
        question.getStyleClass().add((Object)"h1-bold");
        Label choicesLabel = new Label(ViewControllerHelper.getString("poll_choose_multiple_answers"));
        choicesLabel.getStyleClass().add((Object)"grey-text");
        choicesLabel.visibleProperty().bind((ObservableValue)this.hasMultipleChoices);
        choicesLabel.managedProperty().bind((ObservableValue)this.hasMultipleChoices);
        VBox choicesBox = new VBox(10.0);
        choicesBox.setPadding(new Insets(16.0, 0.0, 16.0, 0.0));
        if (this.currentPollMessage.choices == null || this.currentPollMessage.choices.isEmpty()) {
            choicesBox.getChildren().add((Object)new Label(ViewControllerHelper.getString("poll_no_options")));
        } else {
            Observable[] deps = (Observable[])this.displayedChoices.stream().map(PollMessageChoice::voteCountProperty).toArray(Observable[]::new);
            int sum = 0;
            for (int i = 0; i < this.displayedChoices.size(); ++i) {
                sum += this.displayedChoices.get(i).getVoteCount();
            }
            IntegerBinding totalVotesBinding = Bindings.createIntegerBinding(() -> this.displayedChoices.stream().mapToInt(PollMessageChoice::getVoteCount).sum(), (Observable[])deps);
            boolean multiple = this.currentPollMessage.isMultipleChoice();
            for (int i = 0; i < this.displayedChoices.size(); ++i) {
                PollMessageChoice option = this.displayedChoices.get(i);
                HBox line = new HBox(10.0);
                line.setAlignment(Pos.TOP_LEFT);
                CheckBox cb = new CheckBox();
                if (this.alignment.getHpos() == HPos.RIGHT) {
                    cb.getStyleClass().addAll((Object[])new String[]{"check-box-secondary"});
                }
                cb.getStyleClass().add((Object)"check-box-rounded");
                cb.selectedProperty().bindBidirectional((Property)option.selectedProperty());
                cb.setOnAction(e -> this.handleChoiceClicked(option));
                cb.setAlignment(Pos.CENTER);
                if (multiple) {
                    if (this.isNilChoice(option)) {
                        cb.disableProperty().bind((ObservableValue)this.pollDisabled.or((ObservableBooleanValue)this.userIsActiveProperty.not()));
                        this.nilCheckBox = cb;
                    } else {
                        cb.disableProperty().bind((ObservableValue)this.pollDisabled.or((ObservableBooleanValue)this.nilLockActive).or((ObservableBooleanValue)this.userIsActiveProperty.not()));
                    }
                } else {
                    cb.disableProperty().bind((ObservableValue)this.pollDisabled.or((ObservableBooleanValue)this.userIsActiveProperty.not()));
                }
                line.getChildren().add((Object)cb);
                String optionLabel = option.getLabel();
                if (this.isNilChoice(option)) {
                    optionLabel = ViewControllerHelper.getString("poll_none_of_these_answers");
                }
                Label textLabel = new Label(optionLabel);
                Label percentLabel = new Label();
                percentLabel.getStyleClass().add((Object)"grey-text");
                DoubleBinding percentBinding = Bindings.createDoubleBinding(() -> {
                    int total = totalVotesBinding.get();
                    if (total == 0) {
                        return 0.0;
                    }
                    return (double)option.getVoteCount() / (double)total;
                }, (Observable[])new Observable[]{totalVotesBinding, option.voteCountProperty()});
                percentLabel.textProperty().bind((ObservableValue)percentBinding.multiply(100).asString("%.0f%%"));
                Region spacer = new Region();
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                HBox topRow = new HBox(8.0, new Node[]{textLabel, spacer, percentLabel});
                topRow.setAlignment(Pos.CENTER_LEFT);
                HBox.setHgrow((Node)textLabel, (Priority)Priority.ALWAYS);
                ProgressBar bar = new ProgressBar();
                if (this.alignment.getHpos() == HPos.RIGHT) {
                    bar.getStyleClass().add((Object)"progress-bar-secondary");
                    bar.getStyleClass().add((Object)("progress-bar-secondary-" + (i + 1)));
                } else {
                    bar.getStyleClass().add((Object)("progress-bar-" + (i + 1)));
                }
                this.bindAnimatedProgress(bar, (ObservableNumberValue)percentBinding);
                bar.setPrefWidth(300.0);
                HBox.setHgrow((Node)bar, (Priority)Priority.ALWAYS);
                VBox box = new VBox(4.0, new Node[]{topRow, bar});
                line.getChildren().add((Object)box);
                choicesBox.getChildren().add((Object)line);
            }
            if (multiple && this.nilCheckBox != null) {
                this.nilCheckBox.selectedProperty().addListener((obs, wasSelected, isSelected) -> {
                    if (isSelected.booleanValue()) {
                        this.nilLockActive.set(true);
                        for (PollMessageChoice choice : this.displayedChoices) {
                            if (this.isNilChoice(choice)) continue;
                            choice.setSelected(false);
                        }
                    } else {
                        this.nilLockActive.set(false);
                    }
                });
            }
        }
        this.expirationLabel = new Label("");
        this.expirationLabel.getStyleClass().add((Object)"grey-text");
        Color frameColor = this.alignment.getHpos() == HPos.RIGHT ? Color.WHITE : Color.GREY;
        Node timer = FxIcons.icon(FxIcons.FRAME3((Paint)frameColor, (Paint)frameColor), 12.0, 12.0, 12.0, 12.0);
        HBox expirationBox = new HBox(10.0);
        expirationBox.setAlignment(Pos.CENTER_LEFT);
        expirationBox.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        expirationBox.visibleProperty().bind((ObservableValue)this.hasExpiration);
        expirationBox.managedProperty().bind((ObservableValue)this.hasExpiration);
        expirationBox.getChildren().addAll((Object[])new Node[]{timer, this.expirationLabel});
        VBox.setMargin((Node)choicesBox, (Insets)new Insets(0.0, 0.0, 16.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{question, choicesLabel, choicesBox, expirationBox});
    }

    private boolean isNilChoice(PollMessageChoice choice) {
        return UUID_NIL.equals(choice.getExternalIdentifier());
    }

    private void handleChoiceClicked(PollMessageChoice choice) {
        if (this.pollDisabled.get()) {
            return;
        }
        if (this.onChoiceClicked != null && this.currentPollMessage != null) {
            this.onChoiceClicked.accept(this.currentPollMessage, choice);
        }
    }

    private void onTick(Long now, Long old) {
        ViewControllerHelper.smartUIUpdate(() -> {
            this.updateControlsDisabled(now);
            this.updateExpirationLabel(now);
        });
    }

    private void updateControlsDisabled(Long now) {
        if (this.displayedPollExpiration.isEmpty()) {
            this.pollDisabled.set(false);
            return;
        }
        long exp = this.displayedPollExpiration.get();
        if (exp <= 0L) {
            this.pollDisabled.set(false);
            return;
        }
        this.pollDisabled.set(now >= exp);
    }

    private void updateExpirationLabel(Long now) {
        if (this.expirationLabel == null) {
            return;
        }
        if (!this.hasExpiration.get() || this.displayedPollExpiration.isEmpty()) {
            return;
        }
        long exp = this.displayedPollExpiration.get();
        long remainingMs = exp - now;
        if (remainingMs <= 0L) {
            this.expirationLabel.setText(ViewControllerHelper.getString("poll_ended"));
            return;
        }
        String formatted = DateUtils.formatDurationPlainText(remainingMs / 1000L);
        this.expirationLabel.setText(ViewControllerHelper.getString("poll_ends_in", formatted));
    }

    private void configureExpiration(PollMessage pollMessage) {
        this.displayedPollExpiration = pollMessage.getExpiration();
        this.hasExpiration.set(this.displayedPollExpiration.isPresent() && this.displayedPollExpiration.get() > 0L);
        this.hasMultipleChoices.set(pollMessage.isMultipleChoice());
        Long now = this.tickerLiveData.getValue();
        if (now == null) {
            now = System.currentTimeMillis();
        }
        this.updateControlsDisabled(now);
        this.updateExpirationLabel(now);
    }

    private void bindAnimatedProgress(ProgressBar bar, ObservableNumberValue targetProgress) {
        SimpleDoubleProperty animatedProgress = new SimpleDoubleProperty(0.0);
        bar.progressProperty().bind((ObservableValue)animatedProgress);
        animatedProgress.set(PollMessageView.clamp(targetProgress.doubleValue(), 0.0, 1.0));
        targetProgress.addListener((obs, oldVal, newVal) -> {
            double start = animatedProgress.get();
            double end = PollMessageView.clamp(newVal.doubleValue(), 0.0, 1.0);
            Timeline oldTimeline = (Timeline)bar.getProperties().get((Object)"pollProgressTimeline");
            if (oldTimeline != null) {
                oldTimeline.stop();
            }
            if (!this.enableAnimation) {
                animatedProgress.set(end);
                return;
            }
            if (Math.abs(end - start) < 0.001) {
                animatedProgress.set(end);
                return;
            }
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)animatedProgress, (Object)start)}), new KeyFrame(POLL_PROGRESS_ANIMATION_DURATION, new KeyValue[]{new KeyValue((WritableValue)animatedProgress, (Object)end, Interpolator.EASE_BOTH)})});
            bar.getProperties().put((Object)"pollProgressTimeline", (Object)timeline);
            timeline.play();
        });
    }

    private static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static class PollChoiceLine
    extends VBox {
        public final HBox lineContainer = new HBox();
        public final CheckBox checkBox = new CheckBox();
        public final HBox topRow = new HBox();
        public final Label textLabel = new Label();
        public final Label percentageLabel = new Label();
        public final ProgressBar progressBar = new ProgressBar();
        ObservableNumberValue targetProgress;

        public PollChoiceLine(double v) {
            super(v);
            this.setPadding(new Insets(16.0, 0.0, 16.0, 0.0));
        }
    }
}

