/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.fx.custom_components.file.HighDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.LowDefLinkPreview;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.UserMessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.livedata.LiveData;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public class OutboundMessageView
extends UserMessageView {
    private OutboundMessageGenerated.Status currentOutboundStatus = null;
    private OwnedMessageGenerated.Status currentOwnedStatus = null;
    private final MessageStatusView statusView = new MessageStatusView("icon-xxsmall", 2.7);

    public OutboundMessageView(LiveData<Long> tickerLiveData, StringProperty searchText, DoubleExpression maxWidthBinding, DoubleExpression heightBinding, LowDefLinkPreview.Outbound lowDefLinkPreview, HighDefLinkPreview.Outbound highDefLinkPreview) {
        super(Pos.TOP_RIGHT, tickerLiveData, searchText, maxWidthBinding, heightBinding, lowDefLinkPreview, highDefLinkPreview);
        ViewControllerHelper.checkUIThread();
        this.getStyleClass().add((Object)"message-content-outbound");
        this.statusLabel.getStyleClass().add((Object)"return-receipt");
        HBox.setMargin((Node)this.statusView, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
        this.statusHBox.getChildren().add((Object)this.statusView);
    }

    public synchronized void setStatus(OutboundMessageGenerated.Status status) {
        ViewControllerHelper.checkUIThread();
        if (status == this.currentOutboundStatus) {
            return;
        }
        if (status == OutboundMessageGenerated.Status.FAILED) {
            this.setStatusLabel(Optional.of(ViewControllerHelper.getString("message_view_message_status_unsent")), Optional.empty());
        } else if (status == OutboundMessageGenerated.Status.UNDELIVERED) {
            this.setStatusLabel(Optional.of(ViewControllerHelper.getString("message_view_message_status_undelivered")), Optional.empty());
        } else {
            this.setStatusLabel(Optional.empty(), Optional.empty());
        }
        this.statusView.update(status);
        this.currentOutboundStatus = status;
        this.currentOwnedStatus = null;
    }

    public synchronized void setStatus(OwnedMessageGenerated.Status status) {
        ViewControllerHelper.checkUIThread();
        if (status == this.currentOwnedStatus) {
            return;
        }
        this.statusView.update(MessageStatusView.Icon.SENT_FROM_OTHER_DEVICE);
        this.currentOwnedStatus = status;
        this.currentOutboundStatus = null;
    }

    @Override
    public void setAvailableActions(Set<MessageView.Action> actions) {
        super.setAvailableActions(actions.stream().filter(MessageView.Action::showButtonInOutboundMessages).collect(Collectors.toSet()));
    }
}

