/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageEditionState;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.HighDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.ImagePreview;
import io.olvid.windows.messenger.fx.custom_components.file.LowDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewAttachmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageListCellModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.AbstractRepliedUserMessageRepliedToUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.ContentMessageViewUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.UserMessageView;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public abstract class UserMessageViewUpdater<Message extends AbstractUserMessageGenerated<Message>, MessageInterface extends AbstractUserMessageGenerated.Interface<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, MessageMetadata extends AbstractMessageMetadataGenerated<MessageMetadata>, Attachment extends AbstractAttachmentGenerated<Attachment>, Reaction extends AbstractReactionGenerated<Reaction>>
extends ContentMessageViewUpdater<Message, MessageInterface, EphemeralInfo, MessageMetadata, ContactRef, ContactInfoLiveData.ContactInfoState> {
    private final MessageListCellModel model;
    private final AbstractRepliedUserMessageRepliedToUpdater<InboundMessage, InboundMessageGenerated.Interface, InboundMessageEphemeralInfo, InboundMessageMetadata> repliedInboundMessageBodyUpdater;
    private final AbstractRepliedUserMessageRepliedToUpdater<OutboundMessage, OutboundMessageGenerated.Interface, OutboundMessageEphemeralInfo, OutboundMessageMetadata> repliedOutboundMessageBodyUpdater;
    private final AbstractRepliedUserMessageRepliedToUpdater<OwnedMessage, OwnedMessageGenerated.Interface, OwnedMessageEphemeralInfo, OwnedMessageMetadata> repliedOwnedMessageBodyUpdater;
    private final MapLiveData<Id<Message>, List<Attachment>> attachmentsDispatcher;
    private final MapLiveData<Id<Message>, List<Reaction>> reactionsDispatcher;
    private boolean attachmentsListenerIsPlugged = false;
    private boolean reactionsListenerIsPlugged = false;
    private Attachment linkPreviewAttachment = null;
    private LinkPreviewState linkPreviewState = LinkPreviewState.UNKNOWN;
    private final MapLiveData<Id<PollMessage>, Optional<PollMessage>> pollMessageDispatcher;
    private final MapLiveData<Id<PollMessage>, List<PollMessageVote>> pollVotesDispatcher;
    private final LiveDataListener<List<Attachment>> attachmentListChangeListener = this::attachmentListChangeListener;
    private final LiveDataListener<List<Reaction>> reactionsListChangeListener = this::reactionsListChangeListener;
    private final LiveDataListener<Optional<MessageRefInfo>> messageRefListener = this::messageRefListener;
    private Optional<Id<MessageRef>> messageRefListenerKey = Optional.empty();
    private final LiveDataListener<Optional<PollMessage>> pollMessageChangeListener = this::pollMessageChangeListener;
    private final LiveDataListener<List<PollMessageVote>> pollVotesChangeListener = this::pollMessageVotesChangeListener;
    private Optional<Id<PollMessage>> pollListenerKey = Optional.empty();
    protected final List<PreviewAttachmentController<Attachment, ImagePreview, ?>> imagePreviewControllers = new ArrayList();
    protected final List<PreviewAttachmentController<Attachment, FilePreview.FileAttachmentPreview, ?>> filePreviewControllers = new ArrayList();
    protected final PreviewAttachmentController<Attachment, LowDefLinkPreview, ?> lowDefLinkPreviewController;
    protected final PreviewAttachmentController<Attachment, HighDefLinkPreview, ?> highDefLinkPreviewController;
    private PollMessage displayedPollMessage;
    private Optional<Id<PollMessage>> boundPollId = Optional.empty();

    protected abstract <P extends PreviewUtils.Preview> PreviewAttachmentController<Attachment, P, ?> makePreviewAttachment(P var1);

    protected abstract ImagePreview makeImagePreview();

    protected PreviewAttachmentController<Attachment, ImagePreview, ?> makeImagePreviewController(Attachment attachment) {
        ImagePreview imagePreview = this.makeImagePreview();
        PreviewAttachmentController<Attachment, ImagePreview, ?> controller = this.makePreviewAttachment(imagePreview);
        controller.update(attachment);
        return controller;
    }

    protected abstract FilePreview.FileAttachmentPreview makeFileAttachmentPreview();

    protected PreviewAttachmentController<Attachment, FilePreview.FileAttachmentPreview, ?> makeFilePreviewController(Attachment attachment) {
        FilePreview.FileAttachmentPreview filePreview = this.makeFileAttachmentPreview();
        PreviewAttachmentController<Attachment, FilePreview.FileAttachmentPreview, ?> controller = this.makePreviewAttachment(filePreview);
        controller.update(attachment);
        return controller;
    }

    protected abstract Id<Message> getMessageId(Attachment var1);

    protected abstract Class<Message> getClazz();

    public UserMessageViewUpdater(MessageListCellModel model, UserMessageView view, MapLiveData<Id<ContactRef>, ContactInfoLiveData.ContactInfoState> senderObserver, MapLiveData<Id<EphemeralInfo>, Optional<EphemeralInfo>> ephemeralInfoDispatcher, MapLiveData<Id<Message>, List<MessageMetadata>> messageMetadataDispatcher, MapLiveData<Id<Message>, List<Attachment>> attachmentsDispatcher, MapLiveData<Id<Message>, List<Reaction>> reactionsDispatcher, MapLiveData<Id<PollMessage>, Optional<PollMessage>> pollMessageDispatcher, MapLiveData<Id<PollMessage>, List<PollMessageVote>> pollMessageVoteDispatcher) {
        super(view, senderObserver, Optional.of(ephemeralInfoDispatcher), messageMetadataDispatcher);
        this.model = model;
        this.attachmentsDispatcher = attachmentsDispatcher;
        this.reactionsDispatcher = reactionsDispatcher;
        this.pollMessageDispatcher = pollMessageDispatcher;
        this.pollVotesDispatcher = pollMessageVoteDispatcher;
        this.repliedInboundMessageBodyUpdater = new AbstractRepliedUserMessageRepliedToUpdater<InboundMessage, InboundMessageGenerated.Interface, InboundMessageEphemeralInfo, InboundMessageMetadata>(this, view, senderObserver, model.getInboundMessageMetadataLiveDataPerMessage()){

            @Override
            protected void updateSenderView(ContactInfoLiveData.ContactInfoState senderState) {
                ViewControllerHelper.checkUIThread();
                ((UserMessageView)this.view).showReplyToContactName(senderState);
            }
        };
        this.repliedOutboundMessageBodyUpdater = new AbstractRepliedUserMessageRepliedToUpdater<OutboundMessage, OutboundMessageGenerated.Interface, OutboundMessageEphemeralInfo, OutboundMessageMetadata>(this, view, senderObserver, model.getOutboundMessageMetadataLiveDataPerMessage()){

            @Override
            protected void doUpdate(Optional<Id<ContactRef>> senderRef) {
                ViewControllerHelper.checkUIThread();
                super.doUpdate(senderRef);
                ((UserMessageView)this.view).showReplyToOwnedIdentityName();
            }
        };
        this.repliedOwnedMessageBodyUpdater = new AbstractRepliedUserMessageRepliedToUpdater<OwnedMessage, OwnedMessageGenerated.Interface, OwnedMessageEphemeralInfo, OwnedMessageMetadata>(this, view, senderObserver, model.getOwnedMessageMetadataLiveDataPerMessage()){

            @Override
            protected void doUpdate(Optional<Id<ContactRef>> senderRef) {
                ViewControllerHelper.checkUIThread();
                super.doUpdate(senderRef);
                ((UserMessageView)this.view).showReplyToOwnedIdentityName();
            }
        };
        this.lowDefLinkPreviewController = this.makePreviewAttachment(view.lowDefLinkPreview);
        this.highDefLinkPreviewController = this.makePreviewAttachment(view.highDefLinkPreview);
        this.observeEditedMessage();
    }

    private void updateEditionMode(Optional<MessageEditionState> editionStateOpt) {
        ViewControllerHelper.checkUIThread();
        if (editionStateOpt.isPresent() && this.getClazz() != editionStateOpt.get().getItemId().clazz) {
            return;
        }
        if (this.currentMessage == null || editionStateOpt.isEmpty() || !editionStateOpt.get().getItemId().equals(((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId())) {
            ((UserMessageView)this.view).cancelEdition();
            ((UserMessageView)this.view).disableHover(false);
            return;
        }
        MessageEditionState editionState = editionStateOpt.get();
        if (!((UserMessageView)this.view).isEditionActive()) {
            ((UserMessageView)this.view).activateEdition(((AbstractUserMessageGenerated.Interface)this.currentMessage).getBody().orElse(""), editionState.getModifiedBody(), editionState, this.model::doEdition);
        }
    }

    public void updateImagesAttachmentsView(List<? extends Attachment> attachments) {
        ViewControllerHelper.checkUIThread();
        if (attachments.isEmpty()) {
            ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).imageGrid);
        }
        List<Attachment> limitedAttachments = attachments.subList(0, Math.min(attachments.size(), 4));
        ObservableList children = ((UserMessageView)this.view).imageGrid.getChildren();
        if (!limitedAttachments.isEmpty()) {
            this.logger.trace(String.format("UserMessageViewUpdater::updateImagesAttachmentsView \n current message id : %s\n children size : %s\n controllers size : %s\nvalues : %s", ((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), children.size(), this.imagePreviewControllers.size(), limitedAttachments));
        }
        DiffUtils.applyChanges(limitedAttachments, (ObservableList<Node>)children, this.imagePreviewControllers, this::makeImagePreviewController);
        ((UserMessageView)this.view).configureImagePreviews(attachments.size());
    }

    private void configureLinkPreview() {
        switch (((AbstractUserMessageGenerated.Interface)this.currentMessage).getLinkPreviewKind()) {
            case NONE: {
                this.linkPreviewState = LinkPreviewState.NO_LINK_PREVIEW;
                ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).linkPreviewContainer);
                return;
            }
            case DOWNLOADING: {
                this.linkPreviewState = LinkPreviewState.UNKNOWN;
                ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).linkPreviewContainer);
                return;
            }
            case PARTIAL: {
                ViewControllerHelper.showNode((Node)((UserMessageView)this.view).lowDefLinkPreview);
                ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).highDefLinkPreview);
                this.linkPreviewState = LinkPreviewState.LOW_DEF;
                break;
            }
            case FULL: {
                Optional<Double> linkPreviewImageWidth = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getLinkPreviewImageWidth();
                if (linkPreviewImageWidth.isEmpty()) {
                    ViewControllerHelper.showNode((Node)((UserMessageView)this.view).lowDefLinkPreview);
                    ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).highDefLinkPreview);
                    this.linkPreviewState = LinkPreviewState.LOW_DEF;
                    break;
                }
                double width = linkPreviewImageWidth.get();
                if (width > 400.0) {
                    ViewControllerHelper.showNode((Node)((UserMessageView)this.view).highDefLinkPreview);
                    ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).lowDefLinkPreview);
                    this.linkPreviewState = LinkPreviewState.HIGH_DEF;
                    break;
                }
                ViewControllerHelper.showNode((Node)((UserMessageView)this.view).lowDefLinkPreview);
                ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).highDefLinkPreview);
                this.linkPreviewState = LinkPreviewState.LOW_DEF;
            }
        }
        Optional<String> linkPreviewDescription = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getLinkPreviewDescription();
        if (((UserMessageView)this.view).lowDefLinkPreview.isVisible()) {
            ((UserMessageView)this.view).lowDefLinkPreview.setDescription(linkPreviewDescription.orElse(""));
        } else if (((UserMessageView)this.view).highDefLinkPreview.isVisible()) {
            ((UserMessageView)this.view).highDefLinkPreview.setDescription(linkPreviewDescription.orElse(""));
        }
        ViewControllerHelper.showNode((Node)((UserMessageView)this.view).linkPreviewContainer);
        ((UserMessageView)this.view).updateCorners();
    }

    private void updateLinkPreview(List<? extends Attachment> attachments) {
        ViewControllerHelper.checkUIThread();
        if (attachments.size() != 1) {
            return;
        }
        AbstractAttachmentGenerated attachment = (AbstractAttachmentGenerated)attachments.get(0);
        switch (this.linkPreviewState.ordinal()) {
            case 1: {
                break;
            }
            case 0: {
                this.linkPreviewAttachment = attachment;
                break;
            }
            case 2: {
                this.lowDefLinkPreviewController.update(attachment);
                break;
            }
            case 3: {
                this.highDefLinkPreviewController.update(attachment);
            }
        }
    }

    public void cleanLinkPreview() {
        this.linkPreviewState = LinkPreviewState.UNKNOWN;
        ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).linkPreviewContainer);
        ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).lowDefLinkPreview);
        ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).highDefLinkPreview);
        this.lowDefLinkPreviewController.dispose();
        this.highDefLinkPreviewController.dispose();
    }

    public void updateFileAttachmentsView(List<? extends Attachment> attachments) {
        ViewControllerHelper.checkUIThread();
        if (attachments.isEmpty()) {
            ViewControllerHelper.hideNode((Node)((UserMessageView)this.view).attachmentVBox);
        }
        ObservableList children = ((UserMessageView)this.view).attachmentVBox.getChildren();
        DiffUtils.applyChanges(attachments, (ObservableList<Node>)children, this.filePreviewControllers, this::makeFilePreviewController);
        if (!attachments.isEmpty()) {
            ViewControllerHelper.showNode((Node)((UserMessageView)this.view).attachmentVBox);
        }
    }

    @Override
    protected void updateContentView(Optional<String> content, boolean edited, boolean enableSearch) {
        ViewControllerHelper.checkUIThread();
        ((UserMessageView)this.view).setText(content);
        ((UserMessageView)this.view).setEdited(edited);
    }

    @Override
    protected void updateSenderView(ContactInfoLiveData.ContactInfoState contactInfoState) {
        ViewControllerHelper.checkUIThread();
    }

    @Override
    protected void clean(MessageInterface lastMessage) {
        ViewControllerHelper.checkUIThread();
        Optional messageEditionState = (Optional)this.model.getMessageEditionState().get();
        if (messageEditionState.isPresent() && ((MessageEditionState)messageEditionState.get()).getItemId().equals(lastMessage.getItemId())) {
            Optional<String> text = ((UserMessageView)this.view).editMessageView.getText();
            if (text.isPresent()) {
                ((MessageEditionState)messageEditionState.get()).setModifyBody(text.get());
            }
            ((UserMessageView)this.view).cancelEdition();
        }
        super.clean(lastMessage);
        if (this.attachmentsListenerIsPlugged) {
            this.attachmentsDispatcher.removeListener((Id<Message>)lastMessage.getItemId(), this.attachmentListChangeListener);
            this.attachmentsListenerIsPlugged = false;
        }
        this.repliedInboundMessageBodyUpdater.clean();
        this.repliedOutboundMessageBodyUpdater.clean();
        this.repliedOwnedMessageBodyUpdater.clean();
        if (this.reactionsListenerIsPlugged) {
            this.reactionsDispatcher.removeListener((Id<Message>)lastMessage.getItemId(), this.reactionsListChangeListener);
            this.reactionsListenerIsPlugged = false;
        }
        this.cleanLinkPreview();
        this.removeMessageRefListener();
        this.updateAttachments(List.of());
        ((UserMessageView)this.view).updateSenderView(new ContactInfoLiveData.ContactInfoState.Computing());
        this.removePollListeners();
        ((UserMessageView)this.view).resetPollMessageView();
        this.boundPollId = Optional.empty();
        this.displayedPollMessage = null;
    }

    @Override
    protected void doUpdate(Optional<Id<ContactRef>> senderRef) {
        Optional<Id<MessageRef>> replyToId;
        ViewControllerHelper.checkUIThread();
        super.doUpdate(senderRef);
        if (this.consecutiveWithNext) {
            ((UserMessageView)this.view).setTimestamp(Optional.empty());
        } else {
            ((UserMessageView)this.view).setTimestamp(Optional.of(((AbstractUserMessageGenerated.Interface)this.currentMessage).getTimestamp()));
        }
        ((UserMessageView)this.view).setForwarded(((AbstractUserMessageGenerated.Interface)this.currentMessage).isForwarded());
        boolean hasAttachments = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getTotalAttachmentCount() > 0;
        boolean isWiped = this.isWiped((AbstractUserMessageGenerated.Interface)this.currentMessage);
        if (hasAttachments && !isWiped) {
            switch (this.linkPreviewState.ordinal()) {
                case 0: {
                    this.configureLinkPreview();
                    if (this.linkPreviewAttachment == null || !this.linkPreviewState.isConfigured()) break;
                    this.updateLinkPreview(List.of(this.linkPreviewAttachment));
                    this.linkPreviewAttachment = null;
                    break;
                }
                case 1: {
                    break;
                }
            }
            if (!this.attachmentsListenerIsPlugged) {
                int imageCount = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getImageCount();
                int fileAttachmentsCount = this.getFileAttachmentCount();
                this.updateImagesAttachmentsView(Collections.nCopies(imageCount, null));
                ((UserMessageView)this.view).showAttachmentFlowPane(fileAttachmentsCount > 0);
                this.updateFileAttachmentsView(Collections.nCopies(fileAttachmentsCount, null));
                this.attachmentsDispatcher.addListener((Id<Message>)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), this.attachmentListChangeListener);
                this.attachmentsListenerIsPlugged = true;
            }
        } else {
            if (this.attachmentsListenerIsPlugged) {
                this.attachmentsDispatcher.removeListener((Id<Message>)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), this.attachmentListChangeListener);
                this.attachmentsListenerIsPlugged = false;
            }
            this.updateImagesAttachmentsView(Collections.emptyList());
            this.updateFileAttachmentsView(Collections.emptyList());
            this.cleanLinkPreview();
        }
        if (isWiped) {
            if (this.reactionsListenerIsPlugged) {
                this.reactionsDispatcher.removeListener((Id<Message>)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), this.reactionsListChangeListener);
                this.reactionsListenerIsPlugged = false;
            }
        } else if (!this.reactionsListenerIsPlugged) {
            this.reactionsDispatcher.addListener((Id<Message>)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), this.reactionsListChangeListener);
            this.reactionsListenerIsPlugged = true;
        }
        if ((replyToId = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getReplyToId()).isEmpty()) {
            ((UserMessageView)this.view).removeReplyTo();
            this.removeMessageRefListener();
        } else {
            this.addMessageRefListener(replyToId.get());
        }
        this.updateEditionMode((Optional)this.model.getMessageEditionState().get());
    }

    private boolean isWiped(MessageInterface message) {
        if (message == null) {
            return false;
        }
        return switch (message.getWipeStatus()) {
            default -> throw new MatchException(null, null);
            case AbstractUserMessageGenerated.WipeStatus.NONE, AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ -> false;
            case AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED, AbstractUserMessageGenerated.WipeStatus.WIPED -> true;
        };
    }

    private void updateAttachments(List<Attachment> attachments) {
        ViewControllerHelper.checkUIThread();
        if (this.currentMessage == null) {
            this.updateImagesAttachmentsView(Collections.emptyList());
            this.updateFileAttachmentsView(Collections.emptyList());
            return;
        }
        if (attachments.isEmpty() && ((AbstractUserMessageGenerated.Interface)this.currentMessage).getTotalAttachmentCount() > 0) {
            return;
        }
        if (attachments.isEmpty()) {
            this.updateImagesAttachmentsView(Collections.emptyList());
            this.updateFileAttachmentsView(Collections.emptyList());
            return;
        }
        AbstractAttachmentGenerated attachment = (AbstractAttachmentGenerated)attachments.get(0);
        Id<Message> messageId = this.getMessageId(attachment);
        if (!messageId.equals(((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId())) {
            return;
        }
        List<AbstractAttachmentGenerated> imageAttachments = attachments.stream().filter(a -> PreviewUtils.toFileExtension(a) == FileExtension.IMAGE).toList();
        List<AbstractAttachmentGenerated> fileAttachments = attachments.stream().filter(a -> PreviewUtils.toFileExtension(a).isFile()).toList();
        List<AbstractAttachmentGenerated> linkAttachments = attachments.stream().filter(a -> PreviewUtils.toFileExtension(a) == FileExtension.LINK).toList();
        this.updateImagesAttachmentsView(imageAttachments);
        this.updateFileAttachmentsView(fileAttachments);
        this.updateLinkPreview(linkAttachments);
    }

    private void attachmentListChangeListener(List<Attachment> newValue, List<Attachment> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> this.updateAttachments(newValue));
    }

    private void reactionsListChangeListener(List<Reaction> newValue, List<Reaction> oldValue) {
        if (newValue == null) {
            return;
        }
        if (oldValue != null && DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> ((UserMessageView)this.view).updateReaction(newValue));
    }

    private void addMessageRefListener(Id<MessageRef> messageRefId) {
        if (this.messageRefListenerKey.isEmpty()) {
            ((UserMessageView)this.view).showEmptyReplyTo();
            this.model.addMessageRefListener(messageRefId, this.messageRefListener);
            this.messageRefListenerKey = Optional.of(messageRefId);
        } else assert (Objects.equals(this.messageRefListenerKey.get(), messageRefId));
    }

    private void removeMessageRefListener() {
        if (this.messageRefListenerKey.isPresent()) {
            this.model.removeMessageRefListener(this.messageRefListenerKey.get(), this.messageRefListener);
            this.messageRefListenerKey = Optional.empty();
        }
    }

    private void configureReplyTo(Optional<MessageRefInfo> replyTo) {
        if (this.currentMessage == null) {
            ((UserMessageView)this.view).removeReplyTo();
            return;
        }
        if (replyTo.isPresent()) {
            MessageRefInfo messageRef = replyTo.get();
            Optional<Id<MessageRef>> currentReplyToOpt = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getReplyToId();
            if (currentReplyToOpt.isEmpty()) {
                ((UserMessageView)this.view).removeReplyTo();
                return;
            }
            if (messageRef.inboundMessage().isPresent()) {
                InboundMessage inboundMessage = messageRef.inboundMessage().get();
                this.repliedInboundMessageBodyUpdater.update(inboundMessage, false, false, Optional.of(inboundMessage.getSenderId()));
            } else if (messageRef.outboundMessage().isPresent()) {
                OutboundMessage outboundMessage = messageRef.outboundMessage().get();
                this.repliedOutboundMessageBodyUpdater.update(outboundMessage, false, false, this.senderId);
            } else if (messageRef.ownedMessage().isPresent()) {
                OwnedMessage ownedMessage = messageRef.ownedMessage().get();
                this.repliedOwnedMessageBodyUpdater.update(ownedMessage, false, false, this.senderId);
            } else {
                ((UserMessageView)this.view).updateReplyToToDeletedOrNotReceived(messageRef.messageHasBeenReceived());
            }
        } else {
            ((UserMessageView)this.view).removeReplyTo();
        }
    }

    private void messageRefListener(Optional<MessageRefInfo> newValue, Optional<MessageRefInfo> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        if (this.currentMessage == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.configureReplyTo(newValue));
    }

    private void observeEditedMessage() {
        this.model.getMessageEditionState().addListener((obv, oldState, newState) -> ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.smartUIUpdate(() -> this.updateEditionMode((Optional<MessageEditionState>)newState))));
    }

    private void pollMessageChangeListener(Optional<PollMessage> newValue, Optional<PollMessage> oldValue) {
        if (this.currentMessage == null) {
            return;
        }
        if (newValue.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(((UserMessageView)this.view)::hidePollMessageView);
            return;
        }
        Object expectedMsgId = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId();
        Optional<Id<PollMessage>> expectedPollIdOpt = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getPollMessageId();
        AsyncTaskExecutor.submitTask(() -> this.lambda$pollMessageChangeListener$10(newValue, (Id)expectedMsgId, expectedPollIdOpt));
    }

    private void pollMessageVotesChangeListener(List<PollMessageVote> newVotes, List<PollMessageVote> oldVotes) {
        if (newVotes == null) {
            return;
        }
        if (oldVotes != null && DiffUtils.areContentTheSame(newVotes, oldVotes)) {
            return;
        }
        if (this.currentMessage == null || ((AbstractUserMessageGenerated.Interface)this.currentMessage).getPollMessageId().isEmpty()) {
            return;
        }
        Id<PollMessage> pollId = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getPollMessageId().get();
        AsyncTaskExecutor.submitTask(() -> {
            Id<OwnedIdentity> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityId().get();
            IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(ownedIdentity);
            try {
                PollMessage pollMessage = DbManager.getInstance().getPollMessageDao().getAndPopulateOptionVotesWithSender(pollId, (Id<IdentityRef>)identityRef.getItemId());
                List<Object> updatedChoices = pollMessage.choices == null ? Collections.emptyList() : pollMessage.choices;
                ViewControllerHelper.smartUIUpdate(() -> ((UserMessageView)this.view).updatePollVoteMessageView(updatedChoices));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void configurePollMessage(PollMessage pollMessage, boolean userIsActive) {
        this.displayedPollMessage = pollMessage;
        ((UserMessageView)this.view).updatePollMessageView(this.displayedPollMessage, userIsActive);
        ((UserMessageView)this.view).updatePollVoteMessageView(pollMessage.choices);
        ((UserMessageView)this.view).showPollMessageView();
        NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.KEEP_PINNED_IF_BOTTOM, null));
    }

    private void addPollListeners(Id<PollMessage> pollId) {
        if (this.pollListenerKey.isPresent() && !this.pollListenerKey.get().equals(pollId)) {
            this.removePollListeners();
        }
        if (this.pollListenerKey.isEmpty()) {
            this.pollMessageDispatcher.addListener(pollId, this.pollMessageChangeListener);
            this.pollVotesDispatcher.addListener(pollId, this.pollVotesChangeListener);
            this.pollListenerKey = Optional.of(pollId);
        }
    }

    private void removePollListeners() {
        if (this.pollListenerKey.isPresent()) {
            Id<PollMessage> oldId = this.pollListenerKey.get();
            this.pollMessageDispatcher.removeListener(oldId, this.pollMessageChangeListener);
            this.pollVotesDispatcher.removeListener(oldId, this.pollVotesChangeListener);
            this.pollListenerKey = Optional.empty();
        }
    }

    private /* synthetic */ void lambda$pollMessageChangeListener$10(Optional newValue, Id expectedMsgId, Optional expectedPollIdOpt) {
        Id<OwnedIdentity> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityId().get();
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(ownedIdentity);
        Boolean userIsActive = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().isActive();
        try {
            PollMessage pollMessage = DbManager.getInstance().getPollMessageDao().getAndPopulateOptionVotesWithSender((Id<PollMessage>)((PollMessage)newValue.get()).getItemId(), (Id<IdentityRef>)identityRef.getItemId());
            ViewControllerHelper.smartUIUpdate(() -> {
                if (this.currentMessage == null) {
                    return;
                }
                if (!((Id)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId()).equals(expectedMsgId)) {
                    return;
                }
                if (expectedPollIdOpt.isEmpty()) {
                    return;
                }
                if (((AbstractUserMessageGenerated.Interface)this.currentMessage).getPollMessageId().isEmpty()) {
                    return;
                }
                if (!((AbstractUserMessageGenerated.Interface)this.currentMessage).getPollMessageId().get().equals(expectedPollIdOpt.get())) {
                    return;
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum LinkPreviewState {
        UNKNOWN,
        NO_LINK_PREVIEW,
        LOW_DEF,
        HIGH_DEF;


        public boolean isConfigured() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1, 2, 3 -> true;
            };
        }
    }
}

