/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.MessageViewUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import java.util.EnumSet;
import java.util.Optional;

public abstract class EphemerableMessageUpdater<Message extends AbstractMessageGenerated<Message>, MessageInterface extends AbstractMessageGenerated.Interface<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, Sender, SenderInfo, View extends MessageView<?>>
extends MessageViewUpdater<Message, MessageInterface, Sender, SenderInfo, View> {
    protected final LiveDataListener<Optional<EphemeralInfo>> ephemeralInfoChangeListener = this::ephemeralInfoChangeListener;
    protected final Optional<MapLiveData<Id<EphemeralInfo>, Optional<EphemeralInfo>>> ephemeralInfoDispatcher;
    protected Optional<Id<EphemeralInfo>> ephemeralInfoId = Optional.empty();
    public EnumSet<MessageView.Action> availableActions = EnumSet.noneOf(MessageView.Action.class);

    public EphemerableMessageUpdater(View view, MapLiveData<Id<Sender>, SenderInfo> senderObserver, Optional<MapLiveData<Id<EphemeralInfo>, Optional<EphemeralInfo>>> ephemeralInfoDispatcher) {
        super(view, senderObserver);
        this.ephemeralInfoDispatcher = ephemeralInfoDispatcher;
    }

    @Override
    protected void clean(MessageInterface lastMessage) {
        super.clean(lastMessage);
        if (this.ephemeralInfoDispatcher.isPresent() && this.ephemeralInfoId.isPresent()) {
            this.ephemeralInfoDispatcher.get().removeListener(this.ephemeralInfoId.get(), this.ephemeralInfoChangeListener);
            this.ephemeralInfoId = Optional.empty();
        }
    }

    @Override
    protected void doUpdate(Optional<Id<Sender>> senderRef) {
        Optional<Id<EphemeralInfo>> messageEphemeralInfoId = this.getEphemeralInfoId();
        if (this.ephemeralInfoDispatcher.isPresent()) {
            if (messageEphemeralInfoId.isPresent() && this.ephemeralInfoId.isEmpty()) {
                this.ephemeralInfoDispatcher.get().addListener(messageEphemeralInfoId.get(), this.ephemeralInfoChangeListener);
                this.ephemeralInfoId = messageEphemeralInfoId;
            }
            if (messageEphemeralInfoId.isEmpty()) {
                this.updateEphemeralInfo(Optional.empty());
            }
        }
        super.doUpdate(senderRef);
    }

    protected void ephemeralInfoChangeListener(Optional<EphemeralInfo> newValue, Optional<EphemeralInfo> oldValue) {
        ViewControllerHelper.checkNotUIThread();
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            Optional<Id> newEphemeralInfoId;
            if (this.currentMessage == null) {
                return;
            }
            Optional<Id<EphemeralInfo>> messageEphemeralInfoId = this.getEphemeralInfoId();
            if (messageEphemeralInfoId.equals(newEphemeralInfoId = newValue.map(AbstractTableGenerated::getItemId))) {
                this.updateEphemeralInfo(newValue);
            }
        });
    }

    protected void updateEphemeralInfo(Optional<EphemeralInfo> ephemeralInfo) {
        this.view.updateEphemeralInfo(System.currentTimeMillis(), ephemeralInfo);
        this.updateAvailableActions(ephemeralInfo);
    }

    protected abstract EnumSet<MessageView.Action> getAvailableActions(Optional<EphemeralInfo> var1);

    protected void updateAvailableActions(Optional<EphemeralInfo> ephemeralInfo) {
        EnumSet<MessageView.Action> availableActions = this.getAvailableActions(ephemeralInfo);
        this.availableActions.clear();
        this.availableActions.addAll(availableActions);
        this.view.setAvailableActions(availableActions);
    }

    protected abstract Optional<Id<EphemeralInfo>> getEphemeralInfoId();
}

