/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.SelectableDiscussionListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ScrollbarOverlayHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalListSelectionView;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class ForwardMessageModalController
extends BaseModalController {
    public static final double BOTTOM_MARGIN = 70.0;
    private final ListPanelSelectModel<DiscussionInfoWithState> selectModel;
    private final AbstractUserMessageGenerated<?> message;
    private final StackPane container = new StackPane();
    private final ModalListSelectionView modalListSelctionView;
    private final StandardPanelListController<DiscussionInfoWithState> discussionListViewController;

    public ForwardMessageModalController(AbstractUserMessageGenerated<?> message) {
        this.message = message;
        LiveData discussionLiveData = LiveDataFactory.switchMap(SelectedOwnedIdentitySingleton.getInstance().currentOwnedIdentityInfo, ownedIdentity -> ownedIdentity.map(ownedIdentityInfo -> LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getDiscussionDao().getContactOrGroupDiscussions(ownedIdentityInfo.genId()), List.of(Discussion.class))).orElse(null));
        LiveData discussions = MapLiveData.list(discussionLiveData, Function.identity(), DbCache.getInstance().discussionInfoWithStateMapLiveData, DiscussionInfoWithState::empty);
        this.discussionListViewController = StandardPanelListController.builder().withLiveData(discussions).withDataClass(DiscussionInfoWithState.class).withCellFactory((Callback<ListView<DiscussionInfoWithState>, AbstractListCell<DiscussionInfoWithState>>)((Callback)param -> {
            SelectableDiscussionListCell<DiscussionInfoWithState> listCell = new SelectableDiscussionListCell<DiscussionInfoWithState>(DiscussionInfoWithState::info);
            listCell.prefWidthProperty().bind((ObservableValue)param.widthProperty());
            listCell.setMaxWidth(Double.NEGATIVE_INFINITY);
            listCell.setMinWidth(Double.NEGATIVE_INFINITY);
            return listCell;
        })).withFixBottomMargin(Optional.of(70.0)).defaultComparator().setFilter(state -> {
            if (state == null) {
                return false;
            }
            return state.canPostMessage();
        }).setSearchPredicate((info, pattern) -> ListItemSearchHelper.discussionSearchPredicate(info.info(), pattern)).withMultipleSelection().withoutButton().build();
        this.selectModel = this.discussionListViewController.getSelectionModel();
        ViewControllerHelper.smartUIUpdate(() -> {
            this.discussionListViewController.getListView().setFixedCellSize(70.0);
            this.discussionListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        });
        this.modalListSelctionView = new ModalListSelectionView((Node)this.discussionListViewController.getLayout());
        this.modalListSelctionView.title.setText(ViewControllerHelper.getString("forward_to"));
        this.modalListSelctionView.closeButton.setOnMouseClicked(event -> this.closeModalDelegate.run());
        this.modalListSelctionView.validateButton.setOnMouseClicked(this::validateHandler);
        this.setSize(ModalConfiguration.ModalSize.MEDIUM);
        this.container.getChildren().setAll((Object[])new Node[]{this.modalListSelctionView});
        this.bindLifecycle();
    }

    protected void validateHandler(MouseEvent event) {
        if (this.selectModel.getSelectedItems() == null) {
            AppLogger.d("Empty contact list selected fo presentation");
            this.closeModalDelegate.run();
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            List<Id<Discussion>> discussionIds = this.selectModel.getSelectedItems().stream().map(state -> state.info().id()).toList();
            boolean succeed = Api.getMessageApi().forwardMessage(this.message, discussionIds);
            if (succeed && this.selectModel.getSelectedItems().size() == 1) {
                NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, ((DiscussionInfoWithState)this.selectModel.getSelectedItems().iterator().next()).getItemId()));
            }
        });
        this.closeModalDelegate.run();
    }

    @Override
    public Region getLayout() {
        return this.container;
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        ScrollbarOverlayHelper.removeListeners(this.discussionListViewController.getListView());
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        ScrollbarOverlayHelper.setupOverlayScrollbar(this.discussionListViewController.getListView());
    }
}

