/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.message.tasks.DraftsBackupTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.SetDraftJsonExpirationTask;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.DraftPreviewAttachment;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.DraftAttachmentsViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MessageComposerModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MoreOptionController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.preview.DraftLinkPreview;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.reply.ReplyController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionPalette;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionPaletteDelegate;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.animation.ScrollTransition;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ClipboardDelegate;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.EditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichToolBarController;
import io.olvid.windows.messenger.fx.misc.richtextfx.ScrollableEditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ToggleableArea;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.EphemeralMessageModalController;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.EphemeralMessageModalModel;
import io.olvid.windows.messenger.fx.modal.message_infos.view.HBoxList;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.ThrottledConsumer;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javax.imageio.ImageIO;

public class MessageComposerController
extends BaseViewController
implements ClipboardDelegate.MultiFilesAndImage,
RichStyledConfiguration {
    private static final BooleanProperty EPHEMERAL_MODE_GLOBAL = new SimpleBooleanProperty(false);
    public final HBoxList<OutboundAttachment, DraftPreviewAttachment> attachment_hbox;
    private final LiveDataListener<Integer> remainingDraftAttachmentToCreateListener;
    private final DiscussionViewModel discussionViewModel;
    private final BooleanProperty allDraftAttachmentsReady = new SimpleBooleanProperty(true);
    private final VBox root = new VBox();
    private final VBox messageComposerRoot = new VBox();
    private final HBox ephemeralMessageConfig = new HBox();
    private final StackPane toolbar_container = new StackPane();
    private final StackPane link_preview_container = new StackPane();
    private final StackPane reply_container = new StackPane();
    private final StackPane message_input_container = new StackPane();
    private final StackPane attachment_container = new StackPane();
    public final ScrollPane attachment_scrollpane = new ScrollPane();
    private final Button attachment_previous = new Button();
    private final Button attachment_next = new Button();
    private final Button more_button = new Button();
    private final Button emojiButton = new Button();
    private final Button send_button = new Button();
    private final ToggleButton ephemeral_settings_button = new ToggleButton();
    private final HBox messageSenderHbox = new HBox();
    private final Text ephemeralMessage = new Text("");
    private final Hyperlink ephemeralMessageConfigLink = new Hyperlink(ViewControllerHelper.getString("ephemeral_send_message_config_link"));
    private final BooleanProperty ephemeralEnabled = new SimpleBooleanProperty(false);
    private final MessageComposerModel messageComposerModel = new MessageComposerModel();
    private ScrollableEditableStyledArea messageInput;
    private final DraftAttachmentsViewModel draftAttachmentsViewModel;
    private ReplyController replyController;
    private Optional<Id<MessageRef>> messageRefListenerKey = Optional.empty();
    private Optional<Id<ContactRef>> contactListenerKey = Optional.empty();
    private final LiveDataListener<ContactInfoLiveData.ContactInfoState> contactListener = (newValue, oldValue) -> this.replyController.set((ContactInfoLiveData.ContactInfoState)newValue);
    private ThrottledConsumer runnable;
    private DraftLinkPreview draftLinkPreview;
    private final LiveDataListener<Optional<OutboundAttachment>> draftLinkPreviewListener = this::onDraftLinkPreviewChanged;
    private final BooleanProperty extendedComposer = new SimpleBooleanProperty(false);
    private static final double MIN_HEIGHT = 20.0;
    private static final double REDUCE_MAX_HEIGHT = 100.0;
    private static final double EXTENDED_MAX_HEIGHT = 240.0;
    private ReactionPalette emojiPalette;
    private final EphemeralMessageModalModel ephemeralMessageModalModel = new EphemeralMessageModalModel();
    private final LiveDataListener<Optional<DiscussionCustomization>> discussionCustomizationListener = (newDcOpt, oldDcOpt) -> {
        if (newDcOpt == null || newDcOpt.isEmpty()) {
            return;
        }
        DiscussionCustomization dc = (DiscussionCustomization)newDcOpt.get();
        ViewControllerHelper.smartUIUpdate(() -> {
            this.ephemeralMessageModalModel.setReadOnce(dc.isPrefDefaultSettingReadOnce());
            this.ephemeralMessageModalModel.visibilityDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingVisibilityDuration().orElse(null));
            this.ephemeralMessageModalModel.existenceDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingExistenceDuration().orElse(null));
            this.updateEphemeralMessageText();
            Discussion current = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
            if (current != null) {
                if (this.isGlobalEphemeralEnabled()) {
                    this.ensureEphemeralDraftIfEnabled(current);
                } else {
                    AsyncTaskExecutor.submitTask(new SetDraftJsonExpirationTask(current, false, null, null));
                }
            }
        });
    };
    private final LiveDataListener<Optional<MessageRefInfo>> messageRefListener = (newMsg, oldMsg) -> {
        if (newMsg.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.hideNode((Node)this.reply_container));
            return;
        }
        if (DiffUtils.areContentTheSame(newMsg, oldMsg)) {
            return;
        }
        MessageRefInfo messageRefInfo = (MessageRefInfo)newMsg.get();
        this.replyController.set(messageRefInfo);
        if (messageRefInfo.inboundMessage().isPresent()) {
            Id<ContactRef> senderId = messageRefInfo.inboundMessage().get().getSenderId();
            if (this.contactListenerKey.isPresent() && !this.contactListenerKey.get().equals(senderId)) {
                DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
            }
            DbCache.getInstance().contactRefInfoMapLiveData.addListener(senderId, this.contactListener);
            this.contactListenerKey = Optional.of(senderId);
        } else if (messageRefInfo.outboundMessage().isPresent() || messageRefInfo.ownedMessage().isPresent()) {
            if (this.contactListenerKey.isPresent()) {
                DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
                this.contactListenerKey = Optional.empty();
            }
            this.replyController.setOwnedIdentity();
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            ViewControllerHelper.showNode((Node)this.reply_container);
            this.messageInput.requestFocus();
        });
    };

    public MessageComposerController(DiscussionViewModel discussionViewModel) {
        this.discussionViewModel = discussionViewModel;
        this.ephemeralEnabled.addListener(t -> {
            if (this.ephemeralEnabled.get()) {
                this.messageComposerRoot.getStyleClass().add((Object)"input-text-container-ephemeral");
                this.ephemeralMessageConfig.setVisible(true);
                this.ephemeralMessageConfig.setManaged(true);
                this.updateEphemeralMessageText();
            } else {
                this.messageComposerRoot.getStyleClass().remove((Object)"input-text-container-ephemeral");
                this.ephemeralMessageConfig.setVisible(false);
                this.ephemeralMessageConfig.setManaged(false);
            }
        });
        this.initializeLayout();
        this.initMessageInput();
        this.draftAttachmentsViewModel = new DraftAttachmentsViewModel();
        this.attachment_hbox = new HBoxList<OutboundAttachment, DraftPreviewAttachment>(DraftPreviewAttachment.class, discussionViewModel::getDraftPreview);
        this.attachment_hbox.setPadding(new Insets(7.0, 16.0, 2.0, 16.0));
        this.attachment_hbox.setSpacing(12.0);
        this.attachment_scrollpane.setContent(this.attachment_hbox);
        this.attachment_hbox.plug(this.draftAttachmentsViewModel.getPureDraftAttachment());
        this.remainingDraftAttachmentToCreateListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> {
            this.draftAttachmentsViewModel.setAttachmentCountProperty((int)newValue);
            if (newValue == 0) {
                this.draftAttachmentsViewModel.setMaxAttachmentToDownload(0);
            }
            int old = Objects.requireNonNullElse(oldValue, 0);
            if (newValue > old) {
                this.draftAttachmentsViewModel.setMaxAttachmentToDownload((int)newValue);
            }
        });
        DiscussionSelectionModel.getInstance().getRemainingDraftAttachmentToCreate().addListener(this.remainingDraftAttachmentToCreateListener);
        this.initToolBar();
        this.initAttachmentContainer();
        this.handleScrollButton();
        this.initSendButton();
        this.initMoreButton();
        this.initEmojiButton();
        this.initReply();
        this.initDraftLinkPreview();
        this.ephemeralMessageModalModel.existenceDurationSecondsProperty().addListener((obs, oldVal, newVal) -> {
            if (this.ephemeralEnabled.get()) {
                this.updateEphemeralMessageText();
            }
        });
        this.ephemeralMessageModalModel.visibilityDurationSecondsProperty().addListener((obs, oldVal, newVal) -> {
            if (this.ephemeralEnabled.get()) {
                this.updateEphemeralMessageText();
            }
        });
        this.ephemeralMessageModalModel.readOnceProperty().addListener((obs, oldVal, newVal) -> {
            if (this.ephemeralEnabled.get()) {
                this.updateEphemeralMessageText();
            }
        });
        this.ephemeralMessageConfigLink.setOnMouseClicked(ignored -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new EphemeralMessageModalController(this.ephemeralMessageModalModel), false)));
        this.ephemeral_settings_button.setOnMouseClicked(ignored -> {
            Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
            boolean newState = !EPHEMERAL_MODE_GLOBAL.get();
            EPHEMERAL_MODE_GLOBAL.set(newState);
            if (newState) {
                this.ensureEphemeralDraftIfEnabled(discussion);
            } else {
                AsyncTaskExecutor.submitTask(new SetDraftJsonExpirationTask(discussion, false, null, null));
            }
        });
        this.ephemeralEnabled.bind((ObservableValue)EPHEMERAL_MODE_GLOBAL);
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().addListener(this::onCurrentDiscussionChanged);
        DiscussionSelectionModel.getInstance().getSelectedDiscussionCustomizationLiveData().addListener(this.discussionCustomizationListener);
        this.bindLifecycle();
    }

    public void initializeLayout() {
        this.link_preview_container.setVisible(false);
        this.link_preview_container.setManaged(false);
        this.toolbar_container.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        this.link_preview_container.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        this.reply_container.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        this.message_input_container.setPadding(new Insets(0.0, 16.0, 0.0, 16.0));
        VBox.setVgrow((Node)this.attachment_container, (Priority)Priority.SOMETIMES);
        this.attachment_scrollpane.setPrefWidth(100.0);
        this.attachment_scrollpane.getStyleClass().add((Object)"scroll-pane-attachment");
        StackPane.setAlignment((Node)this.attachment_scrollpane, (Pos)Pos.CENTER);
        this.attachment_previous.setMnemonicParsing(false);
        this.attachment_previous.setPrefHeight(40.0);
        this.attachment_previous.setPrefWidth(40.0);
        this.attachment_previous.setTranslateX(-8.0);
        StackPane.setAlignment((Node)this.attachment_previous, (Pos)Pos.TOP_LEFT);
        SvgSizeable attachmentPreviousICon = new SvgSizeable();
        attachmentPreviousICon.getStyleClass().addAll((Object[])new String[]{"icon-small", "svg-arrow-left"});
        this.attachment_previous.setGraphic((Node)attachmentPreviousICon);
        this.attachment_previous.getStyleClass().addAll((Object[])new String[]{"round-arrow-button", "shadow-middle"});
        StackPane.setMargin((Node)this.attachment_previous, (Insets)new Insets(15.0, 0.0, 7.0, 0.0));
        this.attachment_next.setMnemonicParsing(false);
        this.attachment_next.setPrefHeight(40.0);
        this.attachment_next.setPrefWidth(40.0);
        this.attachment_next.setTranslateX(-8.0);
        StackPane.setAlignment((Node)this.attachment_next, (Pos)Pos.TOP_RIGHT);
        SvgSizeable attachmentNextICon = new SvgSizeable();
        attachmentNextICon.getStyleClass().addAll((Object[])new String[]{"icon-small", "svg-arrow-right"});
        this.attachment_next.setGraphic((Node)attachmentNextICon);
        this.attachment_next.getStyleClass().addAll((Object[])new String[]{"round-arrow-button", "shadow-middle"});
        StackPane.setMargin((Node)this.attachment_next, (Insets)new Insets(15.0, 0.0, 7.0, 0.0));
        VBox.setMargin((Node)this.attachment_container, (Insets)new Insets(9.0, 0.0, 14.0, 0.0));
        this.attachment_container.getChildren().addAll((Object[])new Node[]{this.attachment_scrollpane, this.attachment_previous, this.attachment_next});
        SvgSizeable moreIcon = new SvgSizeable();
        moreIcon.getStyleClass().addAll(List.of("icon-large", "svg-plus", "icon-grey"));
        this.more_button.setGraphic((Node)moreIcon);
        this.more_button.getStyleClass().addAll(List.of("transparent-icon-button", "no-padding-button", "add-button"));
        HBox.setMargin((Node)this.more_button, (Insets)new Insets(0.0, 12.0, 0.0, 0.0));
        Region r = new Region();
        HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
        this.ephemeral_settings_button.setMnemonicParsing(false);
        Node ephemeralIcon = FxIcons.icon(FxIcons.AVG_PACE(null, (Paint)Color.GREY), 24.0, 24.0, 24.0, 24.0);
        ephemeralIcon.getStyleClass().addAll((Object[])new String[]{"icon-large", "icon-grey"});
        this.ephemeral_settings_button.setGraphic(ephemeralIcon);
        this.ephemeral_settings_button.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button", "no-padding-button"});
        HBox.setMargin((Node)this.ephemeral_settings_button, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        SvgSizeable sendButtonIcon = new SvgSizeable();
        sendButtonIcon.getStyleClass().addAll((Object[])new String[]{"icon-large", "svg-send-1", "icon-white", "svg"});
        this.send_button.setGraphic((Node)sendButtonIcon);
        this.send_button.setDefaultButton(true);
        this.send_button.setDisable(true);
        this.send_button.getStyleClass().addAll((Object[])new String[]{"send-button", "gradient-primary-icon-button"});
        this.messageSenderHbox.setAlignment(Pos.CENTER_RIGHT);
        this.messageSenderHbox.getStyleClass().add((Object)"sender-pane");
        this.messageSenderHbox.getChildren().addAll((Object[])new Node[]{this.more_button, this.emojiButton, r, this.ephemeral_settings_button, this.send_button});
        VBox.setMargin((Node)this.messageSenderHbox, (Insets)new Insets(0.0, 16.0, 16.0, 16.0));
        this.messageComposerRoot.getStylesheets().add((Object)"fx/discussions/discussion_view/messages/message_composer/message_composer.css");
        this.messageComposerRoot.setPadding(new Insets(12.0, 0.0, 0.0, 0.0));
        this.messageComposerRoot.getStyleClass().add((Object)"input-text-container");
        this.messageComposerRoot.getChildren().addAll((Object[])new Node[]{this.toolbar_container, this.link_preview_container, this.reply_container, this.message_input_container, this.attachment_container, this.messageSenderHbox});
        this.ephemeralMessage.getStyleClass().add((Object)"grey-text");
        this.ephemeralMessageConfig.setVisible(false);
        this.ephemeralMessageConfig.setManaged(false);
        this.ephemeralMessageConfig.setAlignment(Pos.CENTER);
        this.ephemeralMessageConfig.getChildren().addAll((Object[])new Node[]{this.ephemeralMessage, this.ephemeralMessageConfigLink});
        this.root.getChildren().addAll((Object[])new Node[]{this.ephemeralMessageConfig, this.messageComposerRoot});
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
    }

    public void handleNewFiles(List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        files = files.stream().filter(file -> !file.isDirectory()).toList();
        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        AsyncTaskExecutor.submitTask(new DraftsBackupTask((Id<Discussion>)discussion.getItemId(), this.getTrimmedMsgInput(), files));
    }

    @Override
    public void importFiles(List<File> files) {
        this.handleNewFiles(files);
    }

    @Override
    public void importImage(Image image) {
        try {
            BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            this.importImage(ImageUtils.MimeType.PNG, baos.toByteArray());
        }
        catch (IOException e) {
            this.logger.error("Cannot copy pasted image", e);
        }
    }

    @Override
    public void importImage(ImageUtils.MimeType mimeType, byte[] bytes) {
        Optional<DiscussionInfoWithState> discussionInfoWithState = this.discussionViewModel.getDbSelectedDiscussion().getValue();
        if (discussionInfoWithState.isEmpty()) {
            return;
        }
        Id<Discussion> id = discussionInfoWithState.get().info().id();
        AsyncTaskExecutor.submitTask(new DraftsBackupTask(id, this.getTrimmedMsgInput(), new DraftsBackupTask.DataInputStruct(bytes, mimeType.value)));
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().addListener(this.draftLinkPreviewListener);
    }

    @Override
    public void onLayoutDetached() {
        this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().removeListener(this.draftLinkPreviewListener);
    }

    public String getTrimmedMsgInput() {
        String text = this.messageInput.getText();
        if (text != null) {
            return text.trim();
        }
        return "";
    }

    private void initDraftLinkPreview() {
        this.draftLinkPreview = new DraftLinkPreview(this.discussionViewModel.getOpenGraphLruCache(), (DoubleExpression)this.messageComposerRoot.widthProperty());
        this.draftLinkPreview.setCloseAction(() -> AsyncTaskExecutor.submitTask(() -> {
            if (this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().getValue().isPresent()) {
                new DeleteDraftAttachmentsDbTask(this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().getValue().get()).run();
            }
        }));
        this.link_preview_container.getChildren().add((Object)this.draftLinkPreview);
        this.runnable = new ThrottledConsumer(last -> this.draftAttachmentsViewModel.fetchOpenGraph(this.getTrimmedMsgInput(), (Optional<String>)last), "app-link-preview-fetcher", 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCurrentDiscussionChanged(Discussion newDiscussion, Discussion oldDiscussion) {
        if (newDiscussion == null || newDiscussion.equals(oldDiscussion)) {
            return;
        }
        if (oldDiscussion != null) {
            AsyncTaskExecutor.submitTask(new DraftsBackupTask((Id<Discussion>)oldDiscussion.getItemId(), this.getTrimmedMsgInput(), Collections.emptyList()));
        }
        if (newDiscussion.getContactId().isPresent() || newDiscussion.getGroupId().isPresent()) {
            Map<Id<Discussion>, Optional<String>> map = DraftsBackupTask.draftPerDiscussion;
            synchronized (map) {
                Optional<String> body;
                if (DraftsBackupTask.draftPerDiscussion.containsKey(newDiscussion.getItemId())) {
                    body = DraftsBackupTask.draftPerDiscussion.get(newDiscussion.getItemId());
                } else {
                    Optional<OutboundMessage> outboundMessage = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)newDiscussion.getItemId());
                    if (outboundMessage.isPresent()) {
                        DraftsBackupTask.draftPerDiscussion.put((Id<Discussion>)newDiscussion.getItemId(), outboundMessage.get().getBody());
                    }
                    body = outboundMessage.flatMap(AbstractUserMessageGenerated::getBody);
                }
                ViewControllerHelper.smartUIUpdate(() -> this.messageInput.setText(body.orElse(null)));
            }
        }
        DiscussionCustomization dc = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)newDiscussion.getItemId());
        this.ephemeralMessageModalModel.setReadOnce(dc.isPrefDefaultSettingReadOnce());
        this.ephemeralMessageModalModel.visibilityDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingVisibilityDuration().orElse(null));
        this.ephemeralMessageModalModel.existenceDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingExistenceDuration().orElse(null));
        this.updateEphemeralMessageText();
    }

    private void onDraftLinkPreviewChanged(Optional<OutboundAttachment> newValue, Optional<OutboundAttachment> oldValue) {
        if (newValue == null || newValue.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> {
                this.draftLinkPreview.dispose();
                ViewControllerHelper.hideNode((Node)this.link_preview_container);
            });
            return;
        }
        if (newValue.get().equals(oldValue.orElse(null))) {
            return;
        }
        Fyle fyle = DbManager.getInstance().getFyleDao().get(newValue.get().getFyleId());
        if (fyle.getSha256().isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> {
                this.draftLinkPreview.dispose();
                ViewControllerHelper.hideNode((Node)this.link_preview_container);
            });
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            this.draftLinkPreview.setImageData(ImageHelper.ImageData.of((Id<Fyle>)fyle.getItemId(), fyle.getFilePath(), fyle.getSha256().get(), ((OutboundAttachment)newValue.get()).getMimeType()));
            ViewControllerHelper.showNode((Node)this.link_preview_container);
        });
    }

    private void initMessageInput() {
        this.messageInput = new ScrollableEditableStyledArea(this);
        ((EditableStyledArea)this.messageInput.getContent()).setMinHeight(20.0);
        ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(100.0);
        ((EditableStyledArea)this.messageInput.getContent()).maxWidthProperty().bind((ObservableValue)this.message_input_container.widthProperty());
        this.message_input_container.getChildren().add((Object)this.messageInput);
        this.messageComposerRoot.setOnMouseClicked(event -> this.messageInput.requestFocus());
        this.messageInput.setClipboardDelegate(this);
        this.messageInput.setAccessibleRole(AccessibleRole.BUTTON);
        this.messageInput.setAccessibleRoleDescription("Zone de composition");
        this.messageInput.setAccessibleText("Accessibility Text");
    }

    private void initReply() {
        this.replyController = new ReplyController(() -> AsyncTaskExecutor.submitTask(() -> {
            Optional<DiscussionInfoWithState> discussionInfoOpt = this.discussionViewModel.getDbSelectedDiscussion().getValue();
            if (discussionInfoOpt.isEmpty()) {
                return;
            }
            DiscussionInfoWithState discussionInfo = discussionInfoOpt.get();
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionInfo.id());
            Optional<OutboundMessage> outboundMessageOptional = this.messageComposerModel.getDraftMessage().getValue();
            if (outboundMessageOptional.isPresent() && outboundMessageOptional.get().getReplyToId().isPresent() && !discussion.getLastUserMessageRefId().equals(Optional.of(outboundMessageOptional.get().getReplyToId().get()))) {
                DbManager.getInstance().getMessageRefDao().customDeleteById(outboundMessageOptional.get().getReplyToId().get());
            }
            DiscussionApi.updateDraftReplyTo((Id<Discussion>)discussion.getItemId(), Optional.empty());
        }));
        this.reply_container.getChildren().add((Object)this.replyController.getLayout());
        ViewControllerHelper.hideNode((Node)this.reply_container);
        this.messageComposerModel.getDraftMessage().addListener((newValue, oldValue) -> {
            if (newValue == null) {
                return;
            }
            if (DiffUtils.areContentTheSame(oldValue, newValue)) {
                return;
            }
            if (newValue.isEmpty() || ((OutboundMessage)newValue.get()).getReplyToId().isEmpty()) {
                this.removeMessageRefListener();
                if (this.contactListenerKey.isPresent()) {
                    DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
                    this.contactListenerKey = Optional.empty();
                }
                ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.hideNode((Node)this.reply_container));
                return;
            }
            Id<MessageRef> replyToId = ((OutboundMessage)newValue.get()).getReplyToId().get();
            this.addMessageRefListener(replyToId);
        });
    }

    private void initAttachmentContainer() {
        this.attachment_container.managedProperty().bind((ObservableValue)this.attachment_container.visibleProperty());
        this.attachment_container.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.attachment_hbox.getChildren()).not());
        this.attachment_scrollpane.prefViewportHeightProperty().bind((ObservableValue)this.attachment_hbox.heightProperty());
        this.attachment_hbox.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (Math.abs(this.attachment_scrollpane.getHvalue() * (newValue.doubleValue() - this.attachment_scrollpane.widthProperty().get()) - (oldValue.doubleValue() - this.attachment_scrollpane.widthProperty().get())) < 0.01) {
                this.attachment_scrollpane.setHvalue(1.0);
            }
        });
        Rectangle loadBar = new Rectangle(0.0, 1.0);
        loadBar.getStyleClass().add((Object)"blue-shape");
        StackPane.setAlignment((Node)loadBar, (Pos)Pos.BOTTOM_LEFT);
        loadBar.widthProperty().bind((ObservableValue)this.attachment_container.widthProperty().multiply((ObservableNumberValue)Bindings.when((ObservableBooleanValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().isEqualTo(0)).then(0).otherwise((ObservableNumberValue)this.draftAttachmentsViewModel.attachmentCountPropertyProperty().divide((ObservableNumberValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().add(0.01)))));
        loadBar.visibleProperty().bind((ObservableValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().greaterThan(5));
        this.attachment_container.getChildren().add((Object)loadBar);
    }

    private void initMoreButton() {
        MoreOptionController moreOptionController = new MoreOptionController(this.more_button, this);
        this.more_button.setOnAction(event -> moreOptionController.display());
    }

    private void initEmojiButton() {
        Node icon = FxIcons.icon(FxIcons.SMILEY(null, (Paint)Color.GREY), 24.0, 20.0, 24.0, 20.0);
        this.emojiButton.setGraphic(icon);
        this.emojiButton.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button", "no-padding-button"});
        final ReactionViewModel emojiViewModel = new ReactionViewModel();
        ReactionPaletteDelegate emojiHandler = new ReactionPaletteDelegate(){

            @Override
            public void onAddReaction(String emoji) {
                ((EditableStyledArea)MessageComposerController.this.messageInput.getContent()).replaceSelection(emoji);
                MessageComposerController.this.messageInput.requestFocus();
            }

            @Override
            public void onRemoveReaction() {
            }

            @Override
            public List<String> getQuickAccessReactions() {
                return emojiViewModel.getquickReactions();
            }

            @Override
            public List<String> getCatalog() {
                return emojiViewModel.emojiCatalog();
            }

            @Override
            public int getCategoryStartIndex(int index) {
                return emojiViewModel.getCategoryStartIndex(index);
            }
        };
        this.emojiPalette = new ReactionPalette(this.getLayout().getScene(), emojiHandler, false, true);
        this.emojiButton.setOnAction(event -> {
            this.logger.debug("MessageComposerController::emojiButton show");
            this.emojiPalette.show(this.getLayout());
            this.logger.debug("MessageComposerController::emojiButton show");
        });
    }

    private void initToolBar() {
        RichToolBarController richToolBarController = new RichToolBarController((ToggleableArea)this.messageInput.getContent());
        this.toolbar_container.getChildren().add((Object)richToolBarController.toolBar);
        Button fullScreenButton = new Button();
        fullScreenButton.getStyleClass().add((Object)"transparent-icon-button");
        SvgSizeable svgSizeable = new SvgSizeable();
        svgSizeable.getStyleClass().addAll((Object[])new String[]{"svg-fullscreen", "icon-xsmall"});
        fullScreenButton.setGraphic((Node)svgSizeable);
        fullScreenButton.setOnAction(event -> {
            this.extendedComposer.set(!this.extendedComposer.get());
            boolean extended = this.extendedComposer.get();
            if (extended) {
                if (!fullScreenButton.getStyleClass().contains((Object)"active-button")) {
                    fullScreenButton.getStyleClass().add((Object)"active-button");
                }
                ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(240.0);
                ((EditableStyledArea)this.messageInput.getContent()).setPrefHeight(240.0);
            } else {
                fullScreenButton.getStyleClass().remove((Object)"active-button");
                ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(100.0);
                ((EditableStyledArea)this.messageInput.getContent()).setPrefHeight(-1.0);
            }
        });
        richToolBarController.toolBar.getItems().add((Object)fullScreenButton);
    }

    private void initSendButton() {
        BooleanBinding noAttachments = Bindings.isEmpty((ObservableList)this.attachment_hbox.getChildren());
        this.send_button.disableProperty().bind((ObservableValue)this.messageInput.isEmpty().and((ObservableBooleanValue)noAttachments).or((ObservableBooleanValue)this.draftAttachmentsViewModel.attachmentCountPropertyProperty().greaterThan(0)).or((ObservableBooleanValue)this.allDraftAttachmentsReady.not()));
        this.send_button.setOnAction(event -> this.scheduleOrSend());
        this.send_button.setAccessibleRole(AccessibleRole.BUTTON);
        this.send_button.setAccessibleRoleDescription("send button role description");
        this.send_button.setAccessibleText("Send button access text");
    }

    private void handleScrollButton() {
        this.attachment_scrollpane.setOnScroll(event -> {
            if (event.getDeltaX() == 0.0 && event.getDeltaY() != 0.0) {
                this.attachment_scrollpane.setHvalue(this.attachment_scrollpane.getHvalue() - event.getDeltaY() / this.attachment_hbox.getWidth());
            }
        });
        this.attachment_previous.setOnAction(event -> new ScrollTransition(this, false).play());
        this.attachment_next.setOnAction(event -> new ScrollTransition(this, true).play());
        this.attachment_next.visibleProperty().bind((ObservableValue)this.attachment_scrollpane.hvalueProperty().isNotEqualTo(1L).and((ObservableBooleanValue)this.attachment_hbox.widthProperty().greaterThan((ObservableNumberValue)this.attachment_scrollpane.widthProperty())));
        this.attachment_previous.visibleProperty().bind((ObservableValue)this.attachment_scrollpane.hvalueProperty().isNotEqualTo(0L).and((ObservableBooleanValue)this.attachment_hbox.widthProperty().greaterThan((ObservableNumberValue)this.attachment_scrollpane.widthProperty())));
    }

    private void scheduleOrSend() {
        this.logger.debug("Call scheduleOrSend");
        AsyncTaskExecutor.submitTask(() -> {
            if (this.runnable.getScheduledTask().isPresent()) {
                try {
                    this.logger.debug("Call wait for last link preview to be computed");
                    this.runnable.getScheduledTask().get().get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    AppLogger.e("MessageComposerController::scheduleOrSend blocking get threw an exception", e);
                }
            }
            this.sendMessageHandler();
        });
    }

    private void sendMessageHandler() {
        String body = this.messageInput.getText().trim();
        if (body.isEmpty() && this.draftAttachmentsViewModel.getPureDraftAttachmentsList().isEmpty()) {
            return;
        }
        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        if (discussion != null) {
            Optional<MessageRef> replyTo;
            Optional<OutboundMessage> draftMessageOpt = this.messageComposerModel.getDraftMessage().getValue();
            boolean markDiscussionAsRead = false;
            if (draftMessageOpt.isEmpty()) {
                replyTo = Optional.empty();
                markDiscussionAsRead = true;
            } else {
                Optional<Id<MessageRef>> replyToId = draftMessageOpt.get().getReplyToId();
                if (replyToId.isEmpty()) {
                    replyTo = Optional.empty();
                    markDiscussionAsRead = true;
                } else {
                    replyTo = Optional.ofNullable(DbManager.getInstance().getMessageRefDao().get(replyToId.get()));
                }
            }
            Api.getMessageApi().sendMessageDbTask(Optional.of(body), (Id<Discussion>)discussion.getItemId(), replyTo);
            Optional<String> removeRet = DraftsBackupTask.draftPerDiscussion.remove(discussion.getItemId());
            if (removeRet == null || removeRet.isEmpty()) {
                AppLogger.w("sendMessageHandler::sendMessageDbTask draft message was null...");
            }
            this.draftAttachmentsViewModel.updateOpenGraph(Optional.empty());
            ViewControllerHelper.smartUIUpdate(() -> {
                this.messageInput.clearWithoutDetections();
                this.messageInput.requestFocus();
            });
            this.ensureEphemeralDraftIfEnabled(discussion);
            if (markDiscussionAsRead) {
                DiscussionApi.markDiscussionMessagesAsReadUpTo((Id<Discussion>)discussion.getItemId(), Optional.empty());
                if (this.discussionViewModel.getSearchMode().not().get()) {
                    UIActionNC.fireScrollToBottom((Id<Discussion>)discussion.getItemId());
                }
            }
        } else {
            AppLogger.e("Unable to send message, no current discussion");
        }
    }

    private void addMessageRefListener(Id<MessageRef> messageRefId) {
        if (this.messageRefListenerKey.isPresent() && !this.messageRefListenerKey.get().equals(messageRefId)) {
            this.removeMessageRefListener();
        }
        if (this.messageRefListenerKey.isEmpty()) {
            this.discussionViewModel.addMessageRefListener(messageRefId, this.messageRefListener);
            this.messageRefListenerKey = Optional.of(messageRefId);
        }
    }

    private void removeMessageRefListener() {
        if (this.messageRefListenerKey.isPresent()) {
            this.discussionViewModel.removeMessageRefListener(this.messageRefListenerKey.get(), this.messageRefListener);
            this.messageRefListenerKey = Optional.empty();
        }
    }

    @Override
    public RichStyledConfiguration.DelimiterProcessing processDelimiter() {
        if (this.messageInput == null) {
            return RichStyledConfiguration.DelimiterProcessing.NONE;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN -> RichStyledConfiguration.DelimiterProcessing.STYLE;
            case EditableStyledArea.Mode.PLAIN_TO_RICH -> RichStyledConfiguration.DelimiterProcessing.DELETE_AND_RICH_REPLACE;
            case EditableStyledArea.Mode.RICH -> RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE;
        };
    }

    @Override
    public boolean applyStyle() {
        if (this.messageInput == null) {
            return false;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN, EditableStyledArea.Mode.PLAIN_TO_RICH -> true;
            case EditableStyledArea.Mode.RICH -> false;
        };
    }

    @Override
    public boolean applyBlockCodeStyle() {
        if (this.messageInput == null) {
            return false;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN -> true;
            case EditableStyledArea.Mode.PLAIN_TO_RICH, EditableStyledArea.Mode.RICH -> false;
        };
    }

    @Override
    public boolean enableLinkDetection() {
        return true;
    }

    @Override
    public boolean clickableLinks() {
        return false;
    }

    @Override
    public void linkFound(Optional<String> url) {
        this.logger.trace("MessageComposer::urlDetectionListener url detected");
        this.runnable.run(url.orElse(null));
    }

    @Override
    public void handlesend() {
        this.scheduleOrSend();
    }

    private void updateEphemeralMessageText() {
        Long existSecs = (Long)this.ephemeralMessageModalModel.existenceDurationSecondsProperty().get();
        Long visSecs = (Long)this.ephemeralMessageModalModel.visibilityDurationSecondsProperty().get();
        String existDurationLabel = MessageComposerController.formatDurationLabel(existSecs);
        String visDurationLabel = MessageComposerController.formatDurationLabel(visSecs);
        if (this.ephemeralMessageModalModel.isReadOnce()) {
            if (existSecs != null) {
                this.ephemeralMessage.setText(ViewControllerHelper.getString("ephemeral_send_message_read_once_and_existence_duration_label", existDurationLabel));
                return;
            }
            this.ephemeralMessage.setText(ViewControllerHelper.getString("ephemeral_send_message_read_once_label"));
            return;
        }
        if (existSecs != null) {
            if (visSecs != null && visSecs > 0L && existSecs > visSecs) {
                this.ephemeralMessage.setText(ViewControllerHelper.getString("ephemeral_send_message_existence_and_visibility_duration_label", visDurationLabel, existDurationLabel));
                return;
            }
            this.ephemeralMessage.setText(ViewControllerHelper.getString("ephemeral_send_message_existence_duration_label", existDurationLabel));
            return;
        }
        this.ephemeralMessage.setText(ViewControllerHelper.getString("ephemeral_send_message_visibility_duration_label", visDurationLabel));
    }

    private void ensureEphemeralDraftIfEnabled(Discussion discussion) {
        if (discussion == null) {
            return;
        }
        if (!this.isGlobalEphemeralEnabled()) {
            return;
        }
        boolean ro = this.ephemeralMessageModalModel.isReadOnce();
        Long vis = (Long)this.ephemeralMessageModalModel.visibilityDurationSecondsProperty().get();
        Long exist = (Long)this.ephemeralMessageModalModel.existenceDurationSecondsProperty().get();
        if (!ro && vis == null && exist == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(new SetDraftJsonExpirationTask(discussion, ro, vis, exist));
    }

    private boolean isGlobalEphemeralEnabled() {
        return EPHEMERAL_MODE_GLOBAL.get();
    }

    private static String formatDurationLabel(Long seconds) {
        if (seconds == null) {
            return ViewControllerHelper.getString("ephemeral_delay_ever_option");
        }
        long s = seconds;
        long day = 86400L;
        long hour = 3600L;
        long minute = 60L;
        if (s % day == 0L) {
            return MessageComposerController.plural(s / day, "unit_time_day", "unit_time_day_plural");
        }
        if (s % hour == 0L) {
            return MessageComposerController.plural(s / hour, "unit_time_hour", "unit_time_hour_plural");
        }
        if (s % minute == 0L) {
            return MessageComposerController.plural(s / minute, "unit_time_minute", "unit_time_minute_plural");
        }
        return MessageComposerController.plural(s, "unit_time_second", "unit_time_second_plural");
    }

    private static String plural(long value, String unit, String unitPlural) {
        String unitStr = ViewControllerHelper.getString(value > 1L ? unitPlural : unit);
        return value + " " + unitStr;
    }

    @Override
    public void handlenewline() {
        ((EditableStyledArea)this.messageInput.getContent()).replaceSelection(System.lineSeparator());
    }
}

