/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageAndPollItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.misc.Watches;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessageWithPollInfoMLD
extends MediatorLiveData<List<MessageAndPollItem>> {
    final LiveData<List<MessageItem>> messages;
    Optional<Id<Discussion>> currentDiscussion = Optional.empty();
    final Map<SortableItemId, PollInfo> votesPerPollMap = new LinkedHashMap<SortableItemId, PollInfo>();
    private final MapLiveData<Id<PollMessage>, Optional<PollMessage>> pollMessages;
    private final MapLiveData<Id<PollMessage>, List<PollMessageVote>> pollVoteMessages;

    public MessageWithPollInfoMLD(LiveData<List<MessageItem>> messageItemLD) {
        super(List.of());
        this.messages = messageItemLD;
        this.pollMessages = DbManager.getInstance().getPollMessageDao().getContextLiveData();
        this.pollVoteMessages = PollMessageVote.getVotesByPollLiveData();
        this.addSource(this.messages, (newValue, oldValue) -> {
            Optional newDiscussionId;
            Watches.Watch watch = Watches.getInstance().start("MessageWithPollInfoMLD::MessageItemListListener");
            Optional<Object> optional = newDiscussionId = newValue == null || newValue.isEmpty() ? Optional.empty() : Optional.of(((MessageItem)newValue.getFirst()).getDiscussionId());
            if (DiffUtils.areContentTheSame(newValue, oldValue)) {
                return;
            }
            for (SortableItemId sortable : this.votesPerPollMap.keySet()) {
                PollInfo pollInfo = this.votesPerPollMap.get(sortable);
                pollInfo.pollMessageListener.ifPresent(pollMessageSource -> this.removeSource(pollMessageSource.pollMessageLD));
                pollInfo.votesListener.ifPresent(pollMessageVotesSource -> this.removeSource(pollMessageVotesSource.pollMessageVotesLD));
            }
            this.votesPerPollMap.clear();
            if (newDiscussionId.isEmpty()) {
                this.consolidate();
                this.currentDiscussion = newDiscussionId;
                return;
            }
            this.currentDiscussion = newDiscussionId;
            for (MessageItem messageItem : newValue) {
                if (messageItem.getPollMessageId().isPresent()) {
                    LiveDataListener<Optional<PollMessage>> listener = this::pollMessageListener;
                    LiveData<Optional<PollMessage>> pollMessageLD = this.pollMessages.of(Optional.empty(), messageItem.getPollMessageId().get());
                    this.addSource(pollMessageLD, listener);
                    this.votesPerPollMap.put(messageItem.getItemId(), PollInfo.of(messageItem, Optional.empty(), List.of(), Optional.of(PollMessageSource.of(pollMessageLD, listener)), Optional.empty()));
                    continue;
                }
                this.votesPerPollMap.put(messageItem.getItemId(), PollInfo.of(messageItem, Optional.empty(), List.of(), Optional.empty(), Optional.empty()));
            }
            watch.stop();
            this.consolidate();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollMessageListener(Optional<PollMessage> newVal, Optional<PollMessage> oldVal) {
        Watches.Watch watch = Watches.getInstance().start("MessageWithPollInfoMLD::PollMessageListener");
        if (newVal.isEmpty()) {
            return;
        }
        HashMap<SortableItemId, PollInfo> votesLocal = new HashMap<SortableItemId, PollInfo>(this.votesPerPollMap.size());
        Map<SortableItemId, PollInfo> map = this.votesPerPollMap;
        synchronized (map) {
            votesLocal.putAll(this.votesPerPollMap);
        }
        ArrayList<PollInfo> toAdd = new ArrayList<PollInfo>();
        boolean consolidate = false;
        for (SortableItemId messageItemId : votesLocal.keySet()) {
            PollInfo pollInfo = (PollInfo)votesLocal.get(messageItemId);
            LiveDataListener<List<PollMessageVote>> listener = this::pollVoteMessagesListener;
            boolean samePoll = ((Id)newVal.get().getItemId()).equals(pollInfo.messageItem.getPollMessageId().orElse(null));
            if (!samePoll || !pollInfo.votesListener.isEmpty()) continue;
            LiveData<List<PollMessageVote>> pollMessageVotesLD = this.pollVoteMessages.of(List.of(), (Id<PollMessage>)newVal.get().getItemId());
            this.addSource(pollMessageVotesLD, listener);
            PollInfo newPollInfo = PollInfo.of(pollInfo.messageItem, newVal, List.of(), pollInfo.pollMessageListener, Optional.of(PollMessageVotesSource.of(pollMessageVotesLD, listener)));
            toAdd.add(newPollInfo);
            consolidate = true;
        }
        for (PollInfo pollInfo : toAdd) {
            this.votesPerPollMap.put(pollInfo.messageItem.getItemId(), pollInfo);
        }
        watch.stop();
        if (consolidate) {
            this.consolidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollVoteMessagesListener(List<PollMessageVote> newVotes, List<PollMessageVote> oldVotes) {
        boolean consolidate = false;
        Watches.Watch watch = Watches.getInstance().start("MessageWithPollInfoMLD::PollVotesListener");
        if (!newVotes.isEmpty()) {
            Id<PollMessage> pollMessageId = newVotes.getFirst().getPollMessageId().get();
            ArrayList<PollInfo> toAdd = new ArrayList<PollInfo>();
            HashMap<SortableItemId, PollInfo> votesLocal = new HashMap<SortableItemId, PollInfo>(this.votesPerPollMap.size());
            Iterator iterator = this.votesPerPollMap;
            synchronized (iterator) {
                votesLocal.putAll(this.votesPerPollMap);
            }
            for (SortableItemId messageItemId : votesLocal.keySet()) {
                PollInfo pollInfo = (PollInfo)votesLocal.get(messageItemId);
                if (!pollInfo.pollMessage.isPresent() || !((Id)pollInfo.pollMessage.get().getItemId()).equals(pollMessageId) || DiffUtils.areContentTheSame(newVotes, pollInfo.pollMessageVoteList)) continue;
                PollMessage fullPollInfo = DbManager.getInstance().getPollMessageDao().getFullPollInfo(pollInfo.pollMessage.get(), newVotes, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityId().get());
                PollInfo newPollInfo = PollInfo.of(pollInfo.messageItem, Optional.of(fullPollInfo), newVotes, pollInfo.pollMessageListener, pollInfo.votesListener);
                toAdd.add(newPollInfo);
                consolidate = true;
            }
            for (PollInfo pollInfo : toAdd) {
                this.votesPerPollMap.put(pollInfo.messageItem.getItemId(), pollInfo);
            }
        }
        watch.stop();
        if (consolidate) {
            this.consolidate();
        }
    }

    private synchronized void consolidate() {
        ArrayList<MessageAndPollItem> consolidatedMessages = new ArrayList<MessageAndPollItem>();
        Watches.Watch watch = Watches.getInstance().start("MessageWithPollInfoMLD::consolidate");
        for (SortableItemId messageItemId : this.votesPerPollMap.keySet()) {
            PollInfo pollInfo = this.votesPerPollMap.get(messageItemId);
            MessageAndPollItem toAdd = new MessageAndPollItem(pollInfo.messageItem, pollInfo.pollMessage, pollInfo.pollMessageVoteList);
            consolidatedMessages.add(toAdd);
        }
        watch.stop();
        this.postValue(consolidatedMessages);
    }

    record PollInfo(MessageItem messageItem, Optional<PollMessage> pollMessage, List<PollMessageVote> pollMessageVoteList, Optional<PollMessageSource> pollMessageListener, Optional<PollMessageVotesSource> votesListener) {
        public static PollInfo of(MessageItem messageItem, Optional<PollMessage> pollMessage, List<PollMessageVote> pollMessageVoteList, Optional<PollMessageSource> pollMessageListener, Optional<PollMessageVotesSource> votesListener) {
            return new PollInfo(messageItem, pollMessage, pollMessageVoteList, pollMessageListener, votesListener);
        }

        public boolean isFull() {
            return this.pollMessage.isPresent() && this.pollMessageListener.isPresent() && this.votesListener.isPresent();
        }
    }

    record PollMessageVotesSource(LiveData<List<PollMessageVote>> pollMessageVotesLD, LiveDataListener<List<PollMessageVote>> listener) {
        public static PollMessageVotesSource of(LiveData<List<PollMessageVote>> pollMessageLD, LiveDataListener<List<PollMessageVote>> listener) {
            return new PollMessageVotesSource(pollMessageLD, listener);
        }
    }

    record PollMessageSource(LiveData<Optional<PollMessage>> pollMessageLD, LiveDataListener<Optional<PollMessage>> listener) {
        public static PollMessageSource of(LiveData<Optional<PollMessage>> pollMessageLD, LiveDataListener<Optional<PollMessage>> listener) {
            return new PollMessageSource(pollMessageLD, listener);
        }
    }
}

