/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.text.Text;

public class MediatorInvitationController
implements Initializable {
    @FXML
    private Text invitation_message_info;
    @FXML
    private Text contact_name;
    @FXML
    private Text mediator_name;
    @FXML
    private Text frozen_invitation_label;
    @FXML
    private Button invitationAccept;
    @FXML
    private Button invitationDiscard;
    private final Invitation invitation;
    private final StringProperty discussionTitle;
    private final LiveDataListener<Optional<ContactInfo>> mediatorInfoChangeListener = this::mediatorInfoChangeListener;

    public MediatorInvitationController(Invitation invitation, StringProperty discussionTitle) {
        this.invitation = invitation;
        this.discussionTitle = discussionTitle;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Optional<ContactRef> mediatorOpt = this.invitation.getMediatorRef();
        if (mediatorOpt.isPresent() && mediatorOpt.get().getContactId().isPresent()) {
            DbCache.getInstance().contactInfoMapLiveData.addListener(mediatorOpt.get().getContactId().get(), this.mediatorInfoChangeListener);
        } else {
            this.updateInvitationMessageInfo(Optional.empty());
        }
        this.invitationAccept.setOnAction(this::handleInvitationAccept);
        this.invitationDiscard.setOnAction(this::handleInvitationDiscard);
    }

    private void removeListener() {
        Optional<Id<Contact>> contactId;
        if (this.invitation.getMediatorRef().isPresent() && (contactId = this.invitation.getMediatorRef().get().getContactId()).isPresent()) {
            DbCache.getInstance().contactInfoMapLiveData.removeListener(contactId.get(), this.mediatorInfoChangeListener);
        }
    }

    private void mediatorInfoChangeListener(Optional<ContactInfo> newValue, Optional<ContactInfo> oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        this.updateInvitationMessageInfo(newValue);
    }

    private void updateInvitationMessageInfo(Optional<ContactInfo> mediatorInfoOpt) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (mediatorInfoOpt.isEmpty()) {
                this.invitation_message_info.textProperty().bind((ObservableValue)ViewControllerHelper.getString("new_invitation_message", (ObservableStringValue)this.discussionTitle));
            } else {
                this.invitation_message_info.textProperty().bind((ObservableValue)ViewControllerHelper.getString("new_invitation_via_mediator_message", (ObservableStringValue)this.discussionTitle, (ObservableStringValue)new SimpleStringProperty(((ContactInfo)mediatorInfoOpt.get()).getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY))));
            }
        });
    }

    private void handleInvitationDiscard(ActionEvent actionEvent) {
        if (this.invitation.getState() == InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT && SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.answerIntroduction(this.invitation, false, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            this.invitationAccept.setDisable(true);
            this.invitationDiscard.setDisable(true);
            this.removeListener();
        }
    }

    private void handleInvitationAccept(ActionEvent actionEvent) {
        if (this.invitation.getState() == InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT && SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.answerIntroduction(this.invitation, true, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            this.invitationAccept.setDisable(true);
            this.invitationDiscard.setDisable(true);
            this.removeListener();
        }
    }
}

