/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class InvitationSasExchangeFragmentController
implements Initializable {
    @FXML
    private VBox sasExchangeVbox;
    @FXML
    private Text sasExchangeInfo;
    @FXML
    private TextFlow textflow;
    @FXML
    private Label myPin;
    @FXML
    private TextField theirPin;
    @FXML
    private Label their_pin_label;
    @FXML
    private Button discardSas;
    @FXML
    private Button validateSas;
    Invitation invitation;
    private final StringProperty discussionTitle;

    public InvitationSasExchangeFragmentController(Invitation invitation, StringProperty discussionTitle) {
        this.invitation = invitation;
        this.discussionTitle = discussionTitle;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.buildSasExchangeInfo();
        this.theirPin.visibleProperty().bind((ObservableValue)new SimpleBooleanProperty(this.invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE));
        this.validateSas.disableProperty().bind((ObservableValue)new SimpleBooleanProperty(this.invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE).not());
        this.validateSas.setOnAction(this::validateSas);
        this.discardSas.setOnAction(this::discardSas);
        InvitationSasExchangeFragmentController.addTextSizeLimiter(this.theirPin, 4);
        InvitationSasExchangeFragmentController.fieldAcceptsOnlyNumbers(this.theirPin);
    }

    private void buildSasExchangeInfo() {
        if (this.invitation != null) {
            SimpleStringProperty sasToDisplay = new SimpleStringProperty(new String(this.invitation.getSasToDisplay().orElse(new byte[0])));
            if (this.invitation.getSasToDisplay().isPresent()) {
                this.myPin.textProperty().bindBidirectional((Property)sasToDisplay);
            }
            this.sasExchangeInfo.textProperty().bind((ObservableValue)ViewControllerHelper.getString("invitation_status_description_enter_their_sas", (ObservableStringValue)this.discussionTitle, (ObservableStringValue)new SimpleStringProperty((String)sasToDisplay.get())));
        }
    }

    private void validateSas(ActionEvent actionEvent) {
        if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            if (!InvitationApi.submitSas(this.invitation, this.theirPin.getText(), SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity())) {
                this.invalidSasHandler();
            } else {
                this.validatingSasHandler();
            }
        }
    }

    private void discardSas(ActionEvent actionEvent) {
        if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.abortProtocol(this.invitation, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
        }
    }

    protected void validatingSasHandler() {
        ViewControllerHelper.smartUIUpdate(() -> {
            this.their_pin_label.getStyleClass().clear();
            this.their_pin_label.setText("Code bon !");
            this.their_pin_label.getStyleClass().add((Object)"their-pin-label-correct");
        });
    }

    protected void invalidSasHandler() {
        ViewControllerHelper.smartUIUpdate(() -> {
            this.their_pin_label.getStyleClass().clear();
            this.their_pin_label.setText("Code invalide");
            this.their_pin_label.getStyleClass().add((Object)"their-pin-label-incorrect");
        });
    }

    public static void addTextSizeLimiter(TextField textField, int maxLength) {
        textField.textProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.length() > maxLength) {
                textField.setText(oldValue);
            }
        });
    }

    public static void fieldAcceptsOnlyNumbers(TextField textField) {
        textField.textProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.matches("[0-9]*")) {
                textField.setText(oldValue);
            }
        });
    }
}

