/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.text.Text;

public class InvitationAcceptedFragmentController
implements Initializable {
    private final AppLogger loggerInstance = new AppLogger(this.getClass());
    @FXML
    private Text invitationInfoMessage;
    @FXML
    private Text contactName;
    @FXML
    private Button invitationDiscard;
    private final StringProperty discussionTitle;
    private final Invitation invitation;

    public InvitationAcceptedFragmentController(Invitation invitation, StringProperty discussionTitle) {
        this.discussionTitle = discussionTitle;
        this.invitation = invitation;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loggerInstance.debug("INIT StateHandlerView");
        this.contactName.textProperty().bind((ObservableValue)this.discussionTitle);
        this.invitationDiscard.setOnAction(this::handleInvitationDiscard);
    }

    private void handleInvitationDiscard(ActionEvent actionEvent) {
        this.loggerInstance.debug("handleInvitationDiscard");
        if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.abortProtocol(this.invitation, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            this.invitationDiscard.setDisable(true);
        }
    }
}

