/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationAcceptedFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationOneToOneReceivedFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationOneToOneSentFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationReceivedFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationSasConfirmedFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationSasExchangeFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.InvitationSentFragmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.MediatorInvitationController;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class EmbeddedInvitationList
extends VBox {
    private LiveData<List<Invitation>> invitationsLiveData;
    private final LiveDataListener<List<Invitation>> invitationChangeListener = this::onInvitationChanged;
    private final StringProperty discussionTitle = new SimpleStringProperty();

    public EmbeddedInvitationList() {
        this.invitationsLiveData = LiveDataFactory.switchMap(DiscussionSelectionModel.getInstance().getSelectedDiscussionInfoLiveData(), discussion -> {
            if (discussion.isPresent()) {
                ViewControllerHelper.smartUIUpdate(() -> this.discussionTitle.set((Object)((DiscussionInfo)discussion.get()).title().orElse(null)));
                return LiveDataFactory.buildDbLiveDataList(Invitation.class, () -> DbManager.getInstance().getInvitationDao().getSortedInvitationForDiscussion(((DiscussionInfo)discussion.get()).id()));
            }
            return null;
        });
        this.invitationsLiveData.addListener(this.invitationChangeListener);
    }

    private void onInvitationChanged(List<Invitation> newInvitation, List<Invitation> oldInvitation) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newInvitation == null || newInvitation.size() == 0) {
                this.clearChildren();
                return;
            }
            this.clearChildren();
            for (Invitation invitation : newInvitation) {
                Node node = this.createInvitationNode(invitation);
                if (node == null) continue;
                this.attachNode(node);
            }
        });
    }

    private Node createInvitationNode(Invitation invitation) {
        switch (invitation.getState()) {
            case INVITATION_WAIT_IT_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationSentFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_sent_state_fragment.fxml");
            }
            case INVITATION_STATUS_IN_PROGRESS: 
            case GROUP_V2_INVITATION_FROZEN: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationAcceptedFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_accepted_fragment.fxml");
            }
            case INVITATION_WAIT_YOU_TO_ACCEPT: 
            case GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT: 
            case GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationReceivedFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_initial_fragment.fxml");
            }
            case INVITATION_WAIT_IT_FOR_SAS_EXCHANGE: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationSasConfirmedFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_sas_confirmed_fragment.fxml");
            }
            case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: {
                InvitationSasExchangeFragmentController invitationSasExchangeFragmentController = new InvitationSasExchangeFragmentController(invitation, this.discussionTitle);
                return ViewControllerHelper.loadNodeWithExplicitController(invitationSasExchangeFragmentController, "fx/discussions/discussion_view/invitation_embedded/invitation_sas_exchange_fragment.fxml");
            }
            case INTRODUCTION_WAIT_YOU_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new MediatorInvitationController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_via_mediator_state_controller.fxml");
            }
            case ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationOneToOneSentFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_one_to_one_sent_fragment.fxml");
            }
            case ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationOneToOneReceivedFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_one_to_one_received_fragment.fxml");
            }
            case INTRODUCTION_WAIT_IT_TO_ACCEPT: {
                return ViewControllerHelper.loadNodeWithExplicitController(new InvitationSentFragmentController(invitation, this.discussionTitle), "fx/discussions/discussion_view/invitation_embedded/invitation_sent_state_fragment.fxml");
            }
        }
        return null;
    }

    public void clearChildren() {
        ViewControllerHelper.smartUIUpdate(() -> this.getChildren().removeAll((Collection)this.getChildren()));
    }

    public void attachNode(Node node) {
        ViewControllerHelper.smartUIUpdate(() -> this.getChildren().add(0, (Object)node));
    }
}

