/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewState;
import io.olvid.windows.messenger.fx.discussions.discussion_view.save.AttachmentSaveUtils;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.AttachmentProgressCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;

public abstract class PreviewAttachmentController<Attachment extends AbstractAttachmentGenerated<Attachment>, Preview extends PreviewUtils.Preview, Progress>
implements DiffUtils.NodeController<Attachment>,
LiveDataListener<Map<Id<Attachment>, Progress>> {
    private final Preview preview;
    protected Attachment attachment;
    private boolean listenProgressCache = false;

    public PreviewAttachmentController(Preview preview) {
        this.preview = preview;
    }

    protected abstract PreviewState getState(Attachment var1);

    protected abstract float getProgress(Progress var1);

    protected abstract LiveData<Map<Id<Attachment>, Progress>> getProgressLiveData();

    @Override
    public void update(Attachment attachment) {
        this.attachment = attachment;
        if (attachment == null) {
            return;
        }
        PreviewState state = this.getState(attachment);
        Optional<Long> size = ((AbstractAttachmentGenerated)attachment).getSize() > 0L ? Optional.of(((AbstractAttachmentGenerated)attachment).getSize()) : Optional.empty();
        FileExtension fileExtension = PreviewUtils.toFileExtension(attachment);
        this.preview.update((AbstractAttachmentGenerated<?>)attachment, ((AbstractAttachmentGenerated)attachment).getFilename(), fileExtension, size, state);
        if (state == PreviewState.PROCESSING || state == PreviewState.UPLOADING) {
            this.plugProgress();
        } else {
            this.unplugProgress();
        }
    }

    public void updateProgress(Optional<Float> progress) {
        this.preview.setProgress(progress);
    }

    private void plugProgress() {
        if (this.listenProgressCache) {
            return;
        }
        LiveData<Map<Id<Attachment>, Progress>> progressLiveData = this.getProgressLiveData();
        progressLiveData.addListener(this);
        this.listenProgressCache = true;
    }

    private void unplugProgress() {
        if (!this.listenProgressCache) {
            return;
        }
        LiveData<Map<Id<Attachment>, Progress>> progressLiveData = this.getProgressLiveData();
        progressLiveData.removeListener(this);
        this.listenProgressCache = false;
    }

    @Override
    public void dispose() {
        this.attachment = null;
        this.preview.dispose();
        this.unplugProgress();
    }

    @Override
    public Attachment getValue() {
        return this.attachment;
    }

    @Override
    public void onChange(Map<Id<Attachment>, Progress> newValue, Map<Id<Attachment>, Progress> oldValue) {
        if (this.attachment == null) {
            ViewControllerHelper.smartUIUpdate(() -> this.updateProgress(Optional.empty()));
            return;
        }
        Progress progress = newValue.get(((AbstractTableGenerated)this.attachment).getItemId());
        if (progress == null) {
            ViewControllerHelper.smartUIUpdate(() -> this.updateProgress(Optional.empty()));
            return;
        }
        float progressValue = this.getProgress(progress);
        ViewControllerHelper.smartUIUpdate(() -> this.updateProgress(Optional.of(Float.valueOf(progressValue))));
    }

    public Preview getPreview() {
        return this.preview;
    }

    @Override
    public Node getNode() {
        return this.preview.getLayout();
    }

    public static final class Draft<Preview extends PreviewUtils.Preview>
    extends PreviewAttachmentController<OutboundAttachment, Preview, Float> {
        public Draft(Preview preview) {
            super(preview);
        }

        @Override
        protected LiveData<Map<Id<OutboundAttachment>, Float>> getProgressLiveData() {
            return AttachmentProgressCache.getInstance().getCopyingProgressLiveData();
        }

        @Override
        protected PreviewState getState(OutboundAttachment attachment) {
            return switch (attachment.getStatus()) {
                default -> throw new MatchException(null, null);
                case OutboundAttachmentGenerated.Status.DRAFT_READY, OutboundAttachmentGenerated.Status.UNPROCESSED, OutboundAttachmentGenerated.Status.CANCELLED, OutboundAttachmentGenerated.Status.SENT, OutboundAttachmentGenerated.Status.DELIVERED, OutboundAttachmentGenerated.Status.READ, OutboundAttachmentGenerated.Status.NO_CONTACT_RECIPIENTS -> PreviewState.READY;
                case OutboundAttachmentGenerated.Status.UPLOADING -> PreviewState.UPLOADING;
                case OutboundAttachmentGenerated.Status.COPYING -> PreviewState.PROCESSING;
                case OutboundAttachmentGenerated.Status.FAILED -> {
                    AppLogger.e("getDisplayState: attachment status is FAILED");
                    yield PreviewState.PROCESSING;
                }
            };
        }

        @Override
        protected float getProgress(Float value) {
            return value == null ? 0.0f : value.floatValue();
        }
    }

    public static final class Outbound<Preview extends PreviewUtils.Preview>
    extends PreviewAttachmentController<OutboundAttachment, Preview, AttachmentProgressCache.UploadInfo> {
        public Outbound(Preview preview) {
            super(preview);
        }

        @Override
        protected LiveData<Map<Id<OutboundAttachment>, AttachmentProgressCache.UploadInfo>> getProgressLiveData() {
            return AttachmentProgressCache.getInstance().getUploadProgressLiveData();
        }

        @Override
        protected PreviewState getState(OutboundAttachment attachment) {
            return switch (attachment.getStatus()) {
                default -> throw new MatchException(null, null);
                case OutboundAttachmentGenerated.Status.DRAFT_READY, OutboundAttachmentGenerated.Status.UNPROCESSED, OutboundAttachmentGenerated.Status.CANCELLED, OutboundAttachmentGenerated.Status.SENT, OutboundAttachmentGenerated.Status.DELIVERED, OutboundAttachmentGenerated.Status.READ, OutboundAttachmentGenerated.Status.NO_CONTACT_RECIPIENTS -> PreviewState.READY;
                case OutboundAttachmentGenerated.Status.UPLOADING -> PreviewState.UPLOADING;
                case OutboundAttachmentGenerated.Status.COPYING -> PreviewState.PROCESSING;
                case OutboundAttachmentGenerated.Status.FAILED -> {
                    AppLogger.e("getDisplayState: attachment status is FAILED");
                    yield PreviewState.PROCESSING;
                }
            };
        }

        @Override
        protected float getProgress(AttachmentProgressCache.UploadInfo uploadInfo) {
            return uploadInfo.progress();
        }

        @Override
        public void update(OutboundAttachment outboundAttachment) {
            super.update(outboundAttachment);
            this.getPreview().setAction(Optional.of(() -> AttachmentSaveUtils.save(AttachmentInfos.of((OutboundAttachment)this.attachment))));
        }
    }

    public static final class Owned<Preview extends PreviewUtils.Preview>
    extends Received<OwnedAttachment, Preview> {
        public Owned(Preview preview) {
            super(preview);
        }

        @Override
        protected LiveData<Map<Id<OwnedAttachment>, Float>> getProgressLiveData() {
            return AttachmentProgressCache.getInstance().getOwnedDownloadProgressLiveData();
        }
    }

    public static final class Inbound<Preview extends PreviewUtils.Preview>
    extends Received<InboundAttachment, Preview> {
        public Inbound(Preview preview) {
            super(preview);
        }

        @Override
        protected LiveData<Map<Id<InboundAttachment>, Float>> getProgressLiveData() {
            return AttachmentProgressCache.getInstance().getInboundDownloadProgressLiveData();
        }
    }

    private static abstract class Received<Attachment extends ReceivedAttachmentGenerated<Attachment>, Preview extends PreviewUtils.Preview>
    extends PreviewAttachmentController<Attachment, Preview, Float> {
        protected Received(Preview preview) {
            super(preview);
        }

        @Override
        protected float getProgress(Float value) {
            return value == null ? 0.0f : value.floatValue();
        }

        @Override
        protected PreviewState getState(Attachment attachment) {
            return switch (((ReceivedAttachmentGenerated)attachment).getStatus()) {
                default -> throw new MatchException(null, null);
                case ReceivedAttachmentGenerated.Status.DOWNLOADABLE -> PreviewState.DOWNLOADABLE;
                case ReceivedAttachmentGenerated.Status.DOWNLOADING -> PreviewState.PROCESSING;
                case ReceivedAttachmentGenerated.Status.COMPLETE -> PreviewState.READY;
                case ReceivedAttachmentGenerated.Status.DOWNLOAD_FAILED -> {
                    AppLogger.e("getDisplayState: attachment status is DOWNLOAD_FAILED");
                    yield PreviewState.PROCESSING;
                }
            };
        }

        @Override
        public void update(Attachment attachment) {
            super.update(attachment);
            if (attachment == null) {
                return;
            }
            PreviewState state = this.getState(attachment);
            switch (state) {
                case DOWNLOADABLE: {
                    this.getPreview().setAction(Optional.of(() -> {
                        byte[] engineMessageIdentifier = attachment.getEngineMessageIdentifier();
                        SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().ifPresent(ownedIdentityInfo -> Api.getAttachmentApi().downloadLargeAttachment(ownedIdentityInfo.bytesOwnedIdentity(), attachment.getItemId(), engineMessageIdentifier, attachment.getIdx()));
                    }));
                    break;
                }
                case PROCESSING: {
                    break;
                }
                case READY: {
                    this.getPreview().setAction(Optional.of(() -> AttachmentSaveUtils.save(AttachmentInfos.of(attachment))));
                }
            }
        }
    }
}

